/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AdvancedFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.tests.workbench.SampleToolControl;
import org.eclipse.e4.ui.tests.workbench.SampleView;
import org.eclipse.e4.ui.widgets.CTabFolder;
import org.eclipse.e4.ui.widgets.CTabItem;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.addons.cleanupaddon.CleanupAddon;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class PartRenderingEngineTests
extends TestCase {
    protected IEclipseContext appContext;
    protected E4Workbench wb;
    private LogListener listener = new LogListener(){

        public void logged(LogEntry entry) {
            if (!PartRenderingEngineTests.this.logged) {
                PartRenderingEngineTests.this.logged = entry.getLevel() == 1;
            }
        }
    };
    private boolean logged = false;

    protected void setUp() throws Exception {
        this.logged = false;
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"platform:/plugin/org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
        LogReaderService logReaderService = (LogReaderService)this.appContext.get(LogReaderService.class);
        logReaderService.addLogListener(this.listener);
    }

    protected void tearDown() throws Exception {
        LogReaderService logReaderService = (LogReaderService)this.appContext.get(LogReaderService.class);
        logReaderService.removeLogListener(this.listener);
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    private void checkLog() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {}
        PartRenderingEngineTests.assertFalse((boolean)this.logged);
    }

    private void spinEventLoop() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public void testCreateViewBug298415() {
        MWindow window = this.createWindowWithOneView("Part Name");
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        IPresentationEngine renderer = (IPresentationEngine)this.appContext.get(IPresentationEngine.class.getName());
        renderer.removeGui((MUIElement)part);
        renderer.removeGui((MUIElement)window);
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public void testAddWindowBug299219() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertNotNull((Object)window.getWidget());
        MWindow window2 = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window2);
        PartRenderingEngineTests.assertNotNull((Object)window2.getWidget());
    }

    public void testPartStack_SetActiveChildBug299379() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        EPartService service = (EPartService)window.getContext().get(EPartService.class.getName());
        service.activate(partB);
        PartRenderingEngineTests.assertEquals((String)"Activating another part should've altered the tab folder's selection", (int)1, (int)tabFolder.getSelectionIndex());
    }

    public void testPartStack_SetActiveChild2Bug299379() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        stack.setSelectedElement((MUIElement)partA);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        EPartService service = (EPartService)window.getContext().get(EPartService.class.getName());
        service.showPart(partB.getElementId(), EPartService.PartState.ACTIVATE);
        PartRenderingEngineTests.assertEquals((String)"Showing a part should alter the tab folder's selection", (int)1, (int)tabFolder.getSelectionIndex());
    }

    public void testPartStack_SetActiveChild3Bug299379() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MPartDescriptor descriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        descriptor.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        descriptor.setElementId("part");
        descriptor.setCategory("aStack");
        application.getDescriptors().add(descriptor);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        stack.getTags().add("aStack");
        window.getChildren().add(stack);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getItemCount());
        EPartService service = (EPartService)window.getContext().get(EPartService.class.getName());
        MPart shownPart = service.showPart("part", EPartService.PartState.ACTIVATE);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getItemCount());
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((String)"The shown part should be the active part", (Object)shownPart, (Object)stack.getSelectedElement());
    }

    public void testPartStack_SetActiveChild4Bug299379() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        stack.setSelectedElement((MUIElement)partB);
        PartRenderingEngineTests.assertEquals((String)"Switching the active child should've changed the folder's selection", (int)1, (int)tabFolder.getSelectionIndex());
    }

    public void testPartStack_SetActiveChild5Bug295250() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertEquals((Object)partA, (Object)stack.getSelectedElement());
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partB);
        PartRenderingEngineTests.assertEquals((String)"Adding a part to a stack should not cause the stack's active child to change", (Object)partA, (Object)stack.getSelectedElement());
        PartRenderingEngineTests.assertNull((String)"The object should not have been instantiated", (Object)partB.getObject());
    }

    public void testPartStack_SetActiveChild6Bug298797() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partA, (Object)stack.getSelectedElement());
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partB);
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partA, (Object)stack.getSelectedElement());
        stack.setSelectedElement((MUIElement)partB);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partB, (Object)stack.getSelectedElement());
    }

    public void testCreateGuiBug301021() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MPartDescriptor descriptor = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        descriptor.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        descriptor.setElementId("part");
        descriptor.setCategory("aStack");
        application.getDescriptors().add(descriptor);
        MPartDescriptor descriptor2 = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        descriptor2.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        descriptor2.setElementId("part2");
        descriptor2.setCategory("aStack");
        application.getDescriptors().add(descriptor2);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        MPartSashContainer partSashContainer = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        stack.setElementId("aStack");
        partSashContainer.getChildren().add(stack);
        window.getChildren().add(partSashContainer);
        application.getChildren().add(window);
        MWindow window2 = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window2);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        IPresentationEngine engine = (IPresentationEngine)this.appContext.get(IPresentationEngine.class);
        engine.createGui((MUIElement)window2);
        EPartService service = (EPartService)window2.getContext().get(EPartService.class.getName());
        service.showPart("part", EPartService.PartState.VISIBLE);
        service.showPart("part", EPartService.PartState.CREATE);
        service.showPart("part2", EPartService.PartState.CREATE);
        while (Display.getDefault().readAndDispatch()) {
        }
    }

    public void testPart_ToBeRendered() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        EPartService service = (EPartService)window.getContext().get(EPartService.class.getName());
        service.activate(partB);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getSelectionIndex());
        partB.setToBeRendered(false);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getItemCount());
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partA, (Object)stack.getSelectedElement());
    }

    public void testPart_ToBeRendered2() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partB.setToBeRendered(false);
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        stack.setSelectedElement((MUIElement)partA);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getItemCount());
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        partB.setToBeRendered(true);
        PartRenderingEngineTests.assertEquals((String)"Rendering another part in the stack should not change the selection", (int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partA, (Object)stack.getSelectedElement());
        PartRenderingEngineTests.assertEquals((int)2, (int)tabFolder.getItemCount());
        PartRenderingEngineTests.assertNotNull((Object)partB.getObject());
    }

    public void testClientObjectUnsetWhenNotRenderedBug301439() {
        MWindow window = this.createWindowWithOneView("");
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        PartRenderingEngineTests.assertNotNull((Object)part.getWidget());
        PartRenderingEngineTests.assertNotNull((Object)part.getRenderer());
        PartRenderingEngineTests.assertNotNull((Object)part.getObject());
        part.setToBeRendered(false);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertNull((Object)part.getWidget());
        PartRenderingEngineTests.assertNull((Object)part.getRenderer());
        PartRenderingEngineTests.assertNull((Object)part.getObject());
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getItemCount());
    }

    public void testCTabItem_SetControl_Bug304211() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.setSelectedElement((MUIElement)partA);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        IPresentationEngine engine = (IPresentationEngine)this.appContext.get(IPresentationEngine.class.getName());
        CTabFolder folder = (CTabFolder)stack.getWidget();
        CTabItem itemA = folder.getItem(0);
        PartRenderingEngineTests.assertEquals((String)"The presentation engine should have created the part and set it", (Object)partA.getWidget(), (Object)itemA.getControl());
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partB);
        CTabItem item2 = folder.getItem(1);
        PartRenderingEngineTests.assertNull((String)"For a stack, the object will not be rendered unless explicitly required", (Object)item2.getControl());
        engine.createGui((MUIElement)partB);
        PartRenderingEngineTests.assertEquals((String)"The presentation engine should have created the part and set it", (Object)partB.getWidget(), (Object)item2.getControl());
        stack.setSelectedElement((MUIElement)partB);
        PartRenderingEngineTests.assertEquals((String)"Selecting the element should not have changed anything", (Object)partB.getWidget(), (Object)item2.getControl());
    }

    public void testToBeRenderedCausesSelectionChanges() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        EPartService service = (EPartService)window.getContext().get(EPartService.class.getName());
        service.activate(partB);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getSelectionIndex());
        service.activate(partA);
        partA.setToBeRendered(false);
        PartRenderingEngineTests.assertEquals((int)1, (int)tabFolder.getItemCount());
        PartRenderingEngineTests.assertEquals((int)0, (int)tabFolder.getSelectionIndex());
        PartRenderingEngineTests.assertEquals((Object)partB, (Object)stack.getSelectedElement());
    }

    public void testSetSelectedElement() {
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        MPart partC = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        boolean causedException = false;
        try {
            stack.setSelectedElement((MUIElement)partA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            causedException = true;
        }
        PartRenderingEngineTests.assertFalse((String)"Exception should not have been thrown", (boolean)causedException);
        causedException = false;
        try {
            stack.setSelectedElement((MUIElement)partC);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            causedException = true;
        }
        PartRenderingEngineTests.assertTrue((String)"Exception should have been thrown", (boolean)causedException);
    }

    public void testSelectedElementNullingTBR() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartSashContainer container = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        window.getChildren().add(container);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partC = BasicFactoryImpl.eINSTANCE.createPart();
        partC.setElementId("partC");
        partC.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        container.getChildren().add(partA);
        container.getChildren().add(partB);
        container.getChildren().add(partC);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        container.setSelectedElement((MUIElement)partA);
        partB.setToBeRendered(false);
        PartRenderingEngineTests.assertTrue((String)"Changing the TBR of a non-selected element should not change the value of the container's seletedElement", (container.getSelectedElement() == partA ? 1 : 0) != 0);
        container.setSelectedElement((MUIElement)partA);
        partA.setToBeRendered(false);
        PartRenderingEngineTests.assertTrue((String)"Changing the TBR of the selected element should have set the field to null", (container.getSelectedElement() == null ? 1 : 0) != 0);
    }

    public void testSelectedElementNullingParentChange() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        MPartSashContainer container = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        window.getChildren().add(container);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setElementId("partA");
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setElementId("partB");
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partC = BasicFactoryImpl.eINSTANCE.createPart();
        partC.setElementId("partC");
        partC.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        container.getChildren().add(partA);
        container.getChildren().add(partB);
        container.getChildren().add(partC);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        container.setSelectedElement((MUIElement)partA);
        container.getChildren().remove(partB);
        PartRenderingEngineTests.assertTrue((String)"Changing the parent of a non-selected element should not change the value of the container's seletedElement", (container.getSelectedElement() == partA ? 1 : 0) != 0);
        container.setSelectedElement((MUIElement)partA);
        container.getChildren().remove(partA);
        PartRenderingEngineTests.assertTrue((String)"Changing the parent of the selected element should have set the field to null", (container.getSelectedElement() == null ? 1 : 0) != 0);
    }

    public void testCreateGuiBug301950() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getChildren().add(part);
        IPresentationEngine renderer = (IPresentationEngine)this.appContext.get(IPresentationEngine.class.getName());
        renderer.createGui((MUIElement)part);
        renderer.removeGui((MUIElement)part);
        while (Display.getCurrent().readAndDispatch()) {
        }
    }

    public void testRemoveGuiBug307578() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.setSelectedElement((MUIElement)partA);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        PartRenderingEngineTests.assertEquals((int)2, (int)folder.getItemCount());
        PartRenderingEngineTests.assertNull((Object)partB.getRenderer());
        PartRenderingEngineTests.assertNull((Object)partB.getObject());
        PartRenderingEngineTests.assertNull((Object)partB.getWidget());
        IPresentationEngine renderer = (IPresentationEngine)this.appContext.get(IPresentationEngine.class.getName());
        renderer.removeGui((MUIElement)partB);
        PartRenderingEngineTests.assertEquals((int)1, (int)folder.getItemCount());
    }

    public void testRemoveGuiBug324033() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(partB);
        MPart partC = BasicFactoryImpl.eINSTANCE.createPart();
        partC.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertNotNull((Object)partA.getObject());
        PartRenderingEngineTests.assertNull((Object)partB.getObject());
        ((IPresentationEngine)this.appContext.get(IPresentationEngine.class)).removeGui((MUIElement)partC);
        ((IPresentationEngine)this.appContext.get(IPresentationEngine.class)).removeGui((MUIElement)partStack);
        PartRenderingEngineTests.assertNull((Object)partA.getObject());
        PartRenderingEngineTests.assertNull((Object)partB.getObject());
    }

    public void testRemoveGuiBug323496() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPlaceholder placeholder = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholder.setRef((MUIElement)part);
        part.setCurSharedRef(placeholder);
        perspective.getChildren().add(placeholder);
        perspective.setSelectedElement((MUIElement)placeholder);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertNotNull((Object)part.getObject());
        ((IPresentationEngine)this.appContext.get(IPresentationEngine.class)).removeGui((MUIElement)perspective);
        PartRenderingEngineTests.assertNull((Object)part.getObject());
    }

    public void testBug324839() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        application.setContext(this.appContext);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(partB);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertNotNull((Object)partA.getObject());
        PartRenderingEngineTests.assertNull((Object)partB.getObject());
        ((EPartService)this.appContext.get(EPartService.class)).hidePart(partA, true);
        PartRenderingEngineTests.assertNull((Object)partA.getObject());
        PartRenderingEngineTests.assertNotNull((Object)partB.getObject());
    }

    public void testBug317591_NonSharedPart() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.setSelectedElement((MUIElement)partA);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertNotNull((Object)partA.getObject());
        stack.setToBeRendered(false);
        PartRenderingEngineTests.assertNull((Object)partA.getObject());
    }

    public void testBug317591_SharedPart() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MPartDescriptor descriptorA = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        descriptorA.setElementId("sharedA");
        descriptorA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        application.getDescriptors().add(descriptorA);
        MPartDescriptor descriptorB = org.eclipse.e4.ui.model.application.descriptor.basic.impl.BasicFactoryImpl.eINSTANCE.createPartDescriptor();
        descriptorB.setElementId("sharedB");
        descriptorB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        application.getDescriptors().add(descriptorB);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPlaceholder placeholderA = partService.createSharedPart("sharedA");
        stack.getChildren().add(placeholderA);
        stack.setSelectedElement((MUIElement)placeholderA);
        MPart partA = (MPart)placeholderA.getRef();
        PartRenderingEngineTests.assertNotNull((Object)partA.getObject());
        stack.setToBeRendered(false);
        PartRenderingEngineTests.assertNull((Object)partA.getObject());
    }

    public void testRemoveGuiBug324228_1() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveA.setElementId("perspectiveA");
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderA.setRef((MUIElement)part);
        part.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveB.setElementId("perspectiveB");
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderB.setRef((MUIElement)part);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        SampleView view = (SampleView)part.getObject();
        PartRenderingEngineTests.assertFalse((boolean)view.isDestroyed());
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        ((EModelService)this.appContext.get(EModelService.class)).removePerspectiveModel(perspectiveB, window);
        PartRenderingEngineTests.assertFalse((boolean)view.isDestroyed());
        PartRenderingEngineTests.assertNotNull((Object)part.getContext().getParent());
        PartRenderingEngineTests.assertEquals((Object)perspectiveA.getContext(), (Object)part.getContext().getParent());
    }

    public void testRemoveGuiBug324228_2() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveA.setElementId("perspectiveA");
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderA.setRef((MUIElement)part);
        part.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveB.setElementId("perspectiveB");
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderB.setRef((MUIElement)part);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        SampleView view = (SampleView)part.getObject();
        PartRenderingEngineTests.assertFalse((boolean)view.isDestroyed());
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        placeholderB.setToBeRendered(false);
        PartRenderingEngineTests.assertFalse((boolean)view.isDestroyed());
        PartRenderingEngineTests.assertNotNull((Object)part.getContext().getParent());
        PartRenderingEngineTests.assertEquals((Object)perspectiveA.getContext(), (Object)part.getContext().getParent());
    }

    public void testRemoveGuiBug324228_3() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getSharedElements().add(partStack);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(part);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveA.setElementId("perspectiveA");
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderA.setRef((MUIElement)partStack);
        partStack.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveB.setElementId("perspectiveB");
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderB.setRef((MUIElement)partStack);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        SampleView view = (SampleView)part.getObject();
        PartRenderingEngineTests.assertFalse((boolean)view.isDestroyed());
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        placeholderB.setToBeRendered(false);
        PartRenderingEngineTests.assertFalse((boolean)view.isDestroyed());
        PartRenderingEngineTests.assertNotNull((Object)part.getContext().getParent());
        PartRenderingEngineTests.assertEquals((Object)perspectiveA.getContext(), (Object)part.getContext().getParent());
    }

    public void testRemoveGuiBug324228_4() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getSharedElements().add(partStack);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(part);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveA.setElementId("perspectiveA");
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderA.setRef((MUIElement)partStack);
        partStack.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveB.setElementId("perspectiveB");
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderB.setRef((MUIElement)partStack);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        SampleView view = (SampleView)part.getObject();
        PartRenderingEngineTests.assertFalse((boolean)view.isDestroyed());
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        ((EModelService)this.appContext.get(EModelService.class)).removePerspectiveModel(perspectiveB, window);
        PartRenderingEngineTests.assertFalse((boolean)view.isDestroyed());
        PartRenderingEngineTests.assertNotNull((Object)part.getContext().getParent());
        PartRenderingEngineTests.assertEquals((Object)perspectiveA.getContext(), (Object)part.getContext().getParent());
    }

    public void testRemoveGuiBug324230() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartSashContainer sashContainer = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        window.getChildren().add(sashContainer);
        window.setSelectedElement((MUIElement)sashContainer);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setToBeRendered(false);
        sashContainer.getChildren().add(part);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertNotNull((Object)sashContainer.getWidget());
        ((IPresentationEngine)this.appContext.get(IPresentationEngine.class)).removeGui((MUIElement)sashContainer);
        PartRenderingEngineTests.assertNull((Object)sashContainer.getWidget());
    }

    public void testBug317849() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartSashContainer sashContainer = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        window.getChildren().add(sashContainer);
        window.setSelectedElement((MUIElement)sashContainer);
        MPlaceholder sharedAreaPlaceholder = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        sashContainer.getChildren().add(sharedAreaPlaceholder);
        sashContainer.setSelectedElement((MUIElement)sharedAreaPlaceholder);
        MPartSashContainer sharedSashContainer = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        window.getSharedElements().add(sharedSashContainer);
        sharedAreaPlaceholder.setRef((MUIElement)sharedSashContainer);
        sharedSashContainer.setCurSharedRef(sharedAreaPlaceholder);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        sharedSashContainer.getChildren().add(partStack);
        sharedSashContainer.setSelectedElement((MUIElement)partStack);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertNotNull((Object)partStack.getWidget());
        PartRenderingEngineTests.assertNotNull((Object)sharedSashContainer.getWidget());
        PartRenderingEngineTests.assertNotNull((Object)sashContainer.getWidget());
    }

    public void testBug326087() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartSashContainer sashContainer = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        window.getChildren().add(sashContainer);
        window.setSelectedElement((MUIElement)sashContainer);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        sashContainer.getChildren().add(partStack);
        sashContainer.setSelectedElement((MUIElement)partStack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(partB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertNotNull((Object)partA.getWidget());
        PartRenderingEngineTests.assertNull((Object)partB.getWidget());
        partStack.setSelectedElement((MUIElement)partB);
        PartRenderingEngineTests.assertNotNull((Object)partA.getWidget());
        PartRenderingEngineTests.assertNotNull((Object)partB.getWidget());
        ((IPresentationEngine)application.getContext().get(IPresentationEngine.class)).removeGui((MUIElement)sashContainer);
        PartRenderingEngineTests.assertEquals((Object)partB, (Object)partStack.getSelectedElement());
    }

    public void testBug327701() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getSharedElements().add(partStack);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(part1);
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(part2);
        partStack.setSelectedElement((MUIElement)part2);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderA.setRef((MUIElement)partStack);
        partStack.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderB.setRef((MUIElement)partStack);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        perspectiveB.getContext().activate();
        perspectiveB.setToBeRendered(false);
        PartRenderingEngineTests.assertEquals((Object)perspectiveA.getContext(), (Object)part2.getContext().getParent());
    }

    public void testBug326699() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getSharedElements().add(partStack);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder partStackPlaceholderA = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        partStack.setCurSharedRef(partStackPlaceholderA);
        partStackPlaceholderA.setRef((MUIElement)partStack);
        perspectiveA.getChildren().add(partStackPlaceholderA);
        perspectiveA.setSelectedElement((MUIElement)partStackPlaceholderA);
        MPerspective perspectiveB = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder partStackPlaceholderB = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        partStackPlaceholderB.setRef((MUIElement)partStack);
        perspectiveB.getChildren().add(partStackPlaceholderB);
        perspectiveB.setSelectedElement((MUIElement)partStackPlaceholderB);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        part1.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(part1);
        partStack.setSelectedElement((MUIElement)part1);
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        part2.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(part2);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(part1);
        partService.activate(part2);
        partService.activate(part1);
        partService.switchPerspective(perspectiveB);
        partService.switchPerspective(perspectiveA);
        SampleView view1 = (SampleView)part1.getObject();
        SampleView view2 = (SampleView)part2.getObject();
        ((IPresentationEngine)this.appContext.get(IPresentationEngine.class)).removeGui((MUIElement)window);
        PartRenderingEngineTests.assertFalse((boolean)view1.nullParentContext);
        PartRenderingEngineTests.assertFalse((boolean)view2.nullParentContext);
    }

    public void testBug327807() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(part1);
        partStack.setSelectedElement((MUIElement)part1);
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(part2);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertEquals((Object)part1, (Object)partStack.getSelectedElement());
        ((IPresentationEngine)this.appContext.get(IPresentationEngine.class)).removeGui((MUIElement)window);
        PartRenderingEngineTests.assertEquals((Object)part1, (Object)partStack.getSelectedElement());
    }

    public void testBug328629() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartSashContainer partSashContainer = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        partSashContainer.setToBeRendered(false);
        window.getChildren().add(partSashContainer);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        partSashContainer.setToBeRendered(true);
    }

    public void test331685() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        IPresentationEngine engine = (IPresentationEngine)this.appContext.get(IPresentationEngine.class);
        engine.removeGui((MUIElement)part);
        PartRenderingEngineTests.assertNull((Object)part.getWidget());
        engine.createGui((MUIElement)part, null, window.getContext());
        engine.removeGui((MUIElement)part);
    }

    public void testBug331795_1() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertNotNull((Object)part.getObject());
        PartRenderingEngineTests.assertNotNull((Object)part.getContext());
        SampleView view = (SampleView)part.getObject();
        view.errorOnWidgetDisposal = true;
        part.setToBeRendered(false);
        PartRenderingEngineTests.assertTrue((String)"The view should have been destroyed", (boolean)view.isDestroyed());
        PartRenderingEngineTests.assertNull((Object)part.getObject());
        PartRenderingEngineTests.assertNull((Object)part.getContext());
    }

    public void testBug331795_2() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertNotNull((Object)part.getObject());
        PartRenderingEngineTests.assertNotNull((Object)part.getContext());
        SampleView view = (SampleView)part.getObject();
        view.errorOnPreDestroy = true;
        part.setToBeRendered(false);
        PartRenderingEngineTests.assertTrue((String)"The view should have been destroyed", (boolean)view.isDestroyed());
        PartRenderingEngineTests.assertNull((Object)part.getObject());
        PartRenderingEngineTests.assertNull((Object)part.getContext());
    }

    public void testBug329079() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setVisible(false);
        window.getChildren().add(part);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
    }

    public void testRemoveGui_Bug332163() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective1 = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspective1);
        perspectiveStack.setSelectedElement((MUIElement)perspective1);
        MPlaceholder partPlaceholderA1 = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        partPlaceholderA1.setRef((MUIElement)part);
        part.setCurSharedRef(partPlaceholderA1);
        perspective1.getChildren().add(partPlaceholderA1);
        perspective1.setSelectedElement((MUIElement)partPlaceholderA1);
        MPerspective perspective2 = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspective2);
        MPlaceholder partPlaceholder2 = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        partPlaceholder2.setRef((MUIElement)part);
        perspective2.getChildren().add(partPlaceholder2);
        perspective2.setSelectedElement((MUIElement)partPlaceholder2);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        IEclipseContext perspectiveContext1 = perspective1.getContext();
        IEclipseContext partContext = part.getContext();
        PartRenderingEngineTests.assertEquals((Object)perspectiveContext1, (Object)partContext.getParent());
        PartRenderingEngineTests.assertEquals((Object)partContext, (Object)perspectiveContext1.getActiveChild());
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.switchPerspective(perspective2);
        IEclipseContext perspectiveContext2 = perspective2.getContext();
        PartRenderingEngineTests.assertEquals((Object)partContext, (Object)perspectiveContext1.getActiveChild());
        PartRenderingEngineTests.assertEquals((Object)perspectiveContext2, (Object)partContext.getParent());
        PartRenderingEngineTests.assertEquals((Object)partContext, (Object)perspectiveContext2.getActiveChild());
        partService.hidePart(part);
        PartRenderingEngineTests.assertEquals((Object)perspectiveContext1, (Object)partContext.getParent());
        PartRenderingEngineTests.assertEquals((Object)partContext, (Object)perspectiveContext1.getActiveChild());
        PartRenderingEngineTests.assertNull((String)"perspective2 doesn't have any parts, it should not have an active child context", (Object)perspectiveContext2.getActiveChild());
    }

    public void testBug334644_01() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        window.setToBeRendered(false);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)application);
        PartRenderingEngineTests.assertNull((String)"No widget for an unrendered window", (Object)window.getWidget());
        PartRenderingEngineTests.assertNull((String)"No context for an unrendered window", (Object)window.getContext());
        window.setToBeRendered(true);
        PartRenderingEngineTests.assertNotNull((String)"Rendered window should have a widget", (Object)window.getWidget());
        PartRenderingEngineTests.assertNotNull((String)"Rendered window should have a context", (Object)window.getContext());
    }

    public void testBug334644_02() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        window.setToBeRendered(true);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertNotNull((String)"Rendered window should have a widget", (Object)window.getWidget());
        PartRenderingEngineTests.assertNotNull((String)"Rendered window should have a context", (Object)window.getContext());
        window.setToBeRendered(false);
        PartRenderingEngineTests.assertNull((String)"No widget for an unrendered window", (Object)window.getWidget());
        PartRenderingEngineTests.assertNull((String)"No context for an unrendered window", (Object)window.getContext());
    }

    public void testRemoveGui_Bug334577_01() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MWindow detachedWindow = BasicFactoryImpl.eINSTANCE.createWindow();
        perspective.getWindows().add(detachedWindow);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertNotNull((Object)detachedWindow.getContext());
        PartRenderingEngineTests.assertNotNull((Object)detachedWindow.getWidget());
        perspective.setToBeRendered(false);
        PartRenderingEngineTests.assertNull((Object)detachedWindow.getContext());
        PartRenderingEngineTests.assertNull((Object)detachedWindow.getWidget());
    }

    public void testRemoveGui_Bug334577_02() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MWindow detachedWindow = BasicFactoryImpl.eINSTANCE.createWindow();
        window.getWindows().add(detachedWindow);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertNotNull((Object)detachedWindow.getContext());
        PartRenderingEngineTests.assertNotNull((Object)detachedWindow.getWidget());
        window.setToBeRendered(false);
        PartRenderingEngineTests.assertNull((Object)detachedWindow.getContext());
        PartRenderingEngineTests.assertNull((Object)detachedWindow.getWidget());
    }

    public void testBug336139() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MTrimmedWindow window = BasicFactoryImpl.eINSTANCE.createTrimmedWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MTrimBar trimBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        window.getTrimBars().add(trimBar);
        MToolControl toolControl = MenuFactoryImpl.eINSTANCE.createToolControl();
        trimBar.getChildren().add(toolControl);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
    }

    public void testBut336225() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MTrimmedWindow window = BasicFactoryImpl.eINSTANCE.createTrimmedWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MTrimBar trimBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        window.getTrimBars().add(trimBar);
        MToolControl toolControl = MenuFactoryImpl.eINSTANCE.createToolControl();
        toolControl.setContributionURI(SampleToolControl.CONTRIBUTION_URI);
        trimBar.getChildren().add(toolControl);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        SampleToolControl impl = (SampleToolControl)toolControl.getObject();
        ((IPresentationEngine)this.appContext.get(IPresentationEngine.class)).removeGui((MUIElement)window);
        PartRenderingEngineTests.assertFalse((String)"The shell should not have been disposed first", (boolean)impl.shellEagerlyDestroyed);
    }

    public void testBug330662() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MArea area = AdvancedFactoryImpl.eINSTANCE.createArea();
        window.getSharedElements().add(area);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        area.getChildren().add(partStack);
        area.setSelectedElement((MUIElement)partStack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(partB);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveA.setElementId("perspectiveA");
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderA.setRef((MUIElement)area);
        area.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveB.setElementId("perspectiveB");
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderB.setRef((MUIElement)area);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.showPart(partB, EPartService.PartState.ACTIVATE);
        partService.switchPerspective(perspectiveB);
        ((IPresentationEngine)window.getContext().get(IPresentationEngine.class)).removeGui((MUIElement)perspectiveA);
        PartRenderingEngineTests.assertEquals((Object)perspectiveB.getContext(), (Object)partA.getContext().getParent());
        PartRenderingEngineTests.assertEquals((Object)perspectiveB.getContext(), (Object)partB.getContext().getParent());
    }

    public void testBug335444_A() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MWindow detachedWindow = BasicFactoryImpl.eINSTANCE.createWindow();
        window.getWindows().add(detachedWindow);
        PartRenderingEngineTests.assertNotNull((Object)detachedWindow.getContext());
        PartRenderingEngineTests.assertNotNull((Object)detachedWindow.getWidget());
        PartRenderingEngineTests.assertNotNull((Object)detachedWindow.getRenderer());
    }

    public void testBug335444_B() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MWindow detachedWindow = BasicFactoryImpl.eINSTANCE.createWindow();
        perspective.getWindows().add(detachedWindow);
        PartRenderingEngineTests.assertNotNull((Object)detachedWindow.getContext());
        PartRenderingEngineTests.assertNotNull((Object)detachedWindow.getWidget());
        PartRenderingEngineTests.assertNotNull((Object)detachedWindow.getRenderer());
    }

    public void testBug335444_C() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MWindow detachedWindow = BasicFactoryImpl.eINSTANCE.createWindow();
        detachedWindow.setToBeRendered(false);
        window.getWindows().add(detachedWindow);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        detachedWindow.setToBeRendered(true);
        PartRenderingEngineTests.assertNotNull((Object)detachedWindow.getContext());
        PartRenderingEngineTests.assertNotNull((Object)detachedWindow.getWidget());
        PartRenderingEngineTests.assertNotNull((Object)detachedWindow.getRenderer());
    }

    public void testBug335444_D() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MWindow detachedWindow = BasicFactoryImpl.eINSTANCE.createWindow();
        detachedWindow.setToBeRendered(false);
        perspective.getWindows().add(detachedWindow);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        detachedWindow.setToBeRendered(true);
        PartRenderingEngineTests.assertNotNull((Object)detachedWindow.getContext());
        PartRenderingEngineTests.assertNotNull((Object)detachedWindow.getWidget());
        PartRenderingEngineTests.assertNotNull((Object)detachedWindow.getRenderer());
    }

    public void testBug326175(boolean visible) {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MWindow detachedWindow = BasicFactoryImpl.eINSTANCE.createWindow();
        detachedWindow.setVisible(visible);
        window.getWindows().add(detachedWindow);
        ((IPresentationEngine)this.appContext.get(IPresentationEngine.class)).createGui((MUIElement)detachedWindow);
        if (visible) {
            PartRenderingEngineTests.assertEquals((Object)detachedWindow.getContext(), (Object)window.getContext().getActiveChild());
        } else {
            PartRenderingEngineTests.assertEquals((Object)part.getContext(), (Object)window.getContext().getActiveChild());
        }
    }

    public void testBug326175_True() {
        this.testBug326175(true);
    }

    public void testBug326175_False() {
        this.testBug326175(false);
    }

    public void testCreateGui_Bug319004() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        IPresentationEngine engine = (IPresentationEngine)this.appContext.get(IPresentationEngine.class);
        engine.createGui((MUIElement)toolBar);
    }

    public void testBug339286() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MToolBar toolBarA = MenuFactoryImpl.eINSTANCE.createToolBar();
        partA.setToolbar(toolBarA);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(partB);
        MToolBar toolBarB = MenuFactoryImpl.eINSTANCE.createToolBar();
        partB.setToolbar(toolBarB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Widget widgetA = (Widget)toolBarA.getWidget();
        Widget widgetB = (Widget)toolBarB.getWidget();
        PartRenderingEngineTests.assertNotNull((Object)widgetA);
        PartRenderingEngineTests.assertFalse((boolean)widgetA.isDisposed());
        PartRenderingEngineTests.assertNull((Object)widgetB);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB);
        widgetA = (Widget)toolBarA.getWidget();
        widgetB = (Widget)toolBarB.getWidget();
        PartRenderingEngineTests.assertNotNull((Object)widgetA);
        PartRenderingEngineTests.assertFalse((boolean)widgetA.isDisposed());
        PartRenderingEngineTests.assertNotNull((Object)widgetB);
        PartRenderingEngineTests.assertFalse((boolean)widgetB.isDisposed());
    }

    public void testBug334580_01() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getSharedElements().add(part);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveA.setElementId("perspectiveA");
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPartStack partStackA = BasicFactoryImpl.eINSTANCE.createPartStack();
        perspectiveA.getChildren().add(partStackA);
        perspectiveA.setSelectedElement((MUIElement)partStackA);
        MPlaceholder placeholderA = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderA.setRef((MUIElement)part);
        part.setCurSharedRef(placeholderA);
        partStackA.getChildren().add(placeholderA);
        partStackA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveB.setElementId("perspectiveB");
        perspectiveStack.getChildren().add(perspectiveB);
        MPartStack partStackB = BasicFactoryImpl.eINSTANCE.createPartStack();
        perspectiveB.getChildren().add(partStackB);
        perspectiveB.setSelectedElement((MUIElement)partStackB);
        MPlaceholder placeholderB = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderB.setRef((MUIElement)part);
        partStackB.getChildren().add(placeholderB);
        partStackB.setSelectedElement((MUIElement)placeholderB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Shell limboShell = (Shell)this.appContext.get("limbo");
        PartRenderingEngineTests.assertNotNull((Object)limboShell);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.switchPerspective(perspectiveB);
        partService.switchPerspective(perspectiveA);
        Control control = (Control)toolBar.getWidget();
        PartRenderingEngineTests.assertNotNull((Object)control);
        PartRenderingEngineTests.assertFalse((boolean)control.isDisposed());
        partService.hidePart(part);
        control = (Control)toolBar.getWidget();
        PartRenderingEngineTests.assertNotNull((Object)control);
        PartRenderingEngineTests.assertFalse((boolean)control.isDisposed());
        PartRenderingEngineTests.assertEquals((Object)limboShell, (Object)control.getShell());
        partService.switchPerspective(perspectiveB);
        partService.hidePart(part);
        PartRenderingEngineTests.assertTrue((boolean)control.isDisposed());
        PartRenderingEngineTests.assertNull((Object)toolBar.getWidget());
    }

    public void testBug334580_02() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MToolBar toolBarA = MenuFactoryImpl.eINSTANCE.createToolBar();
        partA.setToolbar(toolBarA);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(partB);
        MToolBar toolBarB = MenuFactoryImpl.eINSTANCE.createToolBar();
        partB.setToolbar(toolBarB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Shell limboShell = (Shell)this.appContext.get("limbo");
        PartRenderingEngineTests.assertNotNull((Object)limboShell);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB);
        partService.activate(partA);
        Control controlA = (Control)toolBarA.getWidget();
        Control controlB = (Control)toolBarB.getWidget();
        PartRenderingEngineTests.assertNotNull((Object)controlA);
        PartRenderingEngineTests.assertFalse((boolean)controlA.isDisposed());
        PartRenderingEngineTests.assertNotNull((Object)controlB);
        PartRenderingEngineTests.assertFalse((boolean)controlB.isDisposed());
        partService.hidePart(partA);
        controlB = (Control)toolBarB.getWidget();
        PartRenderingEngineTests.assertNull((Object)toolBarA.getWidget());
        PartRenderingEngineTests.assertTrue((boolean)controlA.isDisposed());
        PartRenderingEngineTests.assertNotNull((Object)controlB);
        PartRenderingEngineTests.assertFalse((boolean)controlB.isDisposed());
        partService.hidePart(partB);
        PartRenderingEngineTests.assertNull((Object)toolBarA.getWidget());
        PartRenderingEngineTests.assertNull((Object)toolBarB.getWidget());
        PartRenderingEngineTests.assertTrue((boolean)controlB.isDisposed());
    }

    public void testBug334580_03() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(partB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Shell limboShell = (Shell)this.appContext.get("limbo");
        PartRenderingEngineTests.assertNotNull((Object)limboShell);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB);
        partService.activate(partA);
        partService.hidePart(partA);
        PartRenderingEngineTests.assertFalse((boolean)this.logged);
    }

    public void testBug342439_01() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setVisible(false);
        partStack.getChildren().add(partA);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(partB);
        partStack.setSelectedElement((MUIElement)partB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder folder = (CTabFolder)partStack.getWidget();
        PartRenderingEngineTests.assertEquals((int)1, (int)folder.getItemCount());
        PartRenderingEngineTests.assertNull((Object)partA.getWidget());
        partA.setVisible(true);
        PartRenderingEngineTests.assertEquals((int)2, (int)folder.getItemCount());
        PartRenderingEngineTests.assertNull((Object)partA.getWidget());
        ((EPartService)window.getContext().get(EPartService.class)).showPart(partA, EPartService.PartState.ACTIVATE);
        PartRenderingEngineTests.assertEquals((int)2, (int)folder.getItemCount());
        PartRenderingEngineTests.assertNotNull((Object)partA.getWidget());
    }

    public void testBug342439_02() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partA.setVisible(false);
        partStack.getChildren().add(partA);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(partB);
        partStack.setSelectedElement((MUIElement)partB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder folder = (CTabFolder)partStack.getWidget();
        PartRenderingEngineTests.assertEquals((int)1, (int)folder.getItemCount());
        partA.setToBeRendered(false);
        PartRenderingEngineTests.assertEquals((int)1, (int)folder.getItemCount());
        partA.setVisible(true);
        PartRenderingEngineTests.assertEquals((int)1, (int)folder.getItemCount());
        partA.setVisible(false);
        PartRenderingEngineTests.assertEquals((int)1, (int)folder.getItemCount());
    }

    public void testBug342366() throws Exception {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(partA);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(partB);
        partStack.setSelectedElement((MUIElement)partB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        CTabFolder folder = (CTabFolder)partStack.getWidget();
        PartRenderingEngineTests.assertEquals((int)2, (int)folder.getItemCount());
        partA.setVisible(false);
        PartRenderingEngineTests.assertEquals((int)1, (int)folder.getItemCount());
        MPart partC = BasicFactoryImpl.eINSTANCE.createPart();
        partStack.getChildren().add(partC);
        this.checkLog();
    }

    public void testBug343305() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getSharedElements().add(part);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPartStack partStackA = BasicFactoryImpl.eINSTANCE.createPartStack();
        perspectiveA.getChildren().add(partStackA);
        perspectiveA.setSelectedElement((MUIElement)partStackA);
        MPlaceholder placeholderA = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderA.setRef((MUIElement)part);
        part.setCurSharedRef(placeholderA);
        partStackA.getChildren().add(placeholderA);
        partStackA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspectiveB);
        MPartStack partStackB = BasicFactoryImpl.eINSTANCE.createPartStack();
        perspectiveB.getChildren().add(partStackB);
        perspectiveB.setSelectedElement((MUIElement)partStackB);
        MPlaceholder placeholderB = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholderB.setToBeRendered(false);
        placeholderB.setRef((MUIElement)part);
        partStackB.getChildren().add(placeholderB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.switchPerspective(perspectiveB);
        partService.switchPerspective(perspectiveA);
        Control control = (Control)toolBar.getWidget();
        Composite stackIntermediate = control.getParent();
        Control parent = (Control)partStackA.getWidget();
        PartRenderingEngineTests.assertEquals((Object)parent, (Object)stackIntermediate.getParent());
        partStackB.setToBeRendered(false);
        stackIntermediate = control.getParent();
        PartRenderingEngineTests.assertEquals((Object)parent, (Object)stackIntermediate.getParent());
    }

    public void testBug343442() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getSharedElements().add(part);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        MPerspectiveStack perspectiveStack = AdvancedFactoryImpl.eINSTANCE.createPerspectiveStack();
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = AdvancedFactoryImpl.eINSTANCE.createPerspective();
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack partStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        perspective.getChildren().add(partStack);
        perspective.setSelectedElement((MUIElement)partStack);
        MPlaceholder placeholder = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        placeholder.setRef((MUIElement)part);
        part.setCurSharedRef(placeholder);
        partStack.getChildren().add(placeholder);
        partStack.setSelectedElement((MUIElement)placeholder);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        partStack.getChildren().remove(placeholder);
        partStack.getChildren().add(placeholder);
        partStack.setSelectedElement((MUIElement)placeholder);
        PartRenderingEngineTests.assertEquals((Object)partStack.getWidget(), (Object)((Control)toolBar.getWidget()).getParent().getParent());
    }

    public void testBug343524() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MTrimmedWindow window = BasicFactoryImpl.eINSTANCE.createTrimmedWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MTrimBar trimBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        window.getTrimBars().add(trimBar);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertNotNull((Object)trimBar.getWidget());
        trimBar.setToBeRendered(false);
        PartRenderingEngineTests.assertNull((Object)trimBar.getWidget());
        trimBar.setToBeRendered(true);
        PartRenderingEngineTests.assertNotNull((Object)trimBar.getWidget());
    }

    public void testBug332463() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MArea area = AdvancedFactoryImpl.eINSTANCE.createArea();
        window.getChildren().add(area);
        window.setSelectedElement((MUIElement)area);
        MPartSashContainer sashContainer = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        area.getChildren().add(sashContainer);
        area.setSelectedElement((MUIElement)sashContainer);
        MPartStack partStackA = BasicFactoryImpl.eINSTANCE.createPartStack();
        sashContainer.getChildren().add(partStackA);
        sashContainer.setSelectedElement((MUIElement)partStackA);
        MPart partA = BasicFactoryImpl.eINSTANCE.createPart();
        partStackA.getChildren().add(partA);
        partStackA.setSelectedElement((MUIElement)partA);
        MPart partB = BasicFactoryImpl.eINSTANCE.createPart();
        partStackA.getChildren().add(partB);
        partStackA.setSelectedElement((MUIElement)partB);
        MPartStack partStackB = BasicFactoryImpl.eINSTANCE.createPartStack();
        sashContainer.getChildren().add(partStackB);
        sashContainer.setSelectedElement((MUIElement)partStackB);
        MPart partC = BasicFactoryImpl.eINSTANCE.createPart();
        partStackB.getChildren().add(partC);
        partStackB.setSelectedElement((MUIElement)partC);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        ContextInjectionFactory.make(CleanupAddon.class, (IEclipseContext)this.appContext);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.hidePart(partB);
        this.spinEventLoop();
        partService.hidePart(partA, true);
        this.spinEventLoop();
        partService.hidePart(partC, true);
        this.spinEventLoop();
        PartRenderingEngineTests.assertNotNull((Object)area.getWidget());
        PartRenderingEngineTests.assertTrue((boolean)area.isToBeRendered());
    }

    public void testBug348215_PartOnlyContextReparent() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MWindow detachedWindow = BasicFactoryImpl.eINSTANCE.createWindow();
        window.getWindows().add(detachedWindow);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        detachedWindow.getChildren().add(part);
        detachedWindow.setSelectedElement((MUIElement)part);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertTrue((part.getContext() != null ? 1 : 0) != 0);
        PartRenderingEngineTests.assertTrue((part.getContext().getParent() == detachedWindow.getContext() ? 1 : 0) != 0);
        detachedWindow.getChildren().remove(part);
        window.getChildren().add(part);
        PartRenderingEngineTests.assertTrue((part.getContext() != null ? 1 : 0) != 0);
        PartRenderingEngineTests.assertTrue((part.getContext().getParent() == window.getContext() ? 1 : 0) != 0);
    }

    public void testBug348215_PartContextReparent() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MWindow detachedWindow = BasicFactoryImpl.eINSTANCE.createWindow();
        window.getWindows().add(detachedWindow);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        detachedWindow.getChildren().add(stack);
        detachedWindow.setSelectedElement((MUIElement)stack);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(part);
        stack.setSelectedElement((MUIElement)part);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertTrue((part.getContext() != null ? 1 : 0) != 0);
        PartRenderingEngineTests.assertTrue((part.getContext().getParent() == detachedWindow.getContext() ? 1 : 0) != 0);
        detachedWindow.getChildren().remove(stack);
        window.getChildren().add(stack);
        PartRenderingEngineTests.assertTrue((part.getContext() != null ? 1 : 0) != 0);
        PartRenderingEngineTests.assertTrue((part.getContext().getParent() == window.getContext() ? 1 : 0) != 0);
    }

    public void testBug348215_PartPlaceholderContextReparent() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MWindow detachedWindow = BasicFactoryImpl.eINSTANCE.createWindow();
        window.getWindows().add(detachedWindow);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        detachedWindow.getChildren().add(stack);
        detachedWindow.setSelectedElement((MUIElement)stack);
        MPlaceholder ph = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        ph.setRef((MUIElement)part);
        stack.getChildren().add(ph);
        stack.setSelectedElement((MUIElement)ph);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertTrue((part.getContext() != null ? 1 : 0) != 0);
        PartRenderingEngineTests.assertTrue((part.getContext().getParent() == detachedWindow.getContext() ? 1 : 0) != 0);
        detachedWindow.getChildren().remove(stack);
        window.getChildren().add(stack);
        PartRenderingEngineTests.assertTrue((part.getContext() != null ? 1 : 0) != 0);
        PartRenderingEngineTests.assertTrue((part.getContext().getParent() == window.getContext() ? 1 : 0) != 0);
    }

    public void testBug349076() {
        MApplication application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPlaceholder ph = AdvancedFactoryImpl.eINSTANCE.createPlaceholder();
        ph.setRef((MUIElement)part);
        part.setCurSharedRef(ph);
        stack.getChildren().add(ph);
        stack.setSelectedElement((MUIElement)ph);
        MWindow detachedWindow = BasicFactoryImpl.eINSTANCE.createWindow();
        window.getWindows().add(detachedWindow);
        MPartStack detachedStack = BasicFactoryImpl.eINSTANCE.createPartStack();
        detachedWindow.getChildren().add(detachedStack);
        detachedWindow.setSelectedElement((MUIElement)detachedStack);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class.getName(), (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        PartRenderingEngineTests.assertTrue((part.getContext() != null ? 1 : 0) != 0);
        PartRenderingEngineTests.assertTrue((part.getContext().getParent() == window.getContext() ? 1 : 0) != 0);
        stack.getChildren().remove(ph);
        detachedStack.getChildren().add(ph);
        PartRenderingEngineTests.assertTrue((part.getContext() != null ? 1 : 0) != 0);
        PartRenderingEngineTests.assertTrue((part.getContext().getParent() == detachedWindow.getContext() ? 1 : 0) != 0);
    }

    private MWindow createWindowWithOneView(String partName) {
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setHeight(300);
        window.setWidth(400);
        window.setLabel("MyWindow");
        MPartSashContainer sash = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        window.getChildren().add(sash);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        sash.getChildren().add(stack);
        MPart contributedPart = BasicFactoryImpl.eINSTANCE.createPart();
        stack.getChildren().add(contributedPart);
        contributedPart.setLabel(partName);
        contributedPart.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        return window;
    }
}

