/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.remote;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteItem;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class RemoteStoreTransient {
    protected final IContainer myContainer;
    private long lastTime = System.currentTimeMillis();
    private RemoteFolder myRoot = new RemoteFolder(this);

    public RemoteStoreTransient(IContainer container) {
        this.myContainer = container;
    }

    public String getDefaultCharset() throws CoreException {
        return this.myContainer.getDefaultCharset(true);
    }

    public synchronized long newTime() {
        long actTime = this.lastTime;
        try {
            actTime = System.currentTimeMillis();
            if (actTime > this.lastTime) {
                long l = actTime;
                return l;
            }
            int add = 1;
            while (actTime <= this.lastTime) {
                actTime = System.currentTimeMillis() + (long)add;
                ++add;
            }
            long l = actTime;
            return l;
        }
        finally {
            this.lastTime = actTime;
        }
    }

    public void reset() {
        this.myRoot = new RemoteFolder(this);
    }

    public RemoteFolder getRootFolder() {
        return this.myRoot;
    }

    public RemoteItem getItemByPath(IPath path) {
        RemoteItem item = this.getRootFolder();
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (item instanceof RemoteFolder && (item = item.getChild(segment)) == null) {
                return null;
            }
            ++n2;
        }
        return item;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.myContainer.getFullPath() == null ? 0 : this.myContainer.getFullPath().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteStore other = (RemoteStore)obj;
        return !(this.myContainer.getFullPath() == null ? other.myContainer.getFullPath() != null : !this.myContainer.getFullPath().equals((Object)other.myContainer.getFullPath()));
    }
}

