/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.internal.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.internal.utils.NamespaceHelper;
import org.eclipse.e4.xwt.internal.utils.ObjectUtil;
import org.eclipse.e4.xwt.internal.xml.DocumentObject;
import org.eclipse.e4.xwt.internal.xml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderUtil {
    static final String[] DefaultPackages = new String[0];

    public static Class<?> loadClass(ILoadingContext loadingContext, String className) {
        Class<?> type = ClassLoaderUtil.doLoadClass(loadingContext, className);
        if (type != null) {
            return type;
        }
        int index = className.indexOf(46);
        if (index == -1) {
            String[] stringArray = DefaultPackages;
            int n = DefaultPackages.length;
            int n2 = 0;
            while (n2 < n) {
                String packageName = stringArray[n2];
                type = ClassLoaderUtil.doLoadClass(loadingContext, String.valueOf(packageName) + "." + className);
                if (type != null) {
                    return type;
                }
                ++n2;
            }
        }
        return null;
    }

    private static Class<?> doLoadClass(ILoadingContext loadingContext, String className) {
        Class<?> type = loadingContext.loadClass(className);
        if (type != null) {
            return type;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static Object loadMember(ILoadingContext loadingContext, String className, String memberName, boolean raiseException) {
        Class<?> type = ClassLoaderUtil.loadClass(loadingContext, className);
        return ClassLoaderUtil.loadMember(loadingContext, type, memberName, raiseException);
    }

    public static Object loadMember(ILoadingContext loadingContext, Class<?> type, String memberName, boolean raiseException) {
        try {
            Field field = type.getField(memberName);
            if (raiseException && !Modifier.isStatic(field.getModifiers())) {
                throw new IllegalStateException(String.valueOf(type.getName()) + "." + memberName + " is not static member.");
            }
            return field.get(null);
        }
        catch (Exception e) {
            if (e instanceof NoSuchFieldException) {
                Method method = ObjectUtil.findGetter(type, memberName, null);
                if (raiseException && (method == null || !Modifier.isStatic(method.getModifiers()))) {
                    throw new IllegalStateException(String.valueOf(type.getName()) + "." + memberName + " is not static member.");
                }
                try {
                    return method.invoke(null, new Object[0]);
                }
                catch (Exception exception) {
                    e = exception;
                }
            }
            if (raiseException) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
            return null;
        }
    }

    public static Object loadStaticMember(ILoadingContext loadingContext, Element element) {
        String namespace;
        String name = element.getName();
        Object value = ClassLoaderUtil.doLoadMember(loadingContext, name, namespace = element.getNamespace());
        if (value != null) {
            return value;
        }
        String content = element.getContent();
        if (content == null) {
            DocumentObject[] documentObjectArray;
            Element member = element.getAttribute("http://www.eclipse.org/xwt/presentation", "Member");
            if (member == null) {
                member = element;
            }
            if ((content = member.getContent()) == null && (documentObjectArray = member.getChildren()).length != 0) {
                DocumentObject documentObject = documentObjectArray[0];
                String ns = documentObject.getNamespace();
                String n = documentObject.getName();
                return ClassLoaderUtil.doLoadMember(loadingContext, n, ns);
            }
        } else if ("Static".equals(name) && "http://www.eclipse.org/xwt".equals(namespace)) {
            namespace = "http://www.eclipse.org/xwt/presentation";
            return ClassLoaderUtil.doLoadMember(loadingContext, content, namespace);
        }
        return null;
    }

    protected static Object doLoadMember(ILoadingContext loadingContext, String name, String namespace) {
        int lastIndex = name.lastIndexOf(46);
        if (lastIndex == -1) {
            throw new IllegalStateException("Separator '.' is missing in:" + name);
        }
        String className = name.substring(0, lastIndex);
        String memberName = name.substring(lastIndex + 1);
        try {
            Class<?> type = NamespaceHelper.loadCLRClass(loadingContext, className, namespace);
            if (type != null) {
                return ClassLoaderUtil.loadMember(loadingContext, type, memberName, true);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

