/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.stringconverters;

import java.lang.reflect.Method;
import org.eclipse.e4.tm.stringconverter.AbstractStringConverter;

public class StaticMethodStringConverter
extends AbstractStringConverter {
    private Class methodClass;
    private Class[] parameterTypes;
    private String methodName;
    private Object[] args = null;
    private Method method = null;

    private StaticMethodStringConverter() {
        this.trim = true;
    }

    public StaticMethodStringConverter(Class methodClass, String methodName, Class[] parameterTypes, Object[] args) {
        this();
        this.methodClass = methodClass;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.args = args;
    }

    public StaticMethodStringConverter(Class methodClass, String methodName) {
        this(methodClass, methodName, new Class[]{String.class}, new Object[1]);
    }

    public Object convert(String source) {
        if (this.method == null) {
            try {
                this.method = this.methodClass.getMethod(this.methodName, this.parameterTypes);
            }
            catch (Exception exception) {}
        }
        if (this.method == null) {
            return null;
        }
        int sourcePos = 0;
        int i = 0;
        while (i < this.parameterTypes.length) {
            if (this.parameterTypes[i] == String.class && this.args[i] == null) {
                sourcePos = i;
                break;
            }
            ++i;
        }
        this.args[sourcePos] = source;
        Object result = null;
        try {
            try {
                result = this.method.invoke(null, this.args);
            }
            catch (Exception exception) {
                this.args[sourcePos] = null;
            }
        }
        finally {
            this.args[sourcePos] = null;
        }
        return result;
    }
}

