/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.integration.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.runtime.internal.impl.XpParsersFactory;
import org.eclipse.platform.discovery.runtime.internal.xp.IContributionsReader;
import org.eclipse.platform.discovery.runtime.internal.xp.IGenericXpParser;
import org.eclipse.platform.discovery.util.internal.logging.ILogger;
import org.eclipse.platform.discovery.util.internal.logging.Logger;

public abstract class ViewCustXpParser<T>
implements IContributionsReader<T> {
    private final XpParsersFactory xpParsersFactory = new XpParsersFactory();
    private final IExtensionRegistry extensionRegistry;

    public ViewCustXpParser(IExtensionRegistry extRegistry) {
        this.extensionRegistry = extRegistry;
    }

    protected IGenericXpParser genericXpParser() {
        return this.xpParsersFactory.createGenericXpParser();
    }

    protected ILogger logger() {
        return Logger.instance();
    }

    public Set<T> readContributions() {
        HashSet<Object> result = new HashSet<Object>();
        List configElements = this.genericXpParser().getConfigurationElements(this.extensionRegistry, this.xpId(), this.elementName());
        for (IConfigurationElement configElem : configElements) {
            try {
                result.add(configElem.createExecutableExtension(this.implementationAttributeName()));
            }
            catch (CoreException e) {
                this.logger().logError(e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    protected abstract String implementationAttributeName();

    protected abstract String elementName();

    protected abstract String xpId();
}

