/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.deeplink.handler;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.deeplink.api.Activator;
import org.eclipse.e4.core.deeplink.handler.RequestHandler;
import org.eclipse.equinox.http.registry.HttpContextExtensionService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class HttpServiceTracker
extends ServiceTracker {
    public static final String DEFAULT_SERVLET = "rap";
    public static final String ID_HTTP_CONTEXT = "org.eclipse.rap.httpcontext";
    private HttpService httpService;
    private final List<String> servletAliases = new ArrayList<String>();

    public HttpServiceTracker(BundleContext context) {
        super(context, HttpService.class.getName(), null);
        this.servletAliases.add("deeplink");
    }

    public Object addingService(ServiceReference reference) {
        this.httpService = (HttpService)this.context.getService(reference);
        HttpContext obContext = this.getE4HttpContext(reference);
        if (this.servletAliases.size() == 0) {
            this.servletAliases.add(DEFAULT_SERVLET);
        }
        for (String name : this.servletAliases) {
            try {
                RequestHandler handler = new RequestHandler();
                this.httpService.registerServlet("/" + name, (Servlet)handler, null, obContext);
            }
            catch (Exception e) {
                String text = "Could not register servlet mapping ''{0}''.";
                Object[] param = new Object[]{name};
                String msg = MessageFormat.format(text, param);
                Status status = new Status(4, "org.eclipse.e4.core.deeplink.handler", 0, msg, (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return this.httpService;
    }

    private HttpContext getE4HttpContext(ServiceReference reference) {
        String name = HttpContextExtensionService.class.getName();
        ServiceReference serviceRef = this.context.getServiceReference(name);
        HttpContextExtensionService service = (HttpContextExtensionService)this.context.getService(serviceRef);
        return service.getHttpContext(reference, ID_HTTP_CONTEXT);
    }

    public void removedService(ServiceReference reference, Object service) {
        for (String name : this.servletAliases) {
            this.httpService.unregister("/" + name);
        }
        super.removedService(reference, service);
    }

    public void addServletAlias(String name) {
        this.servletAliases.add(name);
    }
}

