/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.reconciler;

import java.util.Collection;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.tests.reconciler.ModelReconcilerTest;
import org.eclipse.e4.ui.workbench.modeling.ModelDelta;
import org.eclipse.e4.ui.workbench.modeling.ModelReconciler;

public abstract class ModelReconcilerPartTest
extends ModelReconcilerTest {
    public void testPart_Menus_Add() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        part.getMenus().add(menu);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerPartTest.assertEquals((int)0, (int)part.getMenus().size());
        this.applyAll(deltas);
        ModelReconcilerPartTest.assertEquals((int)1, (int)part.getMenus().size());
    }

    public void testPart_Menus_Remove() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        part.getMenus().add(menu);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.getMenus().remove(menu);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        menu = (MMenu)part.getMenus().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerPartTest.assertEquals((int)1, (int)part.getMenus().size());
        ModelReconcilerPartTest.assertEquals((Object)menu, part.getMenus().get(0));
        this.applyAll(deltas);
        ModelReconcilerPartTest.assertEquals((int)0, (int)part.getMenus().size());
    }

    private void testPart_Menu_ToBeRendered(boolean before, boolean after) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        menu.setToBeRendered(before);
        part.getMenus().add(menu);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        menu.setToBeRendered(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        menu = (MMenu)part.getMenus().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerPartTest.assertEquals((boolean)before, (boolean)menu.isToBeRendered());
        this.applyAll(deltas);
        ModelReconcilerPartTest.assertEquals((boolean)after, (boolean)menu.isToBeRendered());
    }

    public void testPart_Menu_ToBeRendered_TrueTrue() {
        this.testPart_Menu_ToBeRendered(true, true);
    }

    public void testPart_Menu_ToBeRendered_TrueFalse() {
        this.testPart_Menu_ToBeRendered(true, false);
    }

    public void testPart_Menu_ToBeRendered_FalseTrue() {
        this.testPart_Menu_ToBeRendered(false, true);
    }

    public void testPart_Menu_ToBeRendered_FalseFalse() {
        this.testPart_Menu_ToBeRendered(false, false);
    }

    public void testPart_ToolBar_Set() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerPartTest.assertNull((Object)part.getToolbar());
        this.applyAll(deltas);
        ModelReconcilerPartTest.assertNotNull((Object)part.getToolbar());
    }

    public void testPart_ToolBar_Unset() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.setToolbar(null);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerPartTest.assertEquals((Object)toolBar, (Object)part.getToolbar());
        this.applyAll(deltas);
        ModelReconcilerPartTest.assertNull((Object)part.getToolbar());
    }

    private void testPart_ToolBar_ToBeRendered(boolean before, boolean after) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        toolBar.setToBeRendered(before);
        part.setToolbar(toolBar);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        toolBar.setToBeRendered(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        toolBar = part.getToolbar();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerPartTest.assertEquals((boolean)before, (boolean)toolBar.isToBeRendered());
        this.applyAll(deltas);
        ModelReconcilerPartTest.assertEquals((boolean)after, (boolean)toolBar.isToBeRendered());
    }

    public void testPart_ToolBar_ToBeRendered_TrueTrue() {
        this.testPart_ToolBar_ToBeRendered(true, true);
    }

    public void testPart_ToolBar_ToBeRendered_TrueFalse() {
        this.testPart_ToolBar_ToBeRendered(true, false);
    }

    public void testPart_ToolBar_ToBeRendered_FalseTrue() {
        this.testPart_ToolBar_ToBeRendered(false, true);
    }

    public void testPart_ToolBar_ToBeRendered_FalseFalse() {
        this.testPart_ToolBar_ToBeRendered(false, false);
    }

    public void testPart_NewWithToolBar() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerPartTest.assertEquals((int)0, (int)window.getChildren().size());
        this.applyAll(deltas);
        ModelReconcilerPartTest.assertEquals((int)1, (int)window.getChildren().size());
        part = (MPart)window.getChildren().get(0);
        ModelReconcilerPartTest.assertNotNull((Object)part.getToolbar());
    }

    public void testPart_NewWithToolBar2() {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part1);
        MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part1.setToolbar(toolBar);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        window.getChildren().add(part2);
        part2.setToolbar(toolBar);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part1 = (MPart)window.getChildren().get(0);
        toolBar = part1.getToolbar();
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerPartTest.assertEquals((int)1, (int)window.getChildren().size());
        ModelReconcilerPartTest.assertEquals((Object)part1, window.getChildren().get(0));
        ModelReconcilerPartTest.assertEquals((Object)toolBar, (Object)part1.getToolbar());
        this.applyAll(deltas);
        ModelReconcilerPartTest.assertEquals((int)2, (int)window.getChildren().size());
        ModelReconcilerPartTest.assertEquals((Object)part1, window.getChildren().get(0));
        ModelReconcilerPartTest.assertNull((Object)part1.getToolbar());
        part2 = (MPart)window.getChildren().get(1);
        ModelReconcilerPartTest.assertEquals((Object)toolBar, (Object)part2.getToolbar());
    }

    private void testPart_Closeable(boolean before, boolean after) {
        MApplication application = this.createApplication();
        MWindow window = this.createWindow(application);
        MPart part = BasicFactoryImpl.eINSTANCE.createPart();
        part.setCloseable(before);
        window.getChildren().add(part);
        this.saveModel();
        ModelReconciler reconciler = this.createModelReconciler();
        reconciler.recordChanges((Object)application);
        part.setCloseable(after);
        Object state = reconciler.serialize();
        application = this.createApplication();
        window = (MWindow)application.getChildren().get(0);
        part = (MPart)window.getChildren().get(0);
        Collection<ModelDelta> deltas = this.constructDeltas(application, state);
        ModelReconcilerPartTest.assertEquals((boolean)before, (boolean)part.isCloseable());
        this.applyAll(deltas);
        ModelReconcilerPartTest.assertEquals((boolean)after, (boolean)part.isCloseable());
    }

    public void testPart_Closeable_TrueTrue() {
        this.testPart_Closeable(true, true);
    }

    public void testPart_Closeable_TrueFalse() {
        this.testPart_Closeable(true, false);
    }

    public void testPart_Closeable_FalseTrue() {
        this.testPart_Closeable(false, true);
    }

    public void testPart_Closeable_FalseFalse() {
        this.testPart_Closeable(false, false);
    }
}

