/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.db;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.eclipse.test.internal.performance.db.Variations;

public class SQL {
    private boolean fCompatibility = false;
    protected Connection fConnection;
    private PreparedStatement fInsertVariation;
    private PreparedStatement fInsertScenario;
    private PreparedStatement fInsertSample;
    private PreparedStatement fInsertDataPoint;
    private PreparedStatement fInsertScalar;
    private PreparedStatement fQueryComment;
    private PreparedStatement fInsertComment;
    private PreparedStatement fQueryComment2;
    private PreparedStatement fQueryVariation;
    private PreparedStatement fQueryVariations;
    private PreparedStatement fQueryScenario;
    private PreparedStatement fQueryAllScenarios;
    private PreparedStatement fQueryDatapoints;
    private PreparedStatement fQueryScalars;
    private PreparedStatement fInsertSummaryEntry;
    private PreparedStatement fUpdateScenarioShortName;
    private PreparedStatement fQuerySummaryEntry;
    private PreparedStatement fQueryGlobalSummaryEntries;
    private PreparedStatement fQuerySummaryEntries;
    private PreparedStatement fInsertFailure;
    private PreparedStatement fQueryFailure;

    protected SQL(Connection con) throws SQLException {
        this.fConnection = con;
        boolean needsUpgrade = true;
        boolean needsInitialization = true;
        boolean needsFailures = true;
        boolean needsComments = true;
        Statement statement = this.fConnection.createStatement();
        ResultSet rs = statement.executeQuery("select SYS.SYSTABLES.TABLENAME from SYS.SYSTABLES where SYS.SYSTABLES.TABLENAME not like 'SYS%'");
        while (rs.next()) {
            String tablename = rs.getString(1);
            if ("SUMMARYENTRY".equals(tablename)) {
                needsUpgrade = false;
                continue;
            }
            if ("CONFIG_ORG".equals(tablename)) {
                this.fCompatibility = true;
                continue;
            }
            if ("VARIATION".equals(tablename)) {
                needsInitialization = false;
                continue;
            }
            if ("FAILURE".equals(tablename)) {
                needsFailures = false;
                continue;
            }
            if (!"COMMENT".equals(tablename)) continue;
            needsComments = false;
        }
        if (!this.fCompatibility && (rs = statement.executeQuery("select count(*) from SYS.SYSTABLES, SYS.SYSCOLUMNS where SYS.SYSTABLES.TABLENAME = 'SAMPLE' and SYS.SYSTABLES.TABLEID = SYS.SYSCOLUMNS.REFERENCEID and SYS.SYSCOLUMNS.COLUMNNAME = 'CONFIG_ID' ")).next() && rs.getInt(1) == 1) {
            this.fCompatibility = true;
        }
        if (needsInitialization) {
            this.initialize();
        } else {
            if (needsUpgrade) {
                this.upgradeDB();
            } else if (needsFailures) {
                this.addFailureTable();
            }
            if (needsComments) {
                this.addCommentTable();
            }
        }
    }

    protected void dispose() throws SQLException {
        if (this.fInsertVariation != null) {
            this.fInsertVariation.close();
        }
        if (this.fInsertScenario != null) {
            this.fInsertScenario.close();
        }
        if (this.fInsertSample != null) {
            this.fInsertSample.close();
        }
        if (this.fInsertDataPoint != null) {
            this.fInsertDataPoint.close();
        }
        if (this.fInsertScalar != null) {
            this.fInsertScalar.close();
        }
        if (this.fInsertSummaryEntry != null) {
            this.fInsertSummaryEntry.close();
        }
        if (this.fInsertFailure != null) {
            this.fInsertFailure.close();
        }
        if (this.fInsertComment != null) {
            this.fInsertComment.close();
        }
        if (this.fUpdateScenarioShortName != null) {
            this.fUpdateScenarioShortName.close();
        }
        if (this.fQueryDatapoints != null) {
            this.fQueryDatapoints.close();
        }
        if (this.fQueryScalars != null) {
            this.fQueryScalars.close();
        }
        if (this.fQueryVariation != null) {
            this.fQueryVariation.close();
        }
        if (this.fQueryScenario != null) {
            this.fQueryScenario.close();
        }
        if (this.fQueryAllScenarios != null) {
            this.fQueryAllScenarios.close();
        }
        if (this.fQueryVariations != null) {
            this.fQueryVariations.close();
        }
        if (this.fQueryGlobalSummaryEntries != null) {
            this.fQueryGlobalSummaryEntries.close();
        }
        if (this.fQuerySummaryEntries != null) {
            this.fQuerySummaryEntries.close();
        }
        if (this.fQueryFailure != null) {
            this.fQueryFailure.close();
        }
        if (this.fQueryComment != null) {
            this.fQueryComment.close();
        }
        if (this.fQueryComment2 != null) {
            this.fQueryComment2.close();
        }
    }

    private void initialize() throws SQLException {
        Statement stmt = null;
        try {
            stmt = this.fConnection.createStatement();
            stmt.executeUpdate("create table VARIATION (ID int unique not null GENERATED ALWAYS AS IDENTITY,KEYVALPAIRS varchar(10000) not null )");
            stmt.executeUpdate("create table SCENARIO (ID int unique not null GENERATED ALWAYS AS IDENTITY,NAME varchar(256) not null,SHORT_NAME varchar(40))");
            stmt.executeUpdate("create table SAMPLE (ID int not null GENERATED ALWAYS AS IDENTITY,VARIATION_ID int not null,SCENARIO_ID int not null,STARTTIME timestamp)");
            stmt.executeUpdate("create table DATAPOINT (ID int not null GENERATED ALWAYS AS IDENTITY,SAMPLE_ID int not null,SEQ int,STEP int)");
            stmt.executeUpdate("create table SCALAR (DATAPOINT_ID int not null,DIM_ID int not null,VALUE bigint)");
            stmt.executeUpdate("create table SUMMARYENTRY (VARIATION_ID int not null,SCENARIO_ID int not null,DIM_ID int not null,IS_GLOBAL smallint not null,COMMENT_ID int not null)");
            stmt.executeUpdate("create table FAILURE (VARIATION_ID int not null,SCENARIO_ID int not null,MESSAGE varchar(1000) not null)");
            stmt.executeUpdate("create table COMMENT (ID int unique not null GENERATED ALWAYS AS IDENTITY,KIND int not null,TEXT varchar(400) not null)");
            stmt.executeUpdate("alter table VARIATION add constraint VA_KVP primary key (KEYVALPAIRS)");
            stmt.executeUpdate("alter table SCENARIO add constraint SC_NAME primary key (NAME)");
            stmt.executeUpdate("alter table SAMPLE add constraint SA_ID primary key (ID)");
            stmt.executeUpdate("alter table DATAPOINT add constraint DP_ID primary key (ID)");
            stmt.executeUpdate("alter table SAMPLE add constraint SAMPLE_CONSTRAINT foreign key (VARIATION_ID) references VARIATION (ID)");
            stmt.executeUpdate("alter table SAMPLE add constraint SAMPLE_CONSTRAINT2 foreign key (SCENARIO_ID) references SCENARIO (ID)");
            stmt.executeUpdate("alter table DATAPOINT add constraint DP_CONSTRAINT foreign key (SAMPLE_ID) references SAMPLE (ID)");
            stmt.executeUpdate("alter table SCALAR add constraint SCALAR_CONSTRAINT foreign key (DATAPOINT_ID) references DATAPOINT (ID)");
            stmt.executeUpdate("alter table SUMMARYENTRY add constraint FP_CONSTRAINT foreign key (VARIATION_ID) references VARIATION (ID)");
            stmt.executeUpdate("alter table SUMMARYENTRY add constraint FP_CONSTRAINT2 foreign key (SCENARIO_ID) references SCENARIO (ID)");
            stmt.executeUpdate("alter table FAILURE add constraint FA_CONSTRAINT foreign key (VARIATION_ID) references VARIATION (ID)");
            stmt.executeUpdate("alter table FAILURE add constraint FA_CONSTRAINT2 foreign key (SCENARIO_ID) references SCENARIO (ID)");
            this.fConnection.commit();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private void upgradeDB() throws SQLException {
        Statement stmt = null;
        try {
            stmt = this.fConnection.createStatement();
            stmt.executeUpdate("create table SUMMARYENTRY (VARIATION_ID int not null,SCENARIO_ID int not null,DIM_ID int not null,IS_GLOBAL smallint not null,COMMENT_ID int not null)");
            stmt.executeUpdate("alter table SUMMARYENTRY add constraint FP_CONSTRAINT foreign key (VARIATION_ID) references VARIATION (ID)");
            stmt.executeUpdate("alter table SUMMARYENTRY add constraint FP_CONSTRAINT2 foreign key (SCENARIO_ID) references SCENARIO (ID)");
            stmt.executeUpdate("alter table SCENARIO add column SHORT_NAME varchar(40)");
            this.fConnection.commit();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private void addCommentTable() throws SQLException {
        Statement stmt = null;
        try {
            stmt = this.fConnection.createStatement();
            stmt.executeUpdate("create table COMMENT (ID int unique not null GENERATED ALWAYS AS IDENTITY,KIND int not null,TEXT varchar(400) not null)");
            stmt.executeUpdate("alter table SUMMARYENTRY add column COMMENT_ID int not null default 0");
            this.fConnection.commit();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private void addFailureTable() throws SQLException {
        Statement stmt = null;
        try {
            stmt = this.fConnection.createStatement();
            stmt.executeUpdate("create table FAILURE (VARIATION_ID int not null,SCENARIO_ID int not null,MESSAGE varchar(1000) not null)");
            stmt.executeUpdate("alter table FAILURE add constraint FA_CONSTRAINT foreign key (VARIATION_ID) references VARIATION (ID)");
            stmt.executeUpdate("alter table FAILURE add constraint FA_CONSTRAINT2 foreign key (SCENARIO_ID) references SCENARIO (ID)");
            this.fConnection.commit();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    static int create(PreparedStatement stmt) throws SQLException {
        stmt.executeUpdate();
        ResultSet rs = stmt.getGeneratedKeys();
        if (rs != null) {
            try {
                if (rs.next()) {
                    BigDecimal idColVar = rs.getBigDecimal(1);
                    int n = idColVar.intValue();
                    return n;
                }
            }
            finally {
                rs.close();
            }
        }
        return 0;
    }

    int getScenario(String scenarioPattern) throws SQLException {
        if (this.fQueryScenario == null) {
            this.fQueryScenario = this.fConnection.prepareStatement("select ID from SCENARIO where NAME = ?");
        }
        this.fQueryScenario.setString(1, scenarioPattern);
        ResultSet result = this.fQueryScenario.executeQuery();
        if (result.next()) {
            return result.getInt(1);
        }
        if (this.fInsertScenario == null) {
            this.fInsertScenario = this.fConnection.prepareStatement("insert into SCENARIO (NAME) values (?)", 1);
        }
        this.fInsertScenario.setString(1, scenarioPattern);
        return SQL.create(this.fInsertScenario);
    }

    int getVariations(Variations variations) throws SQLException {
        if (this.fQueryVariation == null) {
            this.fQueryVariation = this.fConnection.prepareStatement("select ID from VARIATION where KEYVALPAIRS = ?");
        }
        String exactMatchString = variations.toExactMatchString();
        this.fQueryVariation.setString(1, exactMatchString);
        ResultSet result = this.fQueryVariation.executeQuery();
        if (result.next()) {
            return result.getInt(1);
        }
        if (this.fInsertVariation == null) {
            this.fInsertVariation = this.fConnection.prepareStatement("insert into VARIATION (KEYVALPAIRS) values (?)", 1);
        }
        this.fInsertVariation.setString(1, exactMatchString);
        return SQL.create(this.fInsertVariation);
    }

    int createSample(int variation_id, int scenario_id, Timestamp starttime) throws SQLException {
        if (this.fInsertSample == null) {
            this.fInsertSample = this.fCompatibility ? this.fConnection.prepareStatement("insert into SAMPLE (VARIATION_ID, SCENARIO_ID, STARTTIME, CONFIG_ID) values (?, ?, ?, 0)", 1) : this.fConnection.prepareStatement("insert into SAMPLE (VARIATION_ID, SCENARIO_ID, STARTTIME) values (?, ?, ?)", 1);
        }
        this.fInsertSample.setInt(1, variation_id);
        this.fInsertSample.setInt(2, scenario_id);
        this.fInsertSample.setTimestamp(3, starttime);
        return SQL.create(this.fInsertSample);
    }

    int createDataPoint(int sample_id, int seq, int step) throws SQLException {
        if (this.fInsertDataPoint == null) {
            this.fInsertDataPoint = this.fConnection.prepareStatement("insert into DATAPOINT (SAMPLE_ID, SEQ, STEP) values (?, ?, ?)", 1);
        }
        this.fInsertDataPoint.setInt(1, sample_id);
        this.fInsertDataPoint.setInt(2, seq);
        this.fInsertDataPoint.setInt(3, step);
        return SQL.create(this.fInsertDataPoint);
    }

    void insertScalar(int datapoint_id, int dim_id, long value) throws SQLException {
        if (this.fInsertScalar == null) {
            this.fInsertScalar = this.fConnection.prepareStatement("insert into SCALAR values (?, ?, ?)");
        }
        this.fInsertScalar.setInt(1, datapoint_id);
        this.fInsertScalar.setInt(2, dim_id);
        this.fInsertScalar.setLong(3, value);
        this.fInsertScalar.executeUpdate();
    }

    ResultSet queryDataPoints(Variations variations, String scenarioName) throws SQLException {
        if (this.fQueryDatapoints == null) {
            this.fQueryDatapoints = this.fConnection.prepareStatement("select DATAPOINT.ID, DATAPOINT.STEP from VARIATION, SCENARIO, SAMPLE, DATAPOINT where SAMPLE.VARIATION_ID = VARIATION.ID and VARIATION.KEYVALPAIRS = ? and SAMPLE.SCENARIO_ID = SCENARIO.ID and SCENARIO.NAME LIKE ? and DATAPOINT.SAMPLE_ID = SAMPLE.ID ");
        }
        this.fQueryDatapoints.setString(1, variations.toExactMatchString());
        this.fQueryDatapoints.setString(2, scenarioName);
        return this.fQueryDatapoints.executeQuery();
    }

    ResultSet queryScalars(int datapointId) throws SQLException {
        if (this.fQueryScalars == null) {
            this.fQueryScalars = this.fConnection.prepareStatement("select SCALAR.DIM_ID, SCALAR.VALUE from SCALAR where SCALAR.DATAPOINT_ID = ?");
        }
        this.fQueryScalars.setInt(1, datapointId);
        return this.fQueryScalars.executeQuery();
    }

    ResultSet queryScenarios(Variations variations, String scenarioPattern) throws SQLException {
        if (this.fQueryAllScenarios == null) {
            this.fQueryAllScenarios = this.fConnection.prepareStatement("select distinct SCENARIO.NAME from SCENARIO, SAMPLE, VARIATION where SAMPLE.VARIATION_ID = VARIATION.ID and VARIATION.KEYVALPAIRS LIKE ? and SAMPLE.SCENARIO_ID = SCENARIO.ID and SCENARIO.NAME LIKE ?");
        }
        this.fQueryAllScenarios.setString(1, variations.toQueryPattern());
        this.fQueryAllScenarios.setString(2, scenarioPattern);
        return this.fQueryAllScenarios.executeQuery();
    }

    ResultSet queryVariations(String variations, String scenarioPattern) throws SQLException {
        if (this.fQueryVariations == null) {
            this.fQueryVariations = this.fConnection.prepareStatement("select distinct VARIATION.KEYVALPAIRS from VARIATION, SAMPLE, SCENARIO where SAMPLE.VARIATION_ID = VARIATION.ID and VARIATION.KEYVALPAIRS LIKE ? and SAMPLE.SCENARIO_ID = SCENARIO.ID and SCENARIO.NAME LIKE ?");
        }
        this.fQueryVariations.setString(1, variations);
        this.fQueryVariations.setString(2, scenarioPattern);
        return this.fQueryVariations.executeQuery();
    }

    void createSummaryEntry(int variation_id, int scenario_id, int dim_id, boolean isGlobal, int comment_id) throws SQLException {
        if (this.fQuerySummaryEntry == null) {
            this.fQuerySummaryEntry = this.fConnection.prepareStatement("select count(*) from SUMMARYENTRY where VARIATION_ID = ? and SCENARIO_ID = ? and DIM_ID = ? and IS_GLOBAL = ? and COMMENT_ID = ?");
        }
        this.fQuerySummaryEntry.setInt(1, variation_id);
        this.fQuerySummaryEntry.setInt(2, scenario_id);
        this.fQuerySummaryEntry.setInt(3, dim_id);
        this.fQuerySummaryEntry.setShort(4, (short)(isGlobal ? 1 : 0));
        this.fQuerySummaryEntry.setInt(5, comment_id);
        ResultSet result = this.fQuerySummaryEntry.executeQuery();
        if (result.next() && result.getInt(1) > 0) {
            return;
        }
        if (this.fInsertSummaryEntry == null) {
            this.fInsertSummaryEntry = this.fConnection.prepareStatement("insert into SUMMARYENTRY (VARIATION_ID, SCENARIO_ID, DIM_ID, IS_GLOBAL, COMMENT_ID) values (?, ?, ?, ?, ?)");
        }
        this.fInsertSummaryEntry.setInt(1, variation_id);
        this.fInsertSummaryEntry.setInt(2, scenario_id);
        this.fInsertSummaryEntry.setInt(3, dim_id);
        this.fInsertSummaryEntry.setShort(4, (short)(isGlobal ? 1 : 0));
        this.fInsertSummaryEntry.setInt(5, comment_id);
        this.fInsertSummaryEntry.executeUpdate();
    }

    public void setScenarioShortName(int scenario_id, String shortName) throws SQLException {
        if (shortName.length() >= 40) {
            shortName = shortName.substring(0, 40);
        }
        if (this.fUpdateScenarioShortName == null) {
            this.fUpdateScenarioShortName = this.fConnection.prepareStatement("update SCENARIO set SHORT_NAME = ? where SCENARIO.ID = ?");
        }
        this.fUpdateScenarioShortName.setString(1, shortName);
        this.fUpdateScenarioShortName.setInt(2, scenario_id);
        this.fUpdateScenarioShortName.executeUpdate();
    }

    ResultSet queryGlobalSummaryEntries(Variations variations) throws SQLException {
        if (this.fQueryGlobalSummaryEntries == null) {
            this.fQueryGlobalSummaryEntries = this.fConnection.prepareStatement("select distinct SCENARIO.NAME, SCENARIO.SHORT_NAME, SUMMARYENTRY.DIM_ID, SUMMARYENTRY.IS_GLOBAL, SUMMARYENTRY.COMMENT_ID from VARIATION, SCENARIO, SUMMARYENTRY where SUMMARYENTRY.VARIATION_ID = VARIATION.ID and VARIATION.KEYVALPAIRS LIKE ? and SUMMARYENTRY.SCENARIO_ID = SCENARIO.ID and SUMMARYENTRY.IS_GLOBAL = 1 order by SCENARIO.NAME");
        }
        this.fQueryGlobalSummaryEntries.setString(1, variations.toExactMatchString());
        return this.fQueryGlobalSummaryEntries.executeQuery();
    }

    ResultSet querySummaryEntries(Variations variations, String scenarioPattern) throws SQLException {
        if (this.fQuerySummaryEntries == null) {
            this.fQuerySummaryEntries = this.fConnection.prepareStatement("select distinct SCENARIO.NAME, SCENARIO.SHORT_NAME, SUMMARYENTRY.DIM_ID, SUMMARYENTRY.IS_GLOBAL, SUMMARYENTRY.COMMENT_ID from VARIATION, SCENARIO, SUMMARYENTRY where SUMMARYENTRY.VARIATION_ID = VARIATION.ID and VARIATION.KEYVALPAIRS LIKE ? and SUMMARYENTRY.SCENARIO_ID = SCENARIO.ID and SCENARIO.NAME like ? order by SCENARIO.NAME");
        }
        this.fQuerySummaryEntries.setString(1, variations.toExactMatchString());
        this.fQuerySummaryEntries.setString(2, scenarioPattern);
        return this.fQuerySummaryEntries.executeQuery();
    }

    void insertFailure(int variation_id, int scenario_id, String message) throws SQLException {
        if (this.fInsertFailure == null) {
            this.fInsertFailure = this.fConnection.prepareStatement("insert into FAILURE values (?, ?, ?)");
        }
        this.fInsertFailure.setInt(1, variation_id);
        this.fInsertFailure.setInt(2, scenario_id);
        this.fInsertFailure.setString(3, message);
        this.fInsertFailure.executeUpdate();
    }

    public ResultSet queryFailure(Variations variations, String scenarioPattern) throws SQLException {
        if (this.fQueryFailure == null) {
            this.fQueryFailure = this.fConnection.prepareStatement("select SCENARIO.NAME, FAILURE.MESSAGE from FAILURE, VARIATION, SCENARIO where FAILURE.VARIATION_ID = VARIATION.ID and VARIATION.KEYVALPAIRS LIKE ? and FAILURE.SCENARIO_ID = SCENARIO.ID and SCENARIO.NAME LIKE ?");
        }
        this.fQueryFailure.setString(1, variations.toExactMatchString());
        this.fQueryFailure.setString(2, scenarioPattern);
        return this.fQueryFailure.executeQuery();
    }

    int getCommentId(int commentKind, String comment) throws SQLException {
        if (comment.length() > 400) {
            comment = comment.substring(0, 400);
        }
        if (this.fQueryComment == null) {
            this.fQueryComment = this.fConnection.prepareStatement("select ID from COMMENT where KIND = ? and TEXT = ?");
        }
        this.fQueryComment.setInt(1, commentKind);
        this.fQueryComment.setString(2, comment);
        ResultSet result = this.fQueryComment.executeQuery();
        if (result.next()) {
            return result.getInt(1);
        }
        if (this.fInsertComment == null) {
            this.fInsertComment = this.fConnection.prepareStatement("insert into COMMENT (KIND, TEXT) values (?, ?)", 1);
        }
        this.fInsertComment.setInt(1, commentKind);
        this.fInsertComment.setString(2, comment);
        return SQL.create(this.fInsertComment);
    }

    public ResultSet getComment(int comment_id) throws SQLException {
        if (this.fQueryComment2 == null) {
            this.fQueryComment2 = this.fConnection.prepareStatement("select KIND, TEXT from COMMENT where ID = ?");
        }
        this.fQueryComment2.setInt(1, comment_id);
        return this.fQueryComment2.executeQuery();
    }
}

