/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.deeplink;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.e4.core.deeplink.DeepLinkResultException;
import org.eclipse.e4.core.deeplink.internal.NullNode;
import org.eclipse.e4.core.functionalprog.optionmonad.Nulls;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeepLinkResult {
    private static final String RESULT_ELEMENT_NAME = "result";
    private static final String CALLBACK_RAN_ELEMENT_NAME = "callbackRan";
    private static final String LOADED_ELEMENT_NAME = "loaded";
    private static final String EXCEPTION_ELEMENT_NAME = "exception";
    private static final String OUTPUTDATA_ELEMENT_NAME = "outputData";
    private static final String OUTPUTDATA_RESULT_KEY = "key";
    public final Boolean loaded;
    public final Boolean callbackRan;
    public final String exception;
    public final Map<String, String> outputData = new HashMap<String, String>();

    public DeepLinkResult(InputStream resultStream) throws DeepLinkResultException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(resultStream);
        }
        catch (Exception e) {
            throw new DeepLinkResultException("Failure reading deep link result XML", e);
        }
        doc.getDocumentElement().normalize();
        NodeList results = (NodeList)Nulls.valueOrThrow((Object)doc.getElementsByTagName(RESULT_ELEMENT_NAME), (Throwable)this.resultFailure("No deep link result XML element"));
        if (results.getLength() != 1) {
            throw this.resultFailure("Incorrect number of result values: " + results.getLength());
        }
        Node resultNode = (Node)Nulls.valueOrThrow((Object)results.item(0), (Throwable)this.resultFailure("index out of bounds"));
        NamedNodeMap attributes = (NamedNodeMap)Nulls.valueOrThrow((Object)resultNode.getAttributes(), (Throwable)this.resultFailure("No attributes on <result> tag?"));
        String loaded = ((Node)Nulls.valueOrSubstitute((Object)attributes.getNamedItem(LOADED_ELEMENT_NAME), (Object)new NullNode())).getNodeValue();
        String callbackRan = ((Node)Nulls.valueOrSubstitute((Object)attributes.getNamedItem(CALLBACK_RAN_ELEMENT_NAME), (Object)new NullNode())).getNodeValue();
        String exception = ((Node)Nulls.valueOrSubstitute((Object)attributes.getNamedItem(EXCEPTION_ELEMENT_NAME), (Object)new NullNode())).getNodeValue();
        this.loaded = "undefined".equals(loaded) ? null : Boolean.valueOf(Boolean.parseBoolean(loaded));
        this.callbackRan = "undefined".equals(callbackRan) ? null : Boolean.valueOf(Boolean.parseBoolean(callbackRan));
        this.exception = "undefined".equals(exception) ? null : exception;
        NodeList outputDataXML = doc.getElementsByTagName(OUTPUTDATA_ELEMENT_NAME);
        Node outputNode = outputDataXML.item(0);
        if (outputNode == null) {
            return;
        }
        NodeList childNodes = outputNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node outputItem = childNodes.item(i);
            if (!"#text".equals(outputItem.getNodeName())) {
                attributes = (NamedNodeMap)Nulls.valueOrThrow((Object)outputItem.getAttributes(), (Throwable)this.resultFailure("No attributes on <outputData> tag?"));
                String key = ((Node)Nulls.valueOrThrow((Object)attributes.getNamedItem(OUTPUTDATA_RESULT_KEY), (Throwable)this.resultFailure("No key in output <element...> tag?"))).getNodeValue();
                key = StringEscapeUtils.unescapeXml((String)key);
                String value = outputItem.getTextContent();
                this.outputData.put(key, value);
            }
            ++i;
        }
    }

    private DeepLinkResultException resultFailure(String message) {
        return new DeepLinkResultException(message);
    }
}

