/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.internal.xp.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.platform.discovery.runtime.api.ISearchProvider;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.IDestinationCategoryExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.IObjectTypeExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.ISearchProvidersExtensionParser;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;

public class SearchProvidersExtensionParser
extends AbstractExtensionPointParser
implements ISearchProvidersExtensionParser {
    private static final String XP_ID = "org.eclipse.platform.discovery.runtime.searchprovider";
    private static final String XP_ELEMENT_NAME = "searchprovider";
    private static final String CATEGORY_ELEMENT_NAME = "category";
    private static final String PROVIDER_ID_ATTR = "id";
    private static final String PROVIDER_INSTANCE_ATTR = "instance";
    private static final String OBJECT_ID_ATTR = "objecttypeid";
    private static final String SUPPORTS_TEXT_SEARCH_ATTR = "supportstextsearch";
    private static final String CATEGORY_ID_ATTR = "categoryid";
    private final IDestinationCategoryExtensionParser destCategoryExtParser;
    private final IObjectTypeExtensionParser objTypeExtParser;

    public SearchProvidersExtensionParser(IDestinationCategoryExtensionParser destCategoryParser, IObjectTypeExtensionParser objectTypeExtParser) {
        super(Platform.getExtensionRegistry(), XP_ID, XP_ELEMENT_NAME);
        this.destCategoryExtParser = destCategoryParser;
        this.objTypeExtParser = objectTypeExtParser;
    }

    @Override
    public Set<ISearchProviderDescription> readContributions() {
        HashSet<ISearchProviderDescription> result = new HashSet<ISearchProviderDescription>();
        for (IConfigurationElement element : this.getConfigurationElements()) {
            result.add(this.createSearchProvider(element));
        }
        return result;
    }

    private ISearchProviderDescription createSearchProvider(final IConfigurationElement element) {
        final Set<IDestinationCategoryDescription> categories = this.getDestinationCategories(element);
        final IObjectTypeDescription objectType = this.getObjectTypeById(element.getAttribute(OBJECT_ID_ATTR));
        return new ISearchProviderDescription(){

            @Override
            public ISearchProvider createInstance() {
                try {
                    return (ISearchProvider)element.createExecutableExtension(SearchProvidersExtensionParser.PROVIDER_INSTANCE_ATTR);
                }
                catch (CoreException e) {
                    throw new IllegalStateException("Search provider could not be instantiated", e);
                }
            }

            @Override
            public IObjectTypeDescription getObjectType() {
                return objectType;
            }

            @Override
            public Set<IDestinationCategoryDescription> getSupportedDestinationCategories() {
                return categories;
            }

            @Override
            public boolean supportsTextSearch() {
                return new Boolean(element.getAttribute(SearchProvidersExtensionParser.SUPPORTS_TEXT_SEARCH_ATTR));
            }

            @Override
            public String getDisplayName() {
                return element.getAttribute(SearchProvidersExtensionParser.PROVIDER_INSTANCE_ATTR);
            }

            @Override
            public String getId() {
                return element.getAttribute(SearchProvidersExtensionParser.PROVIDER_ID_ATTR);
            }
        };
    }

    private IObjectTypeDescription getObjectTypeById(String objectTypeId) {
        for (IObjectTypeDescription objType : this.objTypeExtParser.readContributions()) {
            if (!objType.getId().equals(objectTypeId)) continue;
            return objType;
        }
        throw new IllegalStateException("Object type with id " + objectTypeId + " not found");
    }

    private Set<IDestinationCategoryDescription> getDestinationCategories(IConfigurationElement element) {
        HashSet<IDestinationCategoryDescription> categories = new HashSet<IDestinationCategoryDescription>();
        HashSet<String> supportedCategories = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(CATEGORY_ELEMENT_NAME);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement catElement = iConfigurationElementArray[n2];
            supportedCategories.add(catElement.getAttribute(CATEGORY_ID_ATTR));
            ++n2;
        }
        for (IDestinationCategoryDescription cat : this.destCategoryExtParser.readContributions()) {
            if (!supportedCategories.contains(cat.getId())) continue;
            categories.add(cat);
        }
        return categories;
    }
}

