/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.ecore.javascript;

import junit.framework.TestCase;
import org.eclipse.e4.emf.ecore.javascript.JavascriptSupport;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;

public class AbstractJavascriptTest
extends TestCase {
    protected JavascriptSupport javascriptSupport;
    protected XMIResource resource;
    protected boolean rethrowException = true;
    public static final URI TESTS_URI = URI.createURI((String)"http://www.eclipse.org/e4/emf/ecore/javascript/tests/");

    protected void setUp(String testData) throws Exception {
        super.setUp();
        this.javascriptSupport = new JavascriptSupport();
        URI testUri = URI.createURI((String)String.valueOf(((Object)((Object)this)).getClass().getResource(testData)));
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getLoadOptions().put("SCHEMA_LOCATION", Boolean.TRUE);
        URI testFolderUri = JavascriptSupport.createParentFolderUri((URI)testUri);
        resourceSet.getURIConverter().getURIMap().put(TESTS_URI, testFolderUri);
        this.javascriptSupport.setUriConverter(resourceSet.getURIConverter());
        String packageUriString = TESTS_URI.trimSegments(1).appendSegment(testUri.lastSegment()).trimFileExtension().appendFileExtension("ecore").toString();
        this.javascriptSupport.loadEPackage(packageUriString, null);
        this.resource = (XMIResource)resourceSet.getResource(testUri, true);
    }

    protected Object getFeatureValue(EObject eObject, String featureName) {
        return eObject.eGet(eObject.eClass().getEStructuralFeature(featureName));
    }

    protected void setFeatureValue(EObject eObject, String featureName, Object value) {
        eObject.eSet(eObject.eClass().getEStructuralFeature(featureName), value);
    }
}

