/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.editor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.xwt.tools.ui.designer.editor.model.Synchronizer;
import org.eclipse.e4.xwt.tools.ui.designer.editor.model.XWTModelBuilder;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuilderContext {
    private static final String CHARACTERS = "abcdefghigklmnopqrstuvwxyz";
    private final Map<XamlNode, IDOMNode> model2text = new HashMap<XamlNode, IDOMNode>(1);
    private final Map<IDOMNode, XamlNode> text2model = new HashMap<IDOMNode, XamlNode>(1);
    private XWTModelBuilder modelBuilder;
    private IDOMDocument textRoot;
    private XamlDocument modelRoot;
    private Synchronizer synchronizer;
    private Adapter modelAdapter;
    private INodeAdapter nodeAdapter;

    public BuilderContext(XWTModelBuilder modelBuilder, IDOMDocument textDocument, XamlDocument modelDocument, Synchronizer synchronizer) {
        Assert.isNotNull((Object)textDocument);
        Assert.isNotNull((Object)modelDocument);
        this.modelBuilder = modelBuilder;
        this.textRoot = textDocument;
        this.modelRoot = modelDocument;
        this.synchronizer = synchronizer;
    }

    public XWTModelBuilder getModelBuilder() {
        return this.modelBuilder;
    }

    public IDOMDocument getTextRoot() {
        return this.textRoot;
    }

    public XamlDocument getModelRoot() {
        return this.modelRoot;
    }

    public Synchronizer getSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new Synchronizer();
        }
        return this.synchronizer;
    }

    public void map(XamlNode model, IDOMNode textNode) {
        this.model2text.put(model, textNode);
        this.text2model.put(textNode, model);
        if (model != null && this.modelAdapter != null && !model.eAdapters().contains((Object)this.modelAdapter)) {
            model.eAdapters().add((Object)this.modelAdapter);
        }
        if (textNode != null && this.nodeAdapter != null && !textNode.getAdapters().contains(this.nodeAdapter)) {
            textNode.addAdapter(this.nodeAdapter);
        }
    }

    public void remove(Object obj) {
        XamlNode removedModel;
        IDOMNode removedText = this.model2text.remove(obj);
        if (removedText != null) {
            this.text2model.remove(removedText);
            if (this.nodeAdapter != null) {
                removedText.removeAdapter(this.nodeAdapter);
            }
        }
        if ((removedModel = this.text2model.remove(obj)) != null) {
            this.model2text.remove(removedModel);
            if (this.modelAdapter != null) {
                removedModel.eAdapters().remove((Object)this.modelAdapter);
            }
        }
    }

    public void clear() {
        this.model2text.clear();
        this.text2model.clear();
    }

    public XamlNode getModel(Object textNode) {
        return this.text2model.get(textNode);
    }

    public IDOMNode getTextNode(Object model) {
        return this.model2text.get(model);
    }

    public List<IDOMElement> getChildNodes(IDOMNode parent) {
        if (parent == null) {
            return Collections.emptyList();
        }
        ArrayList<IDOMElement> childNodes = new ArrayList<IDOMElement>();
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child instanceof IDOMElement && child.getLocalName().indexOf(".") == -1) {
                childNodes.add((IDOMElement)child);
            }
            child = child.getNextSibling();
        }
        return childNodes;
    }

    public List<Text> getContentNodes(IDOMNode node) {
        NodeList childNodes = node.getChildNodes();
        int length = childNodes.getLength();
        if (length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Text> contentTexts = new ArrayList<Text>();
        int i = 0;
        while (i < length) {
            Node item = childNodes.item(i);
            if (item.getNodeType() == 3) {
                contentTexts.add((Text)item);
            }
            ++i;
        }
        return contentTexts;
    }

    public String getContent(IDOMNode parent) {
        List<Text> textNodes = this.getContentNodes(parent);
        if (textNodes.isEmpty()) {
            return null;
        }
        StringBuilder content = new StringBuilder();
        for (Text text : textNodes) {
            String value = text.getNodeValue();
            if (value == null || (value = this.filter(value.trim())).length() == 0) continue;
            content.append(value);
        }
        return content.length() > 0 ? content.toString() : null;
    }

    public String filter(String value) {
        value = value.replace("\n", "");
        value = value.replace("\t", "");
        value = value.replace("\r", "");
        return value;
    }

    public List<IDOMNode> getAttributes(IDOMNode parent) {
        NodeList children;
        Object item;
        int i;
        if (parent == null) {
            return Collections.emptyList();
        }
        ArrayList<IDOMNode> attributes = new ArrayList<IDOMNode>();
        NamedNodeMap attrMap = parent.getAttributes();
        if (attrMap != null) {
            int length = attrMap.getLength();
            i = 0;
            while (i < length) {
                item = (IDOMAttr)attrMap.item(i);
                String name = item.getLocalName();
                String prefix = item.getPrefix();
                if (name.indexOf(".") != -1) {
                    name = name.substring(name.indexOf(".") + 1);
                    prefix = null;
                }
                if (!"xmlns".equals(name) && !"xmlns".equals(prefix)) {
                    attributes.add((IDOMNode)item);
                }
                ++i;
            }
        }
        if ((children = parent.getChildNodes()) != null) {
            i = 0;
            while (i < children.getLength()) {
                item = children.item(i);
                String localName = item.getLocalName();
                if (item instanceof IDOMElement && localName.indexOf(".") != -1) {
                    attributes.add((IDOMNode)((IDOMElement)item));
                }
                ++i;
            }
        }
        return attributes;
    }

    public boolean contains(Node parent, Attr attr) {
        NamedNodeMap attributes = parent.getAttributes();
        int i = attributes.getLength() - 1;
        while (i >= 0) {
            if (attr == attributes.item(i)) {
                return true;
            }
            --i;
        }
        return false;
    }

    protected String getPrefix(String namespace) {
        char[] c;
        EMap declaredNamespaces = this.modelRoot.getDeclaredNamespaces();
        Set existings = declaredNamespaces.keySet();
        for (String p : existings) {
            if (!namespace.equals(declaredNamespaces.get((Object)p))) continue;
            return p;
        }
        char[] cArray = c = CHARACTERS.toCharArray();
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            char d = cArray[n2];
            String prefix = Character.toString(d);
            if (!existings.contains(prefix)) {
                return prefix;
            }
            ++n2;
        }
        return "j";
    }

    public void setModelAdapter(Adapter modelAdapter) {
        this.modelAdapter = modelAdapter;
    }

    public Adapter getModelAdapter() {
        return this.modelAdapter;
    }

    public void setNodeAdapter(INodeAdapter nodeAdapter) {
        this.nodeAdapter = nodeAdapter;
    }

    public INodeAdapter getNodeAdapter() {
        return this.nodeAdapter;
    }
}

