/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.javabean;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.e4.xwt.IEventInvoker;
import org.eclipse.e4.xwt.XWTMaps;
import org.eclipse.e4.xwt.internal.core.IEventController;
import org.eclipse.e4.xwt.metadata.IEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class Controller
implements Listener,
IEventController {
    int waterMark = 0;
    protected int[] eventTypes = null;
    protected String[] names = null;
    protected Object[] handlers = null;
    protected Object[] receivers = null;
    protected Object[] args = null;

    protected void fireEvent(Event e) {
        int eventType = e.type;
        if (this.eventTypes == null) {
            return;
        }
        int i = 0;
        while (i < this.eventTypes.length) {
            if (this.eventTypes[i] == eventType) {
                Object handler = this.handlers[i];
                if (handler instanceof IEventInvoker) {
                    IEventInvoker eventInvoker = (IEventInvoker)handler;
                    try {
                        eventInvoker.invoke(this.args[i], e);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        return;
                    }
                }
                Method method = (Method)handler;
                try {
                    method.setAccessible(true);
                    if (method.getParameterTypes().length == 1) {
                        method.invoke(this.receivers[i], e);
                    } else {
                        method.invoke(this.receivers[i], this.args[i], e);
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    return;
                }
            }
            ++i;
        }
    }

    public boolean hasEvent(Object receiver, IEvent event) {
        if (this.receivers == null) {
            return false;
        }
        int i = 0;
        while (i < this.receivers.length) {
            if (this.receivers[i] == receiver && this.names[i].equalsIgnoreCase(event.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addEvent(int eventType, String name, IEvent event, Widget control, Object receiver, Object arg, Method method) {
        this.doAddEvent(eventType, name, event, control, receiver, arg, method);
    }

    public void addEvent(int eventType, String name, IEvent event, Widget control, Object arg, IEventInvoker eventInvoker) {
        this.doAddEvent(eventType, name, event, control, null, arg, eventInvoker);
    }

    protected void doAddEvent(int eventType, String name, IEvent event, Widget control, Object receiver, Object arg, Object method) {
        int swt_paint;
        if (this.eventTypes == null) {
            this.eventTypes = new int[3];
            this.handlers = new Method[3];
            this.names = new String[3];
            this.receivers = new Object[3];
            this.args = new Object[3];
        } else {
            int i = 0;
            while (i < this.eventTypes.length) {
                if (this.eventTypes[i] == eventType && this.handlers[i] == method && this.receivers[i] == this.receivers && this.args[i] == arg) {
                    return;
                }
                ++i;
            }
        }
        if (this.waterMark >= this.eventTypes.length) {
            int[] oldEventTypes = this.eventTypes;
            Object[] oldHandlers = this.handlers;
            Object[] oldReceivers = this.receivers;
            String[] oldNames = this.names;
            Object[] oldArgs = this.args;
            this.eventTypes = new int[this.waterMark + 3];
            this.handlers = new Object[this.waterMark + 3];
            this.receivers = new Object[this.waterMark + 3];
            this.names = new String[this.waterMark + 3];
            this.args = new Object[this.waterMark + 3];
            System.arraycopy(oldEventTypes, 0, this.eventTypes, 0, this.waterMark);
            System.arraycopy(oldHandlers, 0, this.handlers, 0, this.waterMark);
            System.arraycopy(oldReceivers, 0, this.receivers, 0, this.waterMark);
            System.arraycopy(oldArgs, 0, this.args, 0, this.waterMark);
            System.arraycopy(oldNames, 0, this.names, 0, this.waterMark);
        }
        this.eventTypes[this.waterMark] = eventType;
        this.handlers[this.waterMark] = method;
        this.receivers[this.waterMark] = receiver;
        this.args[this.waterMark] = arg;
        this.names[this.waterMark++] = name;
        if (eventType == 1025 && (swt_paint = XWTMaps.getEvent("swt.paint")) != 0) {
            Listener[] listeners = control.getListeners(swt_paint);
            if (listeners.length > 0) {
                Listener listener;
                Listener[] listenerArray = listeners;
                int n = listeners.length;
                int n2 = 0;
                while (n2 < n) {
                    listener = listenerArray[n2];
                    control.removeListener(swt_paint, listener);
                    ++n2;
                }
                control.addListener(swt_paint, (Listener)new LoadedEventListener(control));
                listenerArray = listeners;
                n = listeners.length;
                n2 = 0;
                while (n2 < n) {
                    listener = listenerArray[n2];
                    control.addListener(swt_paint, listener);
                    ++n2;
                }
            } else {
                control.addListener(swt_paint, (Listener)new LoadedEventListener(control));
            }
        }
        control.addListener(eventType, (Listener)this);
    }

    public void setEvent(IEvent event, Widget control, Object receiver, Object arg, Method method) {
        String name = event.getName();
        int eventType = Controller.getEventTypeByName(name);
        if (eventType != 0) {
            this.addEvent(eventType, name, event, control, receiver, arg, method);
        }
    }

    public void setEvent(IEvent event, Widget control, Object arg, IEventInvoker eventInvoker) {
        String name = event.getName();
        int eventType = Controller.getEventTypeByName(name);
        if (eventType != 0) {
            this.doAddEvent(eventType, name, event, control, null, arg, eventInvoker);
        }
    }

    public static Event copy(Event event) {
        Event copyEvent = new Event();
        Field[] fieldArray = event.getClass().getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                field.set(copyEvent, field.get(event));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return copyEvent;
    }

    public static int getEventTypeByName(String name) {
        if ("KeyDown".equalsIgnoreCase(name)) {
            return 1;
        }
        if ("KeyUp".equalsIgnoreCase(name)) {
            return 2;
        }
        if ("MouseDown".equalsIgnoreCase(name)) {
            return 3;
        }
        if ("MouseUp".equalsIgnoreCase(name)) {
            return 4;
        }
        if ("MouseMove".equalsIgnoreCase(name)) {
            return XWTMaps.getEvent("swt.mousemove");
        }
        if ("MouseEnter".equalsIgnoreCase(name)) {
            return XWTMaps.getEvent("swt.mouseenter");
        }
        if ("MouseExit".equalsIgnoreCase(name)) {
            return XWTMaps.getEvent("swt.mouseexit");
        }
        if ("MouseDoubleClick".equalsIgnoreCase(name)) {
            return 8;
        }
        if ("Paint".equalsIgnoreCase(name)) {
            return XWTMaps.getEvent("swt.paint");
        }
        if ("Move".equalsIgnoreCase(name)) {
            return 10;
        }
        if ("Resize".equalsIgnoreCase(name)) {
            return 11;
        }
        if ("Dispose".equalsIgnoreCase(name)) {
            return 12;
        }
        if ("Selection".equalsIgnoreCase(name)) {
            return 13;
        }
        if ("DefaultSelection".equalsIgnoreCase(name)) {
            return 14;
        }
        if ("FocusIn".equalsIgnoreCase(name)) {
            return 15;
        }
        if ("FocusOut".equalsIgnoreCase(name)) {
            return 16;
        }
        if ("Expand".equalsIgnoreCase(name)) {
            return 17;
        }
        if ("Collapse".equalsIgnoreCase(name)) {
            return 18;
        }
        if ("Iconify".equalsIgnoreCase(name)) {
            return XWTMaps.getEvent("swt.iconify");
        }
        if ("Deiconify".equalsIgnoreCase(name)) {
            return XWTMaps.getEvent("swt.deiconify");
        }
        if ("Close".equalsIgnoreCase(name)) {
            return 21;
        }
        if ("Show".equalsIgnoreCase(name)) {
            return 22;
        }
        if ("Hide".equalsIgnoreCase(name)) {
            return 23;
        }
        if ("Modify".equalsIgnoreCase(name)) {
            return 24;
        }
        if ("Verify".equalsIgnoreCase(name)) {
            return 25;
        }
        if ("Activate".equalsIgnoreCase(name)) {
            return 26;
        }
        if ("Deactivate".equalsIgnoreCase(name)) {
            return 27;
        }
        if ("Help".equalsIgnoreCase(name)) {
            return 28;
        }
        if ("DragDetect".equalsIgnoreCase(name)) {
            return 29;
        }
        if ("Arm".equalsIgnoreCase(name)) {
            return 30;
        }
        if ("Traverse".equalsIgnoreCase(name)) {
            return 31;
        }
        if ("MouseHover".equalsIgnoreCase(name)) {
            return XWTMaps.getEvent("swt.mousehover");
        }
        if ("HardKeyDown".equalsIgnoreCase(name)) {
            return XWTMaps.getEvent("swt.hardkeydown");
        }
        if ("HardKeyUp".equalsIgnoreCase(name)) {
            return XWTMaps.getEvent("swt.hardkeyup");
        }
        if ("MenuDetect".equalsIgnoreCase(name)) {
            return 35;
        }
        if ("MouseWheel".equalsIgnoreCase(name)) {
            return XWTMaps.getEvent("swt.mousewheel");
        }
        if ("Settings".equalsIgnoreCase(name)) {
            return XWTMaps.getEvent("swt.settings");
        }
        if ("EraseItem".equalsIgnoreCase(name)) {
            return XWTMaps.getEvent("swt.eraseitem");
        }
        if ("MeasureItem".equalsIgnoreCase(name)) {
            return XWTMaps.getEvent("swt.measureitem");
        }
        if ("PaintItem".equalsIgnoreCase(name)) {
            return XWTMaps.getEvent("swt.paintitem");
        }
        if ("Loaded".equalsIgnoreCase(name) || "LoadedEvent".equalsIgnoreCase(name)) {
            return 1025;
        }
        return 0;
    }

    public void handleEvent(Event e) {
        this.fireEvent(e);
    }

    class LoadedEventListener
    implements Listener {
        protected Widget control;

        public LoadedEventListener(Widget control) {
            this.control = control;
        }

        public void handleEvent(Event event) {
            Event loadedEvent = Controller.copy(event);
            loadedEvent.type = 1025;
            if (XWTMaps.getEvent("swt.paint") != 0) {
                this.control.removeListener(XWTMaps.getEvent("swt.paint"), (Listener)this);
            }
            Controller.this.handleEvent(loadedEvent);
        }
    }
}

