/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.dom.properties.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.dom.properties.providers.AbstractCSSPropertyHandlerProvider;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.exceptions.UnsupportedClassCSSPropertyException;
import org.eclipse.e4.ui.css.core.utils.StringUtils;
import org.w3c.dom.css.CSSStyleDeclaration;

public class CSSPropertyHandlerLazyProviderImpl
extends AbstractCSSPropertyHandlerProvider {
    private List packageNames = new ArrayList();
    private Map propertyToHandlersMap = new HashMap();

    public Collection getCSSPropertyHandlers(String property) throws Exception {
        Map propertyHandlers = this.getPropertyToHandlersMap();
        Object h = propertyHandlers.get(property);
        if (h != null) {
            if (h instanceof List) {
                return (List)h;
            }
            return null;
        }
        ArrayList<ICSSPropertyHandler> handlers = null;
        try {
            String handlerClassName = this.getHandlerClassName(property);
            for (String packageName : this.packageNames) {
                ICSSPropertyHandler handler = this.getCSSPropertyHandler(packageName, handlerClassName);
                if (handler == null) continue;
                if (handlers == null) {
                    handlers = new ArrayList<ICSSPropertyHandler>();
                }
                handlers.add(handler);
            }
        }
        finally {
            if (handlers != null) {
                propertyHandlers.put(property, handlers);
            } else {
                propertyHandlers.put(property, "__HANDLER_NOT_FOUND__");
            }
        }
        return handlers;
    }

    public void registerPackage(String packageName) {
        this.packageNames.add(packageName);
        this.propertyToHandlersMap = null;
    }

    protected Map getPropertyToHandlersMap() {
        if (this.propertyToHandlersMap == null) {
            this.propertyToHandlersMap = new HashMap();
        }
        return this.propertyToHandlersMap;
    }

    protected ICSSPropertyHandler getCSSPropertyHandler(String packageName, String handlerClassName) throws Exception {
        String handlerClass = String.valueOf(packageName) + "." + handlerClassName;
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(handlerClass);
            Object instance = clazz.newInstance();
            if (!(instance instanceof ICSSPropertyHandler)) {
                throw new UnsupportedClassCSSPropertyException(clazz);
            }
            return (ICSSPropertyHandler)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected String getHandlerClassName(String property) {
        String handlerClassName = "CSSProperty";
        String[] s = StringUtils.split(property, "-");
        int i = 0;
        while (i < s.length) {
            String p = s[i];
            p = String.valueOf(p.substring(0, 1).toUpperCase()) + p.substring(1, p.length());
            handlerClassName = String.valueOf(handlerClassName) + p;
            ++i;
        }
        handlerClassName = String.valueOf(handlerClassName) + "Handler";
        return handlerClassName;
    }

    protected CSSStyleDeclaration getDefaultCSSStyleDeclaration(CSSEngine engine, CSSStylableElement stylableElement, CSSStyleDeclaration newStyle, String pseudoE) throws Exception {
        if (stylableElement.getDefaultStyleDeclaration(pseudoE) != null) {
            return stylableElement.getDefaultStyleDeclaration(pseudoE);
        }
        if (newStyle != null) {
            StringBuffer style = null;
            int length = newStyle.getLength();
            int i = 0;
            while (i < length) {
                String propertyName = newStyle.item(i);
                String[] compositePropertiesNames = engine.getCSSCompositePropertiesNames(propertyName);
                if (compositePropertiesNames != null) {
                    int j = 0;
                    while (j < compositePropertiesNames.length) {
                        propertyName = compositePropertiesNames[j];
                        String s = this.getCSSPropertyStyle(engine, stylableElement, propertyName, pseudoE);
                        if (s != null) {
                            if (style == null) {
                                style = new StringBuffer();
                            }
                            style.append(s);
                        }
                        ++j;
                    }
                } else {
                    String s = this.getCSSPropertyStyle(engine, stylableElement, propertyName, pseudoE);
                    if (s != null) {
                        if (style == null) {
                            style = new StringBuffer();
                        }
                        style.append(s);
                    }
                }
                ++i;
            }
            if (style != null) {
                CSSStyleDeclaration defaultStyleDeclaration = engine.parseStyleDeclaration(style.toString());
                stylableElement.setDefaultStyleDeclaration(pseudoE, defaultStyleDeclaration);
                return defaultStyleDeclaration;
            }
        }
        return stylableElement.getDefaultStyleDeclaration(pseudoE);
    }
}

