/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts.debug.ui;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.internal.contexts.Computation;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.debug.ui.ContextAllocation;
import org.eclipse.e4.core.internal.contexts.debug.ui.ContextData;
import org.eclipse.e4.core.internal.contexts.debug.ui.ContextLinks;
import org.eclipse.e4.core.internal.contexts.debug.ui.ContextMessages;
import org.eclipse.e4.core.internal.contexts.debug.ui.ContextSnapshot;
import org.eclipse.e4.core.internal.contexts.debug.ui.ContextTreeProvider;
import org.eclipse.e4.core.internal.contexts.debug.ui.LeaksDialog;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Tree;

public class ContextsView {
    public static final String SELECT_EVENT = "e4/contexts/debug/selectContext";
    public static final String REFRESH_EVENT = "e4/contexts/debug/refreshView";
    protected TreeViewer treeViewer;
    protected TreeViewer dataViewer;
    protected ContextAllocation allocationsViewer;
    protected TreeViewer linksViewer;
    protected ContextTreeProvider treeProvider;
    protected Button diffButton;
    protected Button snapshotButton;
    protected Button autoUpdateButton;
    protected ContextSnapshot snapshot;

    @Inject
    public ContextsView(Composite parent, MPart part) {
        SashForm sashForm = new SashForm(parent, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite treeComposite = new Composite((Composite)sashForm, 0);
        treeComposite.setLayout((Layout)new GridLayout());
        GridLayout compositeTreeLayout = new GridLayout();
        compositeTreeLayout.marginHeight = 0;
        compositeTreeLayout.marginWidth = 0;
        treeComposite.setLayout((Layout)compositeTreeLayout);
        treeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label treeLabel = new Label(treeComposite, 0);
        treeLabel.setText(ContextMessages.contextTreeLabel);
        this.treeViewer = new TreeViewer(treeComposite);
        Tree tree = this.treeViewer.getTree();
        GridData gridData = new GridData(4, 4, true, true);
        tree.setLayoutData((Object)gridData);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                WeakReference selected = (WeakReference)selection.getFirstElement();
                ContextsView.this.selectedContext((IEclipseContext)(selected == null ? null : (EclipseContext)selected.get()));
            }
        });
        this.treeProvider = new ContextTreeProvider(this, parent.getDisplay());
        this.treeViewer.setContentProvider((IContentProvider)this.treeProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                WeakReference ref = (WeakReference)element;
                EclipseContext parentContext = (EclipseContext)ref.get();
                if (parentContext != null) {
                    return parentContext.toString();
                }
                return ContextMessages.contextGCed;
            }
        });
        this.treeViewer.setSorter(new ViewerSorter());
        this.treeViewer.setInput(new Object());
        TabFolder folder = new TabFolder((Composite)sashForm, 128);
        ContextData contextData = new ContextData(folder);
        this.dataViewer = contextData.createControls();
        this.allocationsViewer = new ContextAllocation(folder);
        this.allocationsViewer.createControls();
        ContextLinks links = new ContextLinks(folder);
        this.linksViewer = links.createControls();
        Composite buttons = new Composite(treeComposite, 0);
        buttons.setLayout((Layout)new GridLayout());
        buttons.setLayoutData((Object)new GridData(4, 4, true, false));
        Group leaksHelper = new Group(buttons, 0);
        leaksHelper.setLayout((Layout)new GridLayout(2, true));
        leaksHelper.setText(ContextMessages.leaksGroup);
        leaksHelper.setLayoutData((Object)new GridData(4, 4, true, false));
        this.snapshotButton = new Button((Composite)leaksHelper, 8);
        this.snapshotButton.setText(ContextMessages.snapshotButton);
        this.snapshotButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContextsView.this.makeSnapshot();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.diffButton = new Button((Composite)leaksHelper, 8);
        this.diffButton.setText(ContextMessages.diffButton);
        this.diffButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ContextsView.this.makeDiff();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.diffButton.setEnabled(false);
        this.autoUpdateButton = new Button(buttons, 32);
        this.autoUpdateButton.setText(ContextMessages.autoUpdateButton);
        this.autoUpdateButton.setSelection(true);
        this.autoUpdateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ContextsView.this.autoUpdateButton.getSelection()) {
                    ContextsView.this.treeProvider.setAutoUpdates(true);
                    ContextsView.this.fullRefresh();
                } else {
                    ContextsView.this.treeProvider.setAutoUpdates(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.createToolbar(part);
        GridLayoutFactory.fillDefaults().generateLayout(parent);
    }

    protected void fullRefresh() {
        this.refresh();
        ITreeSelection selection = (ITreeSelection)this.treeViewer.getSelection();
        if (!selection.isEmpty()) {
            WeakReference ref = (WeakReference)selection.getFirstElement();
            EclipseContext selectedContext = (EclipseContext)ref.get();
            this.selectedContext((IEclipseContext)selectedContext);
        }
    }

    protected void selectedContext(IEclipseContext selected) {
        this.dataViewer.setInput((Object)selected);
        this.allocationsViewer.setInput(selected);
        this.linksViewer.setInput((Object)selected);
    }

    public void refresh() {
        this.treeViewer.refresh();
    }

    @Focus
    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    protected void makeSnapshot() {
        this.snapshot = new ContextSnapshot();
        this.diffButton.setEnabled(true);
    }

    protected void makeDiff() {
        if (this.snapshot == null) {
            return;
        }
        Map<EclipseContext, Set<Computation>> snapshotDiff = this.snapshot.diff();
        if (snapshotDiff == null) {
            MessageBox dialog = new MessageBox(this.snapshotButton.getShell(), 32);
            dialog.setMessage(ContextMessages.noDiffMsg);
            dialog.setText(ContextMessages.diffDialogTitle);
            dialog.open();
            return;
        }
        LeaksDialog dialog = new LeaksDialog(this.snapshotButton.getShell());
        dialog.setInput(snapshotDiff);
        dialog.open();
    }

    private void createToolbar(MPart part) {
        MToolBar toolBar = part.getToolbar();
        if (toolBar != null) {
            return;
        }
        toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
        part.setToolbar(toolBar);
        MDirectToolItem toolItem = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
        toolItem.setIconURI("platform:/plugin/org.eclipse.e4.core.contexts.debug/icons/full/obj16/target.gif");
        toolItem.setTooltip(ContextMessages.targetButtonTooltip);
        toolItem.setContributionURI("platform:/plugin/org.eclipse.e4.core.contexts.debug/org.eclipse.e4.core.internal.contexts.debug.ui.FindTargetAction");
        toolBar.getChildren().add(toolItem);
        MDirectToolItem toolItem2 = MenuFactoryImpl.eINSTANCE.createDirectToolItem();
        toolItem2.setIconURI("platform:/plugin/org.eclipse.e4.core.contexts.debug/icons/full/obj16/refresh.gif");
        toolItem2.setTooltip(ContextMessages.refreshButtonTooltip);
        toolItem2.setContributionURI("platform:/plugin/org.eclipse.e4.core.contexts.debug/org.eclipse.e4.core.internal.contexts.debug.ui.RefreshViewAction");
        toolBar.getChildren().add(toolItem2);
    }

    @Inject
    @Optional
    public void setSelection(@EventTopic(value="e4/contexts/debug/selectContext") TreePath path) {
        if (path == null) {
            return;
        }
        TreeSelection selection = new TreeSelection(path);
        this.treeViewer.setSelection((ISelection)selection, true);
        this.treeViewer.getTree().setFocus();
    }

    @Inject
    @Optional
    public void setSelection(@EventTopic(value="e4/contexts/debug/refreshView") Object data) {
        this.fullRefresh();
    }
}

