/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts.debug.ui;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.internal.contexts.EclipseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllocationRecorder {
    private static AllocationRecorder defaultRecorder;
    private Map<EclipseContext, Throwable> traces = Collections.synchronizedMap(new WeakHashMap());

    public static AllocationRecorder getDefault() {
        if (defaultRecorder == null) {
            defaultRecorder = new AllocationRecorder();
        }
        return defaultRecorder;
    }

    public void allocated(EclipseContext context, Throwable exception) {
        this.traces.put(context, exception);
    }

    public void disposed(IEclipseContext context) {
        this.traces.remove(context);
    }

    public Throwable getTrace(IEclipseContext context) {
        return this.traces.get(context);
    }

    public Set<EclipseContext> getContexts() {
        return this.traces.keySet();
    }
}

