/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.e4.tm.graphics.util.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.RGB;

public class PRect
extends PNode {
    public static final String PROPERTY_STROKE_PAINT = "strokePaint";
    public static final int PROPERTY_CODE_STROKE_PAINT = 65536;
    private static final RGB DEFAULT_STROKE_PAINT = new RGB(0, 0, 0);
    public static final String PROPERTY_STROKE = "stroke";
    public static final int PROPERTY_CODE_STROKE = 131072;
    private static final LineAttributes DEFAULT_STROKE = new LineAttributes(1.0f);
    private LineAttributes stroke;
    private Color strokePaint = this.createColor(DEFAULT_STROKE_PAINT);
    private Rectangle resizeBounds = null;

    public Color getStrokePaint() {
        return this.strokePaint;
    }

    public void setStrokePaint(Color aPaint) {
        Color old = this.strokePaint;
        this.strokePaint = aPaint;
        this.invalidatePaint();
        this.firePropertyChange(65536, PROPERTY_STROKE_PAINT, old, this.strokePaint);
    }

    public LineAttributes getStroke() {
        return this.stroke;
    }

    public void setStroke(LineAttributes aStroke) {
        LineAttributes old = this.stroke;
        this.stroke = aStroke;
        this.invalidatePaint();
        this.firePropertyChange(131072, PROPERTY_STROKE, old, this.stroke);
    }

    public PRect() {
        this.stroke = DEFAULT_STROKE;
    }

    public void startResizeBounds() {
        this.resizeBounds = new Rectangle(this.getBoundsReference());
    }

    public void endResizeBounds() {
        this.resizeBounds = null;
    }

    protected void paint(PPaintContext paintContext) {
        GC g2 = paintContext.getGraphics();
        Color p = this.getPaint();
        PBounds r = this.getBoundsReference();
        if (p != null) {
            g2.setBackground(p);
            this.fillRect(g2, (int)(r.x + (double)(this.stroke.width / 2.0f)), (int)(r.y + (double)(this.stroke.width / 2.0f)), (int)(r.width - (double)this.stroke.width), (int)(r.height - (double)this.stroke.width));
        }
        if (this.stroke != null && this.strokePaint != null) {
            g2.setForeground(this.strokePaint);
            g2.setLineAttributes(this.stroke);
            this.drawRect(g2, (int)(r.x + (double)(this.stroke.width / 2.0f)), (int)(r.y + (double)(this.stroke.width / 2.0f)), (int)(r.width - (double)this.stroke.width), (int)(r.height - (double)this.stroke.width));
        }
    }

    protected void fillRect(GC g2, int x, int y, int width, int height) {
        g2.fillRectangle(x, y, width, height);
    }

    protected void drawRect(GC g2, int x, int y, int width, int height) {
        g2.drawRectangle(x, y, width, height);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        PUtil.writeStroke(this.stroke, out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.stroke = PUtil.readStroke(in);
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("stroke=" + (this.stroke == null ? "null" : this.stroke.toString()));
        result.append(",strokePaint=" + (this.strokePaint == null ? "null" : this.strokePaint.toString()));
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }
}

