/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import edu.umd.cs.piccolo.activities.Timer;
import org.eclipse.swt.widgets.Display;

public class TimerQueue
implements Runnable {
    static TimerQueue instance;
    Display display = null;
    Timer firstTimer;
    boolean running;

    public TimerQueue(Display display) {
        this.display = display;
        this.start();
    }

    public static TimerQueue sharedInstance(Display display) {
        if (instance == null) {
            instance = new TimerQueue(display);
        }
        return instance;
    }

    synchronized void start() {
        if (this.running) {
            throw new RuntimeException("Can't start a TimerQueue that is already running");
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Thread timerThread = new Thread((Runnable)TimerQueue.this, "TimerQueue");
                timerThread.setDaemon(true);
                timerThread.setPriority(5);
                timerThread.start();
            }
        });
        this.running = true;
    }

    synchronized void stop() {
        this.running = false;
        this.notify();
    }

    synchronized void addTimer(Timer timer, long expirationTime) {
        if (timer.running) {
            return;
        }
        Timer previousTimer = null;
        Timer nextTimer = this.firstTimer;
        while (nextTimer != null) {
            if (nextTimer.expirationTime > expirationTime) break;
            previousTimer = nextTimer;
            nextTimer = nextTimer.nextTimer;
        }
        if (previousTimer == null) {
            this.firstTimer = timer;
        } else {
            previousTimer.nextTimer = timer;
        }
        timer.expirationTime = expirationTime;
        timer.nextTimer = nextTimer;
        timer.running = true;
        this.notify();
    }

    synchronized void removeTimer(Timer timer) {
        if (!timer.running) {
            return;
        }
        Timer previousTimer = null;
        Timer nextTimer = this.firstTimer;
        boolean found = false;
        while (nextTimer != null) {
            if (nextTimer == timer) {
                found = true;
                break;
            }
            previousTimer = nextTimer;
            nextTimer = nextTimer.nextTimer;
        }
        if (!found) {
            return;
        }
        if (previousTimer == null) {
            this.firstTimer = timer.nextTimer;
        } else {
            previousTimer.nextTimer = timer.nextTimer;
        }
        timer.expirationTime = 0L;
        timer.nextTimer = null;
        timer.running = false;
    }

    synchronized boolean containsTimer(Timer timer) {
        return timer.running;
    }

    synchronized long postExpiredTimers() {
        long timeToWait;
        do {
            Timer timer;
            if ((timer = this.firstTimer) == null) {
                return 0L;
            }
            long currentTime = System.currentTimeMillis();
            timeToWait = timer.expirationTime - currentTime;
            if (timeToWait > 0L) continue;
            try {
                timer.postOverride();
            }
            catch (SecurityException securityException) {}
            this.removeTimer(timer);
            if (timer.isRepeats()) {
                this.addTimer(timer, currentTime + (long)timer.getDelay());
            }
            try {
                this.wait(1L);
            }
            catch (InterruptedException interruptedException) {}
        } while (timeToWait <= 0L);
        return timeToWait;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void run() {
        try {
            while (true) {
                if (!this.running) {
                    return;
                }
                timeToWait = this.postExpiredTimers();
                try {
                    this.wait(timeToWait);
                }
                catch (InterruptedException v0) {}
            }
        }
        catch (ThreadDeath td) {
            this.running = false;
            timer = this.firstTimer;
            ** while (timer != null)
        }
lbl-1000:
        // 1 sources

        {
            timer.cancelEventOverride();
            timer = timer.nextTimer;
            continue;
        }
lbl18:
        // 1 sources

        this.display.asyncExec((Runnable)new SWTTimerQueueRestart(this.display));
        throw td;
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("TimerQueue (");
        Timer nextTimer = this.firstTimer;
        while (nextTimer != null) {
            buf.append(nextTimer.toString());
            nextTimer = nextTimer.nextTimer;
            if (nextTimer == null) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    protected static class SWTTimerQueueRestart
    implements Runnable {
        boolean attemptedStart;
        Display display = null;

        public SWTTimerQueueRestart(Display display) {
            this.display = display;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            if (!this.attemptedStart) {
                TimerQueue q;
                TimerQueue timerQueue = q = TimerQueue.sharedInstance(this.display);
                synchronized (timerQueue) {
                    if (!q.running) {
                        q.start();
                    }
                }
                this.attemptedStart = true;
            }
        }
    }
}

