/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PPickPath;
import org.eclipse.e4.tm.graphics.util.Point;
import org.eclipse.swt.widgets.Event;

public class PInputManager
extends PBasicInputEventHandler
implements PRoot.InputSource {
    private Point lastCanvasPosition = new Point();
    private Point currentCanvasPosition = new Point();
    private Event nextInput;
    private int nextType;
    private PCamera nextInputSource;
    private PPickPath mouseFocus;
    private PPickPath previousMouseFocus;
    private PPickPath mouseOver;
    private PPickPath previousMouseOver;
    private PInputEventListener keyboardFocus;
    private int pressedCount;

    public PInputEventListener getKeyboardFocus() {
        return this.keyboardFocus;
    }

    public void setKeyboardFocus(PInputEventListener eventHandler) {
        PInputEvent focusEvent = new PInputEvent(this, null);
        if (this.keyboardFocus != null) {
            this.dispatchEventToListener(focusEvent, 16, this.keyboardFocus);
        }
        this.keyboardFocus = eventHandler;
        if (this.keyboardFocus != null) {
            this.dispatchEventToListener(focusEvent, 15, this.keyboardFocus);
        }
    }

    public PPickPath getMouseFocus() {
        return this.mouseFocus;
    }

    public void setMouseFocus(PPickPath path) {
        this.previousMouseFocus = this.mouseFocus;
        this.mouseFocus = path;
    }

    public PPickPath getMouseOver() {
        return this.mouseOver;
    }

    public void setMouseOver(PPickPath path) {
        this.mouseOver = path;
    }

    public Point getLastCanvasPosition() {
        return this.lastCanvasPosition;
    }

    public Point getCurrentCanvasPosition() {
        return this.currentCanvasPosition;
    }

    public void keyPressed(PInputEvent event) {
        this.dispatchEventToListener(event, 1, this.keyboardFocus);
    }

    public void keyReleased(PInputEvent event) {
        this.dispatchEventToListener(event, 2, this.keyboardFocus);
    }

    public void mouseWheelRotated(PInputEvent event) {
        this.setMouseFocus(this.getMouseOver());
        this.dispatchEventToListener(event, 37, this.mouseOver);
    }

    public void mouseEntered(PInputEvent event) {
        this.dispatchEventToListener(event, 6, this.mouseOver);
    }

    public void mouseExited(PInputEvent event) {
        this.dispatchEventToListener(event, 7, this.previousMouseOver);
    }

    public void mouseMoved(PInputEvent event) {
        this.checkForMouseEnteredAndExited(event);
        this.dispatchEventToListener(event, 5, this.mouseOver);
    }

    public void mouseDragged(PInputEvent event) {
        this.checkForMouseEnteredAndExited(event);
        this.dispatchEventToListener(event, 44, this.mouseFocus);
    }

    public void mousePressed(PInputEvent event) {
        if (this.pressedCount == 0) {
            this.setMouseFocus(this.getMouseOver());
        }
        ++this.pressedCount;
        this.dispatchEventToListener(event, 3, this.mouseFocus);
        if (this.pressedCount < 1 || this.pressedCount > 3) {
            System.err.println("invalid pressedCount on mouse pressed: " + this.pressedCount);
        }
    }

    public void mouseReleased(PInputEvent event) {
        --this.pressedCount;
        this.checkForMouseEnteredAndExited(event);
        this.dispatchEventToListener(event, 4, this.mouseFocus);
        if (this.pressedCount == 0) {
            this.setMouseFocus(null);
        }
        if (this.pressedCount < 0 || this.pressedCount > 2) {
            System.err.println("invalid pressedCount on mouse released: " + this.pressedCount);
        }
    }

    protected void checkForMouseEnteredAndExited(PInputEvent event) {
        PNode p;
        PNode c = this.mouseOver != null ? this.mouseOver.getPickedNode() : null;
        PNode pNode = p = this.previousMouseOver != null ? this.previousMouseOver.getPickedNode() : null;
        if (c != p) {
            this.dispatchEventToListener(event, 7, this.previousMouseOver);
            this.dispatchEventToListener(event, 6, this.mouseOver);
            this.previousMouseOver = this.mouseOver;
        }
    }

    public void processInput() {
        if (this.nextInput == null) {
            return;
        }
        PInputEvent e = new PInputEvent(this, this.nextInput);
        Point newCurrentCanvasPosition = null;
        Point newLastCanvasPosition = null;
        if (e.isMouseEvent()) {
            if (e.isMouseEnteredOrMouseExited()) {
                PPickPath aPickPath = this.nextInputSource.pick(this.nextInput.x, this.nextInput.y, 1.0);
                this.setMouseOver(aPickPath);
                this.previousMouseOver = aPickPath;
                newCurrentCanvasPosition = (Point)this.currentCanvasPosition.clone();
                newLastCanvasPosition = (Point)this.lastCanvasPosition.clone();
            } else {
                this.lastCanvasPosition.setLocation(this.currentCanvasPosition);
                this.currentCanvasPosition.setLocation(this.nextInput.x, this.nextInput.y);
                PPickPath aPickPath = this.nextInputSource.pick(this.currentCanvasPosition.getX(), this.currentCanvasPosition.getY(), 1.0);
                this.setMouseOver(aPickPath);
            }
        }
        this.nextInput = null;
        this.nextInputSource = null;
        this.processEvent(e, this.nextType);
        if (newCurrentCanvasPosition != null && newLastCanvasPosition != null) {
            this.currentCanvasPosition.setLocation(newCurrentCanvasPosition);
            this.lastCanvasPosition.setLocation(newLastCanvasPosition);
        }
    }

    public void processEventFromCamera(Event event, int type, PCamera camera) {
        this.nextInput = event;
        this.nextType = type;
        this.nextInputSource = camera;
        camera.getRoot().processInputs();
    }

    private void dispatchEventToListener(PInputEvent event, int type, PInputEventListener listener) {
        if (listener != null) {
            event.setHandled(false);
            listener.processEvent(event, type);
        }
    }
}

