/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.script.js.text.scanners;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.tools.emf.ui.script.js.ResourceProvider;
import org.eclipse.e4.tools.emf.ui.script.js.text.scanners.CombinedWordRule;
import org.eclipse.e4.tools.emf.ui.script.js.text.scanners.JavaScriptCommentScanner;
import org.eclipse.e4.tools.emf.ui.script.js.text.scanners.JavaScriptWhitespaceDetector;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public final class JavaScriptDocScanner
extends JavaScriptCommentScanner {
    private static String[] fgTokenProperties = new String[]{ResourceProvider.JAVADOC_KEYWORD, ResourceProvider.JAVADOC_TAG, ResourceProvider.JAVADOC_LINK, ResourceProvider.JAVADOC_DEFAULT};

    public JavaScriptDocScanner(IResourcePool manager, IPreferenceStore store) {
        super(manager, store, ResourceProvider.JAVADOC_DEFAULT, fgTokenProperties);
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    @Override
    protected List<IRule> createRules() {
        ArrayList<IRule> list = new ArrayList<IRule>();
        Token token = this.getToken(ResourceProvider.JAVADOC_TAG);
        list.add((IRule)new TagRule((IToken)token));
        WordRule wordRule = new WordRule((IWordDetector)new HTMLCommentDetector(), (IToken)token);
        wordRule.addWord("<!--", (IToken)token);
        wordRule.addWord("--!>", (IToken)token);
        list.add((IRule)wordRule);
        token = this.getToken(ResourceProvider.JAVADOC_LINK);
        list.add((IRule)new SingleLineRule("{@link", "}", (IToken)token));
        list.add((IRule)new SingleLineRule("{@value", "}", (IToken)token));
        list.add((IRule)new SingleLineRule("{@inheritDoc", "}", (IToken)token));
        token = this.getToken(ResourceProvider.JAVADOC_DEFAULT);
        list.add((IRule)new WhitespaceRule((IWhitespaceDetector)new JavaScriptWhitespaceDetector(), (IToken)token));
        list.addAll(super.createRules());
        return list;
    }

    @Override
    protected List<CombinedWordRule.WordMatcher> createMatchers() {
        List<CombinedWordRule.WordMatcher> list = super.createMatchers();
        Token token = this.getToken(ResourceProvider.JAVADOC_KEYWORD);
        CombinedWordRule.WordMatcher matcher = new CombinedWordRule.WordMatcher((IToken)token){
            private final /* synthetic */ IToken val$token;
            {
                this.val$token = iToken;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public IToken evaluate(ICharacterScanner scanner, CombinedWordRule.CharacterBuffer word) {
                block6: {
                    length = word.length();
                    if (length <= 1 || word.charAt(0) != '@') break block6;
                    i = 0;
                    try {
                        while (i <= length) {
                            scanner.unread();
                            ++i;
                        }
                        c = scanner.read();
                        --i;
                        if (c != 42 && !Character.isWhitespace((char)c)) ** GOTO lbl30
                        scanner.unread();
                        var7_6 = this.val$token;
                        ** while (i >= 0)
                    }
                    catch (Throwable var6_7) {
                        ** while (i >= 0)
                    }
lbl-1000:
                    // 1 sources

                    {
                        scanner.read();
                        --i;
                        continue;
                    }
lbl19:
                    // 1 sources

                    return var7_6;
lbl-1000:
                    // 1 sources

                    {
                        scanner.read();
                        --i;
                        continue;
                    }
lbl26:
                    // 1 sources

                    throw var6_7;
lbl-1000:
                    // 1 sources

                    {
                        scanner.read();
                        --i;
lbl30:
                        // 2 sources

                        ** while (i >= 0)
                    }
                }
                return Token.UNDEFINED;
            }
        };
        list.add(matcher);
        return list;
    }

    static class HTMLCommentDetector
    implements IWordDetector {
        HTMLCommentDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '<' || c == '-';
        }

        public boolean isWordPart(char c) {
            return c == '-' || c == '!' || c == '>';
        }
    }

    class TagRule
    extends SingleLineRule {
        public TagRule(IToken token) {
            super("<", ">", token, '\u0000');
        }

        public TagRule(IToken token, char escapeCharacter) {
            super("<", ">", token, escapeCharacter);
        }

        private IToken evaluateToken() {
            try {
                String token = String.valueOf(JavaScriptDocScanner.this.getDocument().get(JavaScriptDocScanner.this.getTokenOffset(), JavaScriptDocScanner.this.getTokenLength())) + ".";
                int offset = 0;
                char character = token.charAt(++offset);
                if (character == '/') {
                    character = token.charAt(++offset);
                }
                while (Character.isWhitespace(character)) {
                    character = token.charAt(++offset);
                }
                while (Character.isLetterOrDigit(character)) {
                    character = token.charAt(++offset);
                }
                while (Character.isWhitespace(character)) {
                    character = token.charAt(++offset);
                }
                if (offset >= 2 && token.charAt(offset) == this.fEndSequence[0]) {
                    return this.fToken;
                }
            }
            catch (BadLocationException badLocationException) {}
            return JavaScriptDocScanner.this.getToken(ResourceProvider.JAVADOC_DEFAULT);
        }

        public IToken evaluate(ICharacterScanner scanner) {
            IToken result = super.evaluate(scanner);
            if (result == this.fToken) {
                return this.evaluateToken();
            }
            return result;
        }
    }
}

