/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.StringMatcher;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractIconDialog
extends TitleAreaDialog {
    private TableViewer viewer;
    private IProject project;
    private MApplicationElement element;
    private EStructuralFeature feature;
    private EditingDomain editingDomain;
    private Map<IFile, Image> icons = Collections.synchronizedMap(new HashMap());
    protected Messages Messages;

    public AbstractIconDialog(Shell parentShell, IProject project, EditingDomain editingDomain, MApplicationElement element, EStructuralFeature feature, Messages Messages2) {
        super(parentShell);
        this.editingDomain = editingDomain;
        this.element = element;
        this.feature = feature;
        this.project = project;
        this.Messages = Messages2;
    }

    protected abstract String getShellTitle();

    protected abstract String getDialogTitle();

    protected abstract String getDialogMessage();

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        this.getShell().setText(this.getShellTitle());
        this.setTitle(this.getDialogTitle());
        this.setMessage(this.getDialogMessage());
        Composite container = new Composite(comp, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(2, false));
        Label l = new Label(container, 0);
        l.setText(this.Messages.AbstractIconDialog_IconName);
        final Text t = new Text(container, 2688);
        t.setLayoutData((Object)new GridData(768));
        new Label(container, 0);
        this.viewer = new TableViewer(container);
        GridData gd = new GridData(1808);
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                String bundle;
                Image img;
                StyledString styledString;
                IFile file;
                block16: {
                    file = (IFile)cell.getElement();
                    styledString = new StyledString(file.getProjectRelativePath().toString(), null);
                    img = (Image)AbstractIconDialog.this.icons.get(file);
                    if (img == null) {
                        InputStream in = null;
                        try {
                            try {
                                in = file.getContents();
                                img = new Image((Device)cell.getControl().getDisplay(), in);
                                AbstractIconDialog.this.icons.put(file, img);
                            }
                            catch (CoreException e) {
                                e.printStackTrace();
                                if (in != null) {
                                    try {
                                        in.close();
                                    }
                                    catch (IOException e2) {
                                        e2.printStackTrace();
                                    }
                                }
                                break block16;
                            }
                        }
                        catch (Throwable throwable) {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            throw throwable;
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                if ((bundle = AbstractIconDialog.this.getBundle(file)) != null) {
                    styledString.append(" - " + bundle, StyledString.DECORATIONS_STYLER);
                }
                cell.setImage(img);
                cell.setText(styledString.getString());
                cell.setStyleRanges(styledString.getStyleRanges());
            }
        });
        final WritableList list = new WritableList();
        this.viewer.setInput((Object)list);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractIconDialog.this.okPressed();
            }
        });
        t.addModifyListener(new ModifyListener(){
            private IconMatchCallback callback;
            private Timer timer = new Timer(true);
            private TimerTask task;

            public void modifyText(ModifyEvent e) {
                if (this.callback != null) {
                    this.callback.cancel = true;
                }
                if (this.task != null) {
                    this.task.cancel();
                }
                list.clear();
                AbstractIconDialog.this.clearImages();
                this.callback = new IconMatchCallback((IObservableList)list);
                this.task = new SearchThread(this.callback, t.getText(), AbstractIconDialog.this.project);
                this.timer.schedule(this.task, 500L);
            }
        });
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractIconDialog.this.clearImages();
            }
        });
        return comp;
    }

    private void clearImages() {
        for (Image img : this.icons.values()) {
            img.dispose();
        }
        this.icons.clear();
    }

    protected void okPressed() {
        IFile file;
        String bundle;
        String uri;
        Command cmd;
        IStructuredSelection s = (IStructuredSelection)this.viewer.getSelection();
        if (!s.isEmpty() && (cmd = SetCommand.create((EditingDomain)this.editingDomain, (Object)this.element, (Object)this.feature, (Object)(uri = "platform:/plugin/" + (bundle = this.getBundle(file = (IFile)s.getFirstElement())) + "/" + file.getProjectRelativePath().toString()))).canExecute()) {
            this.editingDomain.getCommandStack().execute(cmd);
            super.okPressed();
        }
    }

    /*
     * Exception decompiling
     */
    private String getBundle(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class IconMatchCallback {
        private volatile boolean cancel;
        private IObservableList list;

        private IconMatchCallback(IObservableList list) {
            this.list = list;
        }

        public void match(final IFile file) {
            if (!this.cancel) {
                this.list.getRealm().exec(new Runnable(){

                    public void run() {
                        IconMatchCallback.this.list.add((Object)file);
                    }
                });
            }
        }
    }

    private static class SearchThread
    extends TimerTask {
        private final IconMatchCallback callback;
        private final IProject project;
        private final StringMatcher matcherGif;
        private final StringMatcher matcherJpg;
        private final StringMatcher matcherPng;

        public SearchThread(IconMatchCallback callback, String pattern, IProject project) {
            this.matcherGif = new StringMatcher("*" + pattern + "*.gif", true, false);
            this.matcherJpg = new StringMatcher("*" + pattern + "*.jpg", true, false);
            this.matcherPng = new StringMatcher("*" + pattern + "*.png", true, false);
            this.callback = callback;
            this.project = project;
        }

        public void run() {
            try {
                this.project.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        if (SearchThread.this.callback.cancel) {
                            return false;
                        }
                        if (resource.getType() == 2 || resource.getType() == 4) {
                            return true;
                        }
                        if (resource.getType() == 1 && !resource.isLinked()) {
                            String path = resource.getProjectRelativePath().toString();
                            if (SearchThread.this.matcherGif.match(path) || SearchThread.this.matcherPng.match(path) || SearchThread.this.matcherJpg.match(path)) {
                                SearchThread.this.callback.match((IFile)resource);
                            }
                        }
                        return false;
                    }
                });
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

