/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementReferenceRenderer
extends SWTPartRenderer {
    private static Map<MUIElement, List<MPlaceholder>> renderedMap = new HashMap<MUIElement, List<MPlaceholder>>();
    @Inject
    IPresentationEngine renderingEngine;

    public static List<MPlaceholder> getRenderedPlaceholders(MUIElement element) {
        return renderedMap.get(element);
    }

    public Object createWidget(MUIElement element, Object parent) {
        MPlaceholder ph = (MPlaceholder)element;
        MUIElement ref = ph.getRef();
        ref.setCurSharedRef(ph);
        List<MPlaceholder> renderedRefs = renderedMap.get(ref);
        if (renderedRefs == null) {
            renderedRefs = new ArrayList<MPlaceholder>();
            renderedMap.put(ref, renderedRefs);
        }
        if (!renderedRefs.contains(ph)) {
            renderedRefs.add(ph);
        }
        Composite newComp = new Composite((Composite)parent, 0);
        newComp.setLayout((Layout)new FillLayout());
        Control refWidget = (Control)ref.getWidget();
        if (refWidget == null) {
            ref.setToBeRendered(true);
            refWidget = (Control)this.renderingEngine.createGui(ref, (Object)newComp, this.getContextForParent(ref));
        } else if (refWidget.getParent() != newComp) {
            refWidget.setParent(newComp);
        }
        if (ref instanceof MContext) {
            IEclipseContext context = ((MContext)ref).getContext();
            IEclipseContext newParentContext = this.getContext((MUIElement)ph);
            if (context.getParent() != newParentContext) {
                context.setParent(newParentContext);
            }
        }
        return newComp;
    }

    @Override
    public void disposeWidget(MUIElement element) {
        MPlaceholder ph = (MPlaceholder)element;
        MUIElement refElement = ph.getRef();
        Control refCtrl = (Control)refElement.getWidget();
        List<MPlaceholder> refs = renderedMap.get(refElement);
        refs.remove(ph);
        IEclipseContext curContext = this.modelService.getContainingContext((MUIElement)ph);
        if (refs.size() == 0) {
            if (refElement instanceof MPart) {
                MPart thePart = (MPart)refElement;
                String imageURI = thePart.getIconURI();
                thePart.setIconURI(null);
                thePart.setIconURI(imageURI);
            }
            this.renderingEngine.removeGui(refElement);
        } else if (refCtrl != null && !refCtrl.isDisposed()) {
            MPlaceholder currentRef = refElement.getCurSharedRef();
            if (currentRef == ph) {
                for (MPlaceholder aPH : refs) {
                    Composite phComp = (Composite)aPH.getWidget();
                    if (phComp == null || phComp.isDisposed()) continue;
                    IEclipseContext newParentContext = this.modelService.getContainingContext((MUIElement)aPH);
                    List allContexts = this.modelService.findElements(refElement, null, MContext.class, null);
                    for (MContext ctxtElement : allContexts) {
                        IEclipseContext theContext = ctxtElement.getContext();
                        if (theContext == null || theContext.getParent() != curContext) continue;
                        if (curContext.getActiveChild() == theContext) {
                            theContext.deactivate();
                        }
                        theContext.setParent(newParentContext);
                    }
                    refElement.setCurSharedRef(aPH);
                    refCtrl.setParent(phComp);
                    break;
                }
            } else if (currentRef != null) {
                Composite phComp = (Composite)currentRef.getWidget();
                if (phComp == null || phComp.isDisposed()) {
                    super.disposeWidget(element);
                    return;
                }
                IEclipseContext newParentContext = this.modelService.getContainingContext((MUIElement)currentRef);
                List allContexts = this.modelService.findElements(refElement, null, MContext.class, null);
                for (MContext ctxtElement : allContexts) {
                    IEclipseContext theContext = ctxtElement.getContext();
                    if (theContext == null || theContext.getParent() != curContext) continue;
                    if (curContext.getActiveChild() == theContext) {
                        theContext.deactivate();
                    }
                    theContext.setParent(newParentContext);
                }
            }
        }
        super.disposeWidget(element);
    }
}

