/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.emf;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.e4.xwt.emf.EMFDataProvider;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EMFHelper {
    public static String getQualifiedName(ENamedElement namedElement) {
        String parentQN;
        EObject object = namedElement.eContainer();
        if (object instanceof ENamedElement && (parentQN = EMFHelper.getQualifiedName((ENamedElement)namedElement.eContainer())) != null && !parentQN.equals("")) {
            return String.valueOf(parentQN) + "." + namedElement.getName();
        }
        return namedElement.getName();
    }

    public static Object toType(Object data) {
        if (data instanceof EClassifier) {
            return (EClassifier)data;
        }
        if (data instanceof IObservableValue) {
            IObservableValue observableValue = (IObservableValue)data;
            Object element = observableValue.getValueType();
            if (element instanceof EStructuralFeature) {
                return ((EStructuralFeature)element).getEType();
            }
            return element;
        }
        if (data instanceof EObject) {
            EObject object = (EObject)data;
            return object.eClass();
        }
        if (data instanceof EMFDataProvider) {
            EMFDataProvider dataProvider = (EMFDataProvider)((Object)data);
            return dataProvider.getDataType(null);
        }
        return null;
    }

    public static EReference findReference(EClass eClass, String name) {
        for (EStructuralFeature feature : eClass.getEStructuralFeatures()) {
            if (!(feature instanceof EReference) || !name.equals(feature.getName())) continue;
            return (EReference)feature;
        }
        for (EClass superType : eClass.getESuperTypes()) {
            EReference reference = EMFHelper.findReference(superType, name);
            if (reference == null) continue;
            return reference;
        }
        return null;
    }
}

