/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.internal.resources.semantic.ui.actions.ActionBase;
import org.eclipse.core.internal.resources.semantic.ui.actions.Messages;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;

public class DeleteAction
extends ActionBase {
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        action.setEnabled(this.checkSelectionNonLocalOnly());
    }

    public void run(IAction action) {
        IRunnableWithProgress outerRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor outerMonitor) throws InvocationTargetException, InterruptedException {
                for (final ISemanticResource resource : DeleteAction.this.getSelection()) {
                    outerMonitor.subTask(NLS.bind((String)Messages.DeleteAction_Deleting_XMSG, (Object)resource.getAdaptedResource().getName()));
                    if (outerMonitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    IStatus validationResult = resource.validateRemoteDelete((Object)DeleteAction.this.getShell());
                    if (validationResult.isOK()) {
                        IWorkspaceRunnable myRunnable = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor monitor) throws CoreException {
                                resource.deleteRemotely(0, monitor);
                            }
                        };
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        try {
                            workspace.run(myRunnable, workspace.getRuleFactory().refreshRule(resource.getAdaptedResource()), 0, null);
                            continue;
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    throw new InvocationTargetException(new CoreException(validationResult));
                }
            }
        };
        this.run(outerRunnable);
    }
}

