/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.xwt.tools.ui.designer.commands.AddNewChildCommand;
import org.eclipse.e4.xwt.tools.ui.designer.commands.DeleteCommand;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.DisplayUtil;
import org.eclipse.e4.xwt.tools.ui.designer.editor.XWTDesigner;
import org.eclipse.e4.xwt.tools.ui.designer.parts.WidgetEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.wizards.ExternalizeStringsCommon;
import org.eclipse.e4.xwt.tools.ui.designer.wizards.contents.ProperyContents;
import org.eclipse.e4.xwt.tools.ui.designer.wizards.contents.SourceContents;
import org.eclipse.e4.xwt.tools.ui.designer.wizards.models.TextValueEntry;
import org.eclipse.e4.xwt.tools.ui.designer.wizards.models.TextValueModel;
import org.eclipse.e4.xwt.tools.ui.designer.wizards.pages.ExternalizeStringsWizardPage;
import org.eclipse.e4.xwt.tools.ui.designer.wizards.returnWizardPage;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ExternalizeStringsWizard
extends Wizard
implements INewWizard {
    private ExternalizeStringsWizardPage externalizeStringsWizardPage;
    private ISelection selection;
    private TextValueModel textValueEntrys;
    private XWTDesigner designer;
    private String classPerfixName;
    private String classFilePath;
    private String className;
    private String propertyFilePath;
    private String propertyName;
    private TextValueModel checkedItems;
    private boolean openFlag;
    private CompoundCommand commandList;

    public ExternalizeStringsWizard(TextValueModel textValueEntrys, XWTDesigner designer) {
        this.textValueEntrys = textValueEntrys;
        this.designer = designer;
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.setWindowTitle("Externalize Strings");
        this.externalizeStringsWizardPage = new ExternalizeStringsWizardPage(this.selection, this.textValueEntrys);
        this.addPage((IWizardPage)this.externalizeStringsWizardPage);
        this.getDefaultAccessorContents();
    }

    private void getDefaultAccessorContents() {
        IFile inputFile = this.designer.getFile();
        IContainer container = inputFile.getParent();
        IJavaElement javaElement = JavaCore.create((IResource)container);
        IPackageFragmentRoot defaultRoot = null;
        if (javaElement != null && javaElement.exists()) {
            IJavaProject javaProject = JavaCore.create((IProject)inputFile.getProject());
            try {
                IPackageFragmentRoot[] fragmentRoot = javaProject.getAllPackageFragmentRoots();
                int i = 0;
                while (i < fragmentRoot.length) {
                    if (fragmentRoot[i].getKind() == 1) {
                        defaultRoot = fragmentRoot[i];
                        IJavaElement[] iJavaElementArray = defaultRoot.getChildren();
                        int n = iJavaElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IJavaElement element = iJavaElementArray[n2];
                            if (element.getElementType() == 4) {
                                javaElement = element;
                            }
                            ++n2;
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        if (javaElement == null || !(javaElement instanceof IPackageFragment)) {
            String projectName = inputFile.getProject().getName();
            this.externalizeStringsWizardPage.setErrorMessage("The project " + projectName + " has not source folder.");
            return;
        }
        this.externalizeStringsWizardPage.setDefaultRoot(defaultRoot);
        this.externalizeStringsWizardPage.setDefaultFolder(defaultRoot.getResource().getFullPath().toString());
        this.externalizeStringsWizardPage.setDefaultPackage(javaElement.getElementName());
    }

    public boolean performFinish() {
        this.classFilePath = this.externalizeStringsWizardPage.getInfo().getClassFilePath();
        this.className = String.valueOf(this.externalizeStringsWizardPage.getInfo().getClassName()) + ".java";
        this.propertyFilePath = this.externalizeStringsWizardPage.getInfo().getPropertyFilePath();
        this.propertyName = String.valueOf(this.externalizeStringsWizardPage.getInfo().getPropertyName()) + ".properties";
        try {
            this.doFinish((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (returnWizardPage returnWizardPage2) {
            return false;
        }
        return true;
    }

    private void showOpenFileDialog() throws returnWizardPage {
        String dialogMessage = "Do you want to open " + this.externalizeStringsWizardPage.getInfo().getClassName() + ".java and " + this.externalizeStringsWizardPage.getInfo().getPropertyName() + ".properties after finish?";
        String[] dialogButtonLabels = new String[]{"Open", "Cancel"};
        MessageDialog messageDialog = new MessageDialog(this.getShell(), "Open created files", null, dialogMessage, 3, dialogButtonLabels, 1);
        messageDialog.open();
        if (messageDialog.getReturnCode() == 0) {
            this.openFlag = true;
        } else {
            if (messageDialog.getReturnCode() == -1) {
                throw new returnWizardPage();
            }
            this.openFlag = false;
        }
    }

    private void doFinish(IProgressMonitor monitor) throws CoreException, IOException, returnWizardPage {
        String propertyPerfixName = this.propertyName.substring(0, this.propertyName.length() - 11);
        this.classPerfixName = this.className.substring(0, this.className.length() - 5);
        this.checkedItems = this.externalizeStringsWizardPage.getCheckedItems();
        this.showOpenFileDialog();
        this.createFile(this.propertyFilePath, this.propertyName, propertyPerfixName, false, monitor);
        this.createFile(this.classFilePath, this.className, propertyPerfixName, true, monitor);
        final Command changTextCmd = this.changText();
        DisplayUtil.asyncExec((Runnable)new Runnable(){

            public void run() {
                RootEditPart rootEditPart = ExternalizeStringsWizard.this.designer.getGraphicalViewer().getRootEditPart();
                rootEditPart.getViewer().getEditDomain().getCommandStack().execute(changTextCmd);
            }
        });
        monitor.worked(1);
    }

    private void createFile(String containerName, String fileName, String propertyfileName, boolean isClassFile, IProgressMonitor monitor) throws CoreException, returnWizardPage {
        monitor.beginTask("Creating " + fileName, 2);
        final IFile file = ExternalizeStringsCommon.getIFile(containerName, fileName);
        try {
            InputStream stream;
            if (!isClassFile) {
                stream = this.openPropertyContentStream(this.checkedItems);
            } else if (file.exists()) {
                StringBuffer historyContent = ExternalizeStringsCommon.getHistoryContents(file);
                stream = this.openSourceContentStream(this.checkedItems, containerName, fileName, propertyfileName, historyContent);
            } else {
                stream = this.openSourceContentStream(this.checkedItems, containerName, fileName, propertyfileName, null);
            }
            if (file.exists()) {
                if (isClassFile) {
                    file.setContents(stream, true, true, monitor);
                } else {
                    file.appendContents(stream, true, true, monitor);
                }
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
            IProject project = file.getProject();
            project.refreshLocal(2, monitor);
            project.build(10, monitor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.openFlag) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private InputStream openSourceContentStream(TextValueModel checkedItems, String containerName, String fileName, String porpertyfileName, StringBuffer historyContent) {
        IPackageFragmentRoot classRoot = this.externalizeStringsWizardPage.getInfo().getClassRoot();
        SourceContents sourceContents = new SourceContents(checkedItems, containerName, this.propertyFilePath, fileName, porpertyfileName, historyContent, classRoot);
        String contents = sourceContents.getSourceContents();
        return new ByteArrayInputStream(contents.getBytes());
    }

    private InputStream openPropertyContentStream(TextValueModel checkedItems) {
        ProperyContents properyContents = new ProperyContents(checkedItems);
        String contents = properyContents.getPropertyContents();
        return new ByteArrayInputStream(contents.getBytes());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    private Command changText() {
        this.commandList = new CompoundCommand();
        RootEditPart rootEditPart = this.designer.getGraphicalViewer().getRootEditPart();
        EditPart contents = rootEditPart.getContents();
        Object[] textValueEntry = this.externalizeStringsWizardPage.getCheckedItems().elements();
        int i = 0;
        while (i < textValueEntry.length) {
            if (textValueEntry[i] instanceof TextValueEntry) {
                String value = ((TextValueEntry)textValueEntry[i]).getValue();
                String key = ((TextValueEntry)textValueEntry[i]).getKey();
                this.externalizeText(contents, value, key, "text");
                this.externalizeText(contents, value, key, "toolTipText");
            }
            ++i;
        }
        return this.commandList.unwrap();
    }

    private void externalizeText(EditPart editPart, String value, String key, String type) {
        if (editPart instanceof WidgetEditPart) {
            XamlNode node = ((WidgetEditPart)editPart).getCastModel();
            XamlAttribute attribute = node.getAttribute(type, "http://www.eclipse.org/xwt/presentation");
            if (attribute != null && value.equals(attribute.getValue())) {
                this.commandList.add((Command)new DeleteCommand((XamlNode)attribute));
                attribute = null;
                attribute = XamlFactory.eINSTANCE.createAttribute(type, "http://www.eclipse.org/xwt/presentation");
                attribute.setUseFlatValue(true);
                XamlElement child = attribute.getChild("Static", "http://www.eclipse.org/xwt");
                if (child == null) {
                    child = XamlFactory.eINSTANCE.createElement("Static", "http://www.eclipse.org/xwt");
                }
                String classPakage = this.externalizeStringsWizardPage.getInfo().getSourcePackage();
                XamlElement childElement = child.getChild(String.valueOf(this.classPerfixName) + "." + key, "clr-namespace:" + classPakage);
                if (childElement != null) {
                    child.getChildNodes().remove((Object)childElement);
                }
                childElement = XamlFactory.eINSTANCE.createElement(String.valueOf(this.classPerfixName) + "." + key, "clr-namespace:" + classPakage);
                this.commandList.add((Command)new AddNewChildCommand((XamlNode)child, (XamlNode)childElement));
                this.commandList.add((Command)new AddNewChildCommand((XamlNode)attribute, (XamlNode)child));
                if (!node.getAttributes().contains((Object)attribute)) {
                    this.commandList.add((Command)new AddNewChildCommand(node, (XamlNode)attribute));
                }
            }
            if (editPart.getChildren().size() > 0) {
                this.externalizeChildren(editPart, value, key, type);
            }
        } else if (editPart.getChildren().size() > 0) {
            this.externalizeChildren(editPart, value, key, type);
        }
    }

    private void externalizeChildren(EditPart editPart, String value, String key, String type) {
        List child = editPart.getChildren();
        int i = 0;
        while (i < child.size()) {
            if (child.get(i) instanceof EditPart) {
                this.externalizeText((EditPart)child.get(i), value, key, type);
            }
            ++i;
        }
    }
}

