/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.parts.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.e4.xwt.tools.ui.designer.parts.MenuItemEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.utils.StyleHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class MenuItemFigure
extends RectangleFigure {
    private MenuItemEditPart host;
    private Label nameLabel = null;

    public MenuItemFigure(MenuItemEditPart host) {
        this.host = host;
        this.setFill(false);
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.setForegroundColor(ColorConstants.menuBackground);
        this.nameLabel = new Label();
        this.nameLabel.setTextPlacement(8);
        this.nameLabel.setTextAlignment(2);
        this.nameLabel.setLabelAlignment(1);
        this.add((IFigure)this.nameLabel);
    }

    public MenuItemEditPart getHost() {
        return this.host;
    }

    public Dimension getPreferredSize(int hint, int hint2) {
        if (this.host != null) {
            return this.host.getVisualInfo().getBounds().getSize();
        }
        return super.getPreferredSize(hint, hint2);
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
        Rectangle copy = rect.getCopy().shrink(20, 0).resize(-4, 0);
        this.nameLabel.setBounds(copy);
    }

    private boolean displayText() {
        Widget widget = this.host.getWidget();
        if (widget != null && !widget.isDisposed() && widget instanceof MenuItem) {
            return !StyleHelper.isOnMenubar((MenuItem)widget);
        }
        return false;
    }

    private boolean isSeparator() {
        Widget widget = this.host.getWidget();
        return StyleHelper.checkStyle(widget, 2);
    }

    public void paintFigure(Graphics graphics) {
        Rectangle r = this.getBounds().getCopy();
        Widget widget = this.host.getWidget();
        if (this.isSeparator()) {
            graphics.setForegroundColor(ColorConstants.gray);
            graphics.drawLine(r.x, r.y, r.x + r.width, r.y);
        } else {
            if (this.displayText()) {
                if (widget != null && !widget.isDisposed() && widget instanceof MenuItem) {
                    this.nameLabel.setText(((MenuItem)widget).getText());
                }
                this.nameLabel.setForegroundColor(ColorConstants.black);
            }
            super.paintFigure(graphics);
        }
        if (this.displayText() && StyleHelper.checkStyle(widget, 64)) {
            Color fc = graphics.getForegroundColor();
            Color bc = graphics.getBackgroundColor();
            graphics.setBackgroundColor(ColorConstants.black);
            graphics.setForegroundColor(ColorConstants.black);
            Rectangle b = this.nameLabel.getBounds();
            int x = b.x + b.width + 4;
            int y = b.y;
            this.drawRightArrow(graphics, x, y);
            graphics.setForegroundColor(fc);
            graphics.setBackgroundColor(bc);
        }
    }

    protected void drawRightArrow(Graphics gc, int x, int y) {
        gc.drawLine((x += 2) + 2, y += 4, x + 5, y + 3);
        gc.drawLine(x + 5, y + 4, x + 5, y + 4);
        gc.drawLine(x + 4, y + 3, x + 4, y + 5);
        gc.drawLine(x + 3, y + 1, x + 3, y + 6);
        gc.drawLine(x + 2, y + 1, x + 2, y + 7);
    }
}

