/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.application;

import junit.framework.TestCase;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IDisposable;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class EModelServiceInsertTest
extends TestCase {
    private IEclipseContext applicationContext;
    MApplication app = null;

    protected void setUp() throws Exception {
        this.applicationContext = E4Application.createDefaultContext();
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.applicationContext instanceof IDisposable) {
            this.applicationContext.dispose();
        }
    }

    private MApplication createSimpleApplication() {
        MApplication app = ApplicationFactoryImpl.eINSTANCE.createApplication();
        app.setContext(this.applicationContext);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setElementId("main.Window");
        app.getChildren().add(window);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        stack.setElementId("theStack");
        window.getChildren().add(stack);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        part1.setElementId("part1");
        stack.getChildren().add(part1);
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        part2.setElementId("part2");
        stack.getChildren().add(part2);
        return app;
    }

    private MApplication createApplication() {
        MApplication app = ApplicationFactoryImpl.eINSTANCE.createApplication();
        app.setContext(this.applicationContext);
        MWindow window = BasicFactoryImpl.eINSTANCE.createWindow();
        window.setElementId("main.Window");
        app.getChildren().add(window);
        MPartSashContainer psc = BasicFactoryImpl.eINSTANCE.createPartSashContainer();
        psc.setHorizontal(true);
        psc.setElementId("topSash");
        window.getChildren().add(psc);
        MPartStack stack = BasicFactoryImpl.eINSTANCE.createPartStack();
        stack.setElementId("theStack");
        psc.getChildren().add(stack);
        MPart part1 = BasicFactoryImpl.eINSTANCE.createPart();
        part1.setElementId("part1");
        stack.getChildren().add(part1);
        MPart part2 = BasicFactoryImpl.eINSTANCE.createPart();
        part2.setElementId("part2");
        stack.getChildren().add(part2);
        return app;
    }

    private void testInsert(MApplication app, String relToId, int where, int ratio) {
        EModelService modelService = (EModelService)app.getContext().get(EModelService.class.getName());
        EModelServiceInsertTest.assertNotNull((Object)modelService);
        MUIElement relTo = modelService.find(relToId, (MUIElement)app);
        MPart newPart = BasicFactoryImpl.eINSTANCE.createPart();
        newPart.setElementId("newPart");
        modelService.insert((MPartSashContainerElement)newPart, (MPartSashContainerElement)relTo, where, ratio);
        MElementContainer newPartParent = newPart.getParent();
        EModelServiceInsertTest.assertTrue((String)"parent must be a sash", (boolean)(newPartParent instanceof MPartSashContainer));
        MPartSashContainer psc = (MPartSashContainer)newPartParent;
        boolean horizontal = where == 2 || where == 3;
        EModelServiceInsertTest.assertTrue((String)"invalid sash orientation", (psc.isHorizontal() == horizontal ? 1 : 0) != 0);
        if (where == 2 || where == 0) {
            EModelServiceInsertTest.assertTrue((String)"new part should be first", (psc.getChildren().indexOf(newPart) == 0 ? 1 : 0) != 0);
            EModelServiceInsertTest.assertTrue((String)"old part should be second", (psc.getChildren().indexOf(relTo) == 1 ? 1 : 0) != 0);
        } else {
            EModelServiceInsertTest.assertTrue((String)"old part should be first", (psc.getChildren().indexOf(relTo) == 0 ? 1 : 0) != 0);
            EModelServiceInsertTest.assertTrue((String)"new part should be second", (psc.getChildren().indexOf(newPart) == 1 ? 1 : 0) != 0);
        }
    }

    public void testSimpleInsertAbove() {
        MApplication application = this.createSimpleApplication();
        this.testInsert(application, "theStack", 0, 25);
    }

    public void testSimpleInsertBelow() {
        MApplication application = this.createSimpleApplication();
        this.testInsert(application, "theStack", 1, 25);
    }

    public void testSimpleInsertLeftOf() {
        MApplication application = this.createSimpleApplication();
        this.testInsert(application, "theStack", 2, 25);
    }

    public void testSimpleInsertRightOf() {
        MApplication application = this.createSimpleApplication();
        this.testInsert(application, "theStack", 3, 25);
    }

    public void testInsertAbove() {
        MApplication application = this.createApplication();
        this.testInsert(application, "theStack", 0, 35);
    }

    public void testInsertBelow() {
        MApplication application = this.createApplication();
        this.testInsert(application, "theStack", 1, 35);
    }

    public void testInsertLeftOf() {
        MApplication application = this.createApplication();
        this.testInsert(application, "theStack", 2, 35);
    }

    public void testInsertRightOf() {
        MApplication application = this.createApplication();
        this.testInsert(application, "theStack", 3, 35);
    }
}

