/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.emf.ecore.javascript;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.emf.ecore.javascript.JavascriptSupport;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.javascript";
    private static Activator plugin;
    private Map<URI, URI> genmodelUriMap = null;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public void addGenmodelUris(Map<URI, URI> uriMap) {
        if (this.genmodelUriMap == null) {
            this.initGenmodelUriMap();
        }
        uriMap.putAll(this.genmodelUriMap);
    }

    private void initGenmodelUriMap() {
        this.genmodelUriMap = new HashMap<URI, URI>();
        IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.emf.ecore.generated_package");
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] iConfigurationElementArray = extensions[i].getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ces = iConfigurationElementArray[n2];
                String name = ces.getName();
                if ("package".equals(name)) {
                    URI uri = URI.createURI((String)ces.getAttribute("uri"));
                    String genModel = ces.getAttribute("genModel");
                    URI pluginUri = URI.createPlatformPluginURI((String)("/" + extensions[i].getNamespaceIdentifier() + "/" + genModel), (boolean)true);
                    URI parentFolderUri = JavascriptSupport.createParentFolderUri(uri);
                    URI pluginParentFolderUri = JavascriptSupport.createParentFolderUri(pluginUri);
                    this.addUriMapping(this.genmodelUriMap, parentFolderUri, pluginParentFolderUri);
                }
                ++n2;
            }
            ++i;
        }
    }

    private void addUriMapping(Map<URI, URI> uriMap, URI source, URI target) {
        URI existingTarget = uriMap.get(source);
        if (existingTarget == null) {
            uriMap.put(source, target);
        } else if (!target.equals((Object)existingTarget)) {
            this.getLog().log((IStatus)new Status(2, PLUGIN_ID, "Tried to map " + source + " to " + target + ", but it already maps to " + existingTarget));
        }
    }
}

