/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Assert;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.examples.providers.SampleWebDAVContentProvider;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.resources.semantic.test.TestsContentProviderUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.junit.Test;

public class TestsSampleWebDAVContentProvider
extends TestsContentProviderUtil {
    protected static final String WEBDAV_TEST_URL = "http://localhost:2080/testWebDAV";
    IWorkspace workspace = ResourcesPlugin.getWorkspace();

    public TestsSampleWebDAVContentProvider() {
        this(true);
    }

    TestsSampleWebDAVContentProvider(boolean withAutoRefresh) {
        super(withAutoRefresh, "TestsSampleWebDAVContentProvider", SampleWebDAVContentProvider.class.getName());
    }

    TestsSampleWebDAVContentProvider(boolean withAutoRefresh, String projectName, String providerName) {
        super(withAutoRefresh, projectName, providerName);
    }

    @Test
    public void testAddWebDAVFolder() throws Exception {
        final IFolder folder = this.testProject.getFolder("root");
        final int[] counters = new int[3];
        IResourceChangeListener listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                if (delta != null) {
                    IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta1) {
                            switch (delta1.getKind()) {
                                case 1: {
                                    counters[0] = counters[0] + 1;
                                    break;
                                }
                                case 2: {
                                    counters[1] = counters[1] + 1;
                                    break;
                                }
                                case 4: {
                                    counters[2] = counters[2] + 1;
                                }
                            }
                            return true;
                        }
                    };
                    try {
                        delta.accept(visitor);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.workspace.addResourceChangeListener(listener);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(final IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sFolder = (ISemanticFolder)folder.getAdapter(ISemanticFolder.class);
                try {
                    sFolder.addFolder("test", new URI(TestsSampleWebDAVContentProvider.WEBDAV_TEST_URL), TestsSampleWebDAVContentProvider.this.options, monitor);
                    folder.accept(new IResourceVisitor(){

                        public boolean visit(IResource resource) {
                            if (resource instanceof IFile) {
                                IFile file = (IFile)resource;
                                try {
                                    Util.safeClose((InputStream)file.getContents());
                                    monitor.worked(1);
                                }
                                catch (CoreException coreException) {
                                }
                                catch (Exception exception) {
                                    Assert.assertTrue((String)"should not fail", (boolean)false);
                                }
                            }
                            return true;
                        }
                    });
                }
                catch (URISyntaxException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                }
            }
        };
        this.workspace.run(runnable, (ISchedulingRule)this.testProject, 0, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)folder.getFolder("test").exists());
        Assert.assertTrue((String)"Added", (counters[0] > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Deleted", (counters[1] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Changed", (counters[2] > 0 ? 1 : 0) != 0);
        int j = 0;
        while (j < counters.length) {
            counters[j] = 0;
            ++j;
        }
        IWorkspaceRunnable runnable2 = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sFolder = (ISemanticFolder)folder.getAdapter(ISemanticFolder.class);
                sFolder.synchronizeContentWithRemote(SyncDirection.INCOMING, TestsSampleWebDAVContentProvider.this.options, monitor);
            }
        };
        this.workspace.run(runnable2, (ISchedulingRule)this.testProject, 0, (IProgressMonitor)new NullProgressMonitor());
        this.validateAndResetCounters(counters);
        IWorkspaceRunnable runnable3 = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sFolder = (ISemanticFolder)folder.getFolder("test").getAdapter(ISemanticFolder.class);
                sFolder.synchronizeContentWithRemote(SyncDirection.INCOMING, TestsSampleWebDAVContentProvider.this.options, monitor);
            }
        };
        this.workspace.run(runnable3, (ISchedulingRule)this.testProject, 0, (IProgressMonitor)new NullProgressMonitor());
        this.validateAndResetCounters(counters);
        IWorkspaceRunnable runnable4 = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                ISemanticFolder sFolder = (ISemanticFolder)folder.getFolder("test").getFolder("src").getAdapter(ISemanticFolder.class);
                sFolder.synchronizeContentWithRemote(SyncDirection.INCOMING, TestsSampleWebDAVContentProvider.this.options, monitor);
            }
        };
        this.workspace.run(runnable4, (ISchedulingRule)this.testProject, 0, (IProgressMonitor)new NullProgressMonitor());
        this.validateAndResetCounters(counters);
        this.workspace.removeResourceChangeListener(listener);
    }

    @Test
    public void testWebDAVAsLinkedResource() throws Exception {
        final IProject project = this.workspace.getRoot().getProject("testWebDAVAsLinkedResource");
        if (project.exists()) {
            throw new IllegalStateException("Project exists");
        }
        IWorkspaceRunnable myRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProjectDescription description = TestsSampleWebDAVContentProvider.this.workspace.newProjectDescription("testWebDAVAsLinkedResource");
                project.create(description, monitor);
                project.open(monitor);
            }
        };
        this.workspace.run(myRunnable, (ISchedulingRule)this.workspace.getRoot(), 1, null);
        final IFolder folder = project.getFolder("test");
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                URI uri = null;
                try {
                    try {
                        uri = new URI("semanticfs", null, "/webdav/test", "type=folder;create=true;provider=" + SampleWebDAVContentProvider.class.getName() + ";uri=" + TestsSampleWebDAVContentProvider.WEBDAV_TEST_URL, null);
                        folder.createLink(uri, 0, monitor);
                        ISemanticFolder sFolder = (ISemanticFolder)folder.getAdapter(ISemanticFolder.class);
                        Assert.assertEquals((String)SampleWebDAVContentProvider.class.getName(), (String)sFolder.getContentProviderID());
                        sFolder.synchronizeContentWithRemote(SyncDirection.INCOMING, TestsSampleWebDAVContentProvider.this.options, monitor);
                        IResource[] members = folder.members();
                        Assert.assertTrue((members.length > 0 ? 1 : 0) != 0);
                        IFile file = folder.getFile("test.txt");
                        ResourceAttributes attributes = file.getResourceAttributes();
                        attributes.setReadOnly(false);
                        file.setResourceAttributes(attributes);
                        file.setContents((InputStream)new ByteArrayInputStream("xxx".getBytes("UTF-8")), true, false, monitor);
                        sFolder.synchronizeContentWithRemote(SyncDirection.OUTGOING, TestsSampleWebDAVContentProvider.this.options, monitor);
                        ISemanticFile sFile = (ISemanticFile)file.getAdapter(ISemanticFile.class);
                        IStatus status = sFile.lockResource(TestsSampleWebDAVContentProvider.this.options, monitor);
                        Assert.assertTrue((boolean)status.isOK());
                        status = sFile.unlockResource(TestsSampleWebDAVContentProvider.this.options, monitor);
                        Assert.assertTrue((boolean)status.isOK());
                    }
                    catch (URISyntaxException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
                    }
                }
                catch (Throwable throwable) {
                    TestsSampleWebDAVContentProvider.this.cleanupSFS(uri, monitor);
                    throw throwable;
                }
                TestsSampleWebDAVContentProvider.this.cleanupSFS(uri, monitor);
            }
        };
        this.workspace.run(runnable, this.workspace.getRuleFactory().refreshRule((IResource)folder), 0, (IProgressMonitor)new NullProgressMonitor());
    }

    void cleanupSFS(URI uri, IProgressMonitor monitor) throws CoreException {
        IFileStore store;
        if (uri != null && !(store = EFS.getStore((URI)uri)).fetchInfo(0, monitor).exists()) {
            store.delete(this.options, monitor);
        }
    }

    private void validateAndResetCounters(int[] counters) {
        Assert.assertTrue((String)"Added", (counters[0] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Deleted", (counters[1] == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Changed", (counters[2] == 0 ? 1 : 0) != 0);
        int j = 0;
        while (j < counters.length) {
            counters[j] = 0;
            ++j;
        }
    }
}

