/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.databinding.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class EMFPropertyListener
extends AdapterImpl
implements INativePropertyListener {
    public void addTo(Object source) {
        if (source != null) {
            ((EObject)source).eAdapters().add((Object)this);
        }
    }

    public void removeFrom(Object source) {
        if (source != null) {
            ((EObject)source).eAdapters().remove((Object)this);
        }
    }

    public abstract void notifyChanged(Notification var1);

    protected abstract ISimplePropertyListener getListener();

    protected abstract EStructuralFeature getFeature();

    protected abstract IProperty getOwner();

    public static abstract class EMFListPropertyListener
    extends EMFPropertyListener {
        public void notifyChanged(Notification msg) {
            if (this.getFeature() == msg.getFeature() && !msg.isTouch()) {
                ListDiff diff;
                switch (msg.getEventType()) {
                    case 3: {
                        diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)msg.getPosition(), (boolean)true, (Object)msg.getNewValue()));
                        break;
                    }
                    case 5: {
                        Collection newValues = (Collection)msg.getNewValue();
                        ListDiffEntry[] listDiffEntries = new ListDiffEntry[newValues.size()];
                        int position = msg.getPosition();
                        int index = 0;
                        for (Object newValue : newValues) {
                            listDiffEntries[index++] = Diffs.createListDiffEntry((int)position++, (boolean)true, newValue);
                        }
                        diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                        break;
                    }
                    case 4: {
                        diff = Diffs.createListDiff((ListDiffEntry)Diffs.createListDiffEntry((int)msg.getPosition(), (boolean)false, (Object)msg.getOldValue()));
                        break;
                    }
                    case 6: {
                        Collection oldValues = (Collection)msg.getOldValue();
                        ListDiffEntry[] listDiffEntries = new ListDiffEntry[oldValues.size()];
                        int[] positions = (int[])msg.getNewValue();
                        if (positions == null) {
                            int index = 0;
                            for (Object oldValue : oldValues) {
                                listDiffEntries[index] = Diffs.createListDiffEntry((int)0, (boolean)false, oldValue);
                                ++index;
                            }
                        } else {
                            int index = 0;
                            for (Object oldValue : oldValues) {
                                listDiffEntries[index] = Diffs.createListDiffEntry((int)(positions[index] - index), (boolean)false, oldValue);
                                ++index;
                            }
                        }
                        diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                        break;
                    }
                    case 1: 
                    case 9: {
                        ListDiffEntry[] listDiffEntries = new ListDiffEntry[2];
                        int pos = msg.getPosition();
                        if (pos == -1) {
                            pos = 0;
                        }
                        listDiffEntries[0] = Diffs.createListDiffEntry((int)pos, (boolean)false, (Object)msg.getOldValue());
                        listDiffEntries[1] = Diffs.createListDiffEntry((int)pos, (boolean)true, (Object)msg.getNewValue());
                        diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                        break;
                    }
                    case 7: {
                        Object movedValue = msg.getNewValue();
                        ListDiffEntry[] listDiffEntries = new ListDiffEntry[]{Diffs.createListDiffEntry((int)((Integer)msg.getOldValue()), (boolean)false, (Object)movedValue), Diffs.createListDiffEntry((int)msg.getPosition(), (boolean)true, (Object)movedValue)};
                        diff = Diffs.createListDiff((ListDiffEntry[])listDiffEntries);
                        break;
                    }
                    case 2: {
                        return;
                    }
                    default: {
                        throw new RuntimeException("unhandled case");
                    }
                }
                this.getListener().handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, msg.getNotifier(), this.getOwner(), (IDiff)diff));
            }
        }
    }

    public static abstract class EMFMapPropertyListener
    extends EMFPropertyListener {
        public void notifyChanged(Notification msg) {
            if (this.getFeature() == msg.getFeature() && !msg.isTouch()) {
                this.getListener().handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, msg.getNotifier(), this.getOwner(), (IDiff)Diffs.computeMapDiff((Map)((Map)msg.getOldValue()), (Map)((Map)msg.getNewValue()))));
            }
        }
    }

    public static abstract class EMFSetPropertyListener
    extends EMFPropertyListener {
        public void notifyChanged(Notification msg) {
            if (this.getFeature() == msg.getFeature() && !msg.isTouch()) {
                SetDiff diff;
                switch (msg.getEventType()) {
                    case 3: {
                        diff = Diffs.createSetDiff(Collections.singleton(msg.getNewValue()), Collections.emptySet());
                        break;
                    }
                    case 5: {
                        Collection newValues = (Collection)msg.getNewValue();
                        diff = Diffs.createSetDiff(new HashSet(newValues), Collections.emptySet());
                        break;
                    }
                    case 4: {
                        diff = Diffs.createSetDiff(Collections.emptySet(), Collections.singleton(msg.getOldValue()));
                        break;
                    }
                    case 6: {
                        Collection oldValues = (Collection)msg.getOldValue();
                        diff = Diffs.createSetDiff(Collections.emptySet(), new HashSet(oldValues));
                        break;
                    }
                    case 1: 
                    case 9: {
                        diff = Diffs.createSetDiff(Collections.singleton(msg.getNewValue()), Collections.singleton(msg.getOldValue()));
                        break;
                    }
                    case 2: 
                    case 7: {
                        return;
                    }
                    default: {
                        throw new RuntimeException("unhandled case");
                    }
                }
                this.getListener().handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, msg.getNotifier(), this.getOwner(), (IDiff)diff));
            }
        }
    }

    public static abstract class EMFValuePropertyListener
    extends EMFPropertyListener {
        public void notifyChanged(Notification msg) {
            if (this.getFeature() == msg.getFeature() && !msg.isTouch()) {
                this.getListener().handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, msg.getNotifier(), this.getOwner(), (IDiff)Diffs.createValueDiff((Object)msg.getOldValue(), (Object)msg.getNewValue())));
            }
        }
    }
}

