/*
 * Decompiled with CFR 0.152.
 */
package test.swt;

import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.interpolator.KeyFrames;
import org.pushingpixels.trident.interpolator.KeyTimes;
import org.pushingpixels.trident.interpolator.KeyValues;
import org.pushingpixels.trident.swt.SWTRepaintTimeline;

public class ProgressIndication {
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("SWT progress");
        shell.setSize(400, 300);
        FillLayout layout = new FillLayout();
        shell.setLayout((Layout)layout);
        new ProgressPanel((Composite)shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    public static class ProgressPanel
    extends Canvas {
        private static final int INNER_HEIGHT = 60;
        private static final int INNER_WIDTH = 300;
        private static final int HIGHLIGHTER_HEIGHT = 2;
        private static final int HIGHLIGHTER_WIDTH = 58;
        private int xPosition = 0;
        private float alpha = 0.0f;
        private boolean started;
        private Timeline progressTimeline;

        public ProgressPanel(Composite parent) {
            super(parent, 0x20000000);
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    if (ProgressPanel.this.started) {
                        return;
                    }
                    ProgressPanel.this.start();
                    ProgressPanel.this.started = true;
                }
            });
            this.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    if (ProgressPanel.this.started) {
                        ProgressPanel.this.progressTimeline.cancel();
                        ProgressPanel.this.start();
                    }
                }
            });
            new SWTRepaintTimeline((Control)this).playLoop(Timeline.RepeatBehavior.LOOP);
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    GC gc = e.gc;
                    gc.setAntialias(1);
                    int w = e.width;
                    int h = e.height;
                    Color bg = new Color((Device)e.display, 12, 12, 12);
                    gc.setBackground(bg);
                    gc.fillRectangle(0, 0, w, h);
                    bg.dispose();
                    if (!ProgressPanel.this.started) {
                        gc.setForeground(e.display.getSystemColor(1));
                        Font font = new Font((Device)e.display, "Tahoma", 13, 0);
                        gc.setFont(font);
                        String caption = "Click to start";
                        Point stringExtent = gc.stringExtent(caption);
                        gc.drawString(caption, (w - stringExtent.x) / 2, h / 3 - stringExtent.y);
                        font.dispose();
                    }
                    Color pattern1 = new Color((Device)e.display, 47, 47, 47);
                    Pattern innerPattern = new Pattern((Device)e.display, (float)(w - 300) / 2.0f, (float)(h - 60) / 2.0f, (float)(w - 300) / 2.0f, (float)(h + 60) / 2.0f, pattern1, e.display.getSystemColor(2));
                    gc.setBackgroundPattern(innerPattern);
                    gc.fillRoundRectangle((w - 300) / 2, (h - 60) / 2, 300, 60, 10, 10);
                    gc.setBackgroundPattern(null);
                    pattern1.dispose();
                    innerPattern.dispose();
                    Color inner = new Color((Device)e.display, 67, 67, 67);
                    gc.setForeground(inner);
                    gc.drawRoundRectangle((w - 300) / 2, (h - 60) / 2, 300, 60, 10, 10);
                    inner.dispose();
                    int trackWidth = 264;
                    int trackHeight = 1;
                    Color track = new Color((Device)e.display, 91, 91, 91);
                    gc.setForeground(track);
                    int i = 2;
                    while (i >= 0) {
                        float trackAlpha = 1.0f;
                        if (i == 1) {
                            trackAlpha = 0.3f;
                        }
                        if (i == 2) {
                            trackAlpha = 0.1f;
                        }
                        gc.setAlpha((int)(255.0f * trackAlpha));
                        gc.drawRoundRectangle((w - 300) / 2 + 18 - i, h / 2 - i - 1, trackWidth + i * 2, trackHeight + i * 2, 2 * i, 2 * i);
                        --i;
                    }
                    track.dispose();
                    Color highlight = new Color((Device)e.display, 13, 106, 206);
                    gc.setBackground(highlight);
                    gc.setAlpha((int)(25.5f * ProgressPanel.this.alpha));
                    int i2 = 6;
                    while (i2 >= 0) {
                        gc.fillOval(ProgressPanel.this.xPosition - 29 - i2, h / 2 - 1 - i2, 58 + 2 * i2, 2 + 2 * i2);
                        --i2;
                    }
                    highlight.dispose();
                    gc.setAlpha((int)(255.0f * ProgressPanel.this.alpha));
                    Color trackHighlight = new Color((Device)e.display, 136, 182, 231);
                    gc.setBackground(trackHighlight);
                    gc.fillRectangle(ProgressPanel.this.xPosition - 28, h / 2 - 1, 56, 2);
                    trackHighlight.dispose();
                    gc.setAlpha(255);
                }
            });
        }

        public void start() {
            this.progressTimeline = new Timeline((Object)this);
            int startX = (this.getBounds().width - 300) / 2 + 18 + 29;
            int endX = (this.getBounds().width + 300) / 2 - 18 - 29;
            this.progressTimeline.addPropertyToInterpolate("xPosition", startX, endX);
            KeyValues<Float> alphaValues = KeyValues.create(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(0.0f));
            KeyTimes alphaTimes = new KeyTimes(0.0f, 0.3f, 0.7f, 1.0f);
            this.progressTimeline.addPropertyToInterpolate("alpha", new KeyFrames<Float>(alphaValues, alphaTimes));
            this.progressTimeline.setDuration(1500L);
            this.progressTimeline.playLoop(Timeline.RepeatBehavior.LOOP);
        }

        public void setXPosition(int position) {
            this.xPosition = position;
        }

        public void setAlpha(float alpha) {
            this.alpha = alpha;
        }
    }
}

