/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.filter;

import javax.servlet.ServletException;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.security.SecuritySynchronizer;

public class SecuredLocationVerifier {
    private static final Logger logger = Logger.getLogger(SecuredLocationVerifier.class);

    public static String isLocationSecured(String location) throws ServletException {
        for (String securedLocation : SecuritySynchronizer.getSecuredLocations()) {
            if (!location.startsWith(securedLocation)) continue;
            logger.debug(String.format("Location: %s is secured because of definition: %s", location, securedLocation));
            return securedLocation;
        }
        logger.debug(String.format("Location: %s is NOT secured", location));
        return null;
    }
}

