/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource.db.dialect;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.dirigible.repository.datasource.db.dialect.IDialectSpecifier;
import org.eclipse.dirigible.repository.logging.Logger;

class DialectFactoryNonOSGi {
    private static final Logger logger = Logger.getLogger((String)DialectFactoryNonOSGi.class.getCanonicalName());
    static Set<IDialectSpecifier> dialectSpecifiers = new HashSet<IDialectSpecifier>();
    static String derbyDialect = "org.eclipse.dirigible.repository.datasource.db.dialect.DerbyDBSpecifier";
    static String h2Dialect = "org.eclipse.dirigible.repository.datasource.db.dialect.H2DBSpecifier";
    static String hanadbDialect = "org.eclipse.dirigible.repository.datasource.db.dialect.HANADBSpecifier";
    static String mongodbDialect = "org.eclipse.dirigible.repository.datasource.db.dialect.MongoDBSpecifier";
    static String mysqlDialect = "org.eclipse.dirigible.repository.datasource.db.dialect.MySQLDBSpecifier";
    static String orientdbDialect = "org.eclipse.dirigible.repository.datasource.db.dialect.OrientDBSpecifier";
    static String postgresqlDialect = "org.eclipse.dirigible.repository.datasource.db.dialect.PostgreSQLDBSpecifier";
    static String sapdbDialect = "org.eclipse.dirigible.repository.datasource.db.dialect.SAPDBSpecifier";
    static String sybaseDialect = "org.eclipse.dirigible.repository.datasource.db.dialect.SybaseDBSpecifier";

    static {
        dialectSpecifiers.add(DialectFactoryNonOSGi.createDialectSpecifier(derbyDialect));
        dialectSpecifiers.add(DialectFactoryNonOSGi.createDialectSpecifier(h2Dialect));
        dialectSpecifiers.add(DialectFactoryNonOSGi.createDialectSpecifier(hanadbDialect));
        dialectSpecifiers.add(DialectFactoryNonOSGi.createDialectSpecifier(mongodbDialect));
        dialectSpecifiers.add(DialectFactoryNonOSGi.createDialectSpecifier(mysqlDialect));
        dialectSpecifiers.add(DialectFactoryNonOSGi.createDialectSpecifier(orientdbDialect));
        dialectSpecifiers.add(DialectFactoryNonOSGi.createDialectSpecifier(postgresqlDialect));
        dialectSpecifiers.add(DialectFactoryNonOSGi.createDialectSpecifier(sapdbDialect));
        dialectSpecifiers.add(DialectFactoryNonOSGi.createDialectSpecifier(sybaseDialect));
    }

    DialectFactoryNonOSGi() {
    }

    public static IDialectSpecifier getInstance(String productName) {
        for (IDialectSpecifier dialect : dialectSpecifiers) {
            if (dialect == null || !dialect.isDialectForName(productName)) continue;
            return dialect;
        }
        return null;
    }

    private static IDialectSpecifier createDialectSpecifier(String clazz) {
        try {
            return (IDialectSpecifier)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

