/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.db.wizard;

import org.eclipse.core.resources.IResource;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.common.TemplateWizard;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateDSVPage;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateModel;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateQueryPage;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateStructurePage;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateTargetLocationPage;
import org.eclipse.dirigible.ide.template.ui.db.wizard.DataStructureTemplateTypePage;
import org.eclipse.dirigible.ide.template.ui.db.wizard.Messages;
import org.eclipse.jface.wizard.IWizardPage;

public class DataStructureTemplateWizard
extends TemplateWizard {
    public static final String EXT_DSV = "dsv";
    public static final String EXT_APPEND = "append";
    public static final String EXT_DELETE = "delete";
    public static final String EXT_REPLACE = "replace";
    public static final String EXT_UPDATE = "update";
    public static final String EXT_VIEW = "view";
    public static final String EXT_TABLE = "table";
    private final DataStructureTemplateModel model;
    private final DataStructureTemplateTypePage typesPage;
    private final DataStructureTemplateStructurePage structurePage;
    private final DataStructureTemplateQueryPage queryPage;
    private final DataStructureTemplateDSVPage dsvPage;
    private final DataStructureTemplateTargetLocationPage targetLocationPage;

    public DataStructureTemplateWizard(IResource resource) {
        this.setWindowTitle(Messages.DataStructureTemplateWizard_CREATE_DATA_STRUCTURE);
        this.model = new DataStructureTemplateModel();
        this.model.setSourceResource(resource);
        this.typesPage = new DataStructureTemplateTypePage(this.model);
        this.structurePage = new DataStructureTemplateStructurePage(this.model);
        this.queryPage = new DataStructureTemplateQueryPage(this.model);
        this.dsvPage = new DataStructureTemplateDSVPage(this.model);
        this.targetLocationPage = new DataStructureTemplateTargetLocationPage(this.model);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.typesPage);
        this.addPage((IWizardPage)this.structurePage);
        this.addPage((IWizardPage)this.queryPage);
        this.addPage((IWizardPage)this.dsvPage);
        this.addPage((IWizardPage)this.targetLocationPage);
    }

    public TemplateGenerator getTemplateGenerator() {
        DataStructureTemplateGenerator generator = new DataStructureTemplateGenerator(this.model);
        return generator;
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        Object nextPage = null;
        if (page instanceof DataStructureTemplateTypePage) {
            if (EXT_TABLE.equals(this.model.getTemplate().getExtension())) {
                nextPage = this.structurePage;
            } else if (EXT_VIEW.equals(this.model.getTemplate().getExtension())) {
                nextPage = this.queryPage;
            } else if (EXT_DSV.equals(this.model.getTemplate().getExtension()) || EXT_APPEND.equals(this.model.getTemplate().getExtension()) || EXT_DELETE.equals(this.model.getTemplate().getExtension()) || EXT_REPLACE.equals(this.model.getTemplate().getExtension()) || EXT_UPDATE.equals(this.model.getTemplate().getExtension())) {
                nextPage = this.dsvPage;
            }
        } else if (page instanceof DataStructureTemplateStructurePage || page instanceof DataStructureTemplateQueryPage || page instanceof DataStructureTemplateDSVPage) {
            if (page instanceof DataStructureTemplateQueryPage) {
                DataStructureTemplateQueryPage queryPage = (DataStructureTemplateQueryPage)page;
                String queryText = queryPage.getQuery();
                if (queryText == null || "".equals(queryText.trim())) {
                    nextPage = page;
                    queryPage.setErrorMessage("SQL query string is empty");
                } else {
                    queryPage.setErrorMessage(null);
                    this.model.setQuery(queryText);
                }
            }
            nextPage = this.targetLocationPage;
        } else {
            nextPage = super.getNextPage(page);
        }
        return nextPage;
    }

    public boolean performFinish() {
        boolean result = super.performFinish();
        if (result) {
            StatusLineManagerUtil.setInfoMessage((String)String.format(StatusLineManagerUtil.ARTIFACT_HAS_BEEN_CREATED, this.model.getFileName()));
        }
        return result;
    }

    public boolean canFinish() {
        boolean can = super.canFinish();
        if (!can) {
            return can;
        }
        if (EXT_VIEW.equals(this.model.getTemplate().getExtension())) {
            String queryText = this.queryPage.getQuery();
            if (queryText == null || "".equals(queryText.trim())) {
                this.queryPage.setErrorMessage("SQL query string is empty");
                can = false;
            } else {
                this.queryPage.setErrorMessage(null);
                this.model.setQuery(queryText);
                can = true;
            }
        }
        return can;
    }
}

