/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.dirigible.ide.template.ui.common.GenerationException;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateType;
import org.eclipse.dirigible.ide.template.ui.common.service.AbstractGenerationWorker;
import org.eclipse.dirigible.ide.template.ui.common.table.ContentForEntityModel;
import org.eclipse.dirigible.ide.template.ui.common.table.TableColumn;
import org.eclipse.dirigible.repository.api.IRepository;

public abstract class ContentForEntityGenerationWorker
extends AbstractGenerationWorker {
    private static final String PARAM_SERVICE_ENDPOINT = "serviceEndpoint";
    private static final String PARAM_PAGE_TITLE = "pageTitle";
    private static final String PARAM_COLUMN_LABEL = "label";
    private static final String PARAM_COLUMN_WIDGET_TYPE = "widgetType";
    private static final String PARAM_COLUMN_SIZE = "size";
    private static final String PARAM_COLUMN_VISIBLE = "visible";
    private static final String PARAM_COLUMN_PRIMARY_KEY = "primaryKey";
    private static final String PARAM_COLUMN_TYPE = "type";
    private static final String PARAM_COLUMN_NAME = "name";
    private static final String PARAM_TABLE_NAME = "tableName";
    private static final String PARAM_DEPENDENT_COLUMN = "dependentColumn";
    private static final String PARAM_COLUMNS = "columns";

    public ContentForEntityGenerationWorker(IRepository repository, IWorkspace workspace) {
        super(repository, workspace);
    }

    @Override
    protected void readAndSetExtraParametersToModel(JsonObject parametersObject, GenerationModel model, TemplateType[] templates) throws GenerationException {
        ContentForEntityModel contentModel = (ContentForEntityModel)model;
        if (parametersObject.has(PARAM_COLUMNS)) {
            ArrayList<TableColumn> columnDefinitions = new ArrayList<TableColumn>();
            JsonArray columns = parametersObject.get(PARAM_COLUMNS).getAsJsonArray();
            for (JsonElement columnElement : columns) {
                if (!columnElement.isJsonObject()) continue;
                JsonObject columnObject = columnElement.getAsJsonObject();
                TableColumn columnDefinition = new TableColumn(columnObject.get(PARAM_COLUMN_NAME).getAsString(), columnObject.get(PARAM_COLUMN_PRIMARY_KEY).getAsBoolean(), columnObject.get(PARAM_COLUMN_VISIBLE).getAsBoolean(), columnObject.get(PARAM_COLUMN_TYPE).getAsString(), columnObject.get(PARAM_COLUMN_SIZE).getAsInt(), columnObject.get(PARAM_COLUMN_WIDGET_TYPE).getAsString(), columnObject.get(PARAM_COLUMN_LABEL).getAsString());
                columnDefinitions.add(columnDefinition);
            }
            contentModel.setTableColumns(columnDefinitions.toArray(new TableColumn[0]));
        } else {
            ContentForEntityGenerationWorker.checkIfRequired(contentModel, PARAM_COLUMNS);
        }
        if (parametersObject.has(PARAM_TABLE_NAME)) {
            contentModel.setTableName(parametersObject.get(PARAM_TABLE_NAME).getAsString());
        } else {
            ContentForEntityGenerationWorker.checkIfRequired(contentModel, PARAM_TABLE_NAME);
        }
        if (parametersObject.has(PARAM_DEPENDENT_COLUMN)) {
            contentModel.setDependentColumn(parametersObject.get(PARAM_DEPENDENT_COLUMN).getAsString());
        } else {
            ContentForEntityGenerationWorker.checkIfRequired(contentModel, PARAM_DEPENDENT_COLUMN);
        }
        if (parametersObject.has(PARAM_PAGE_TITLE)) {
            contentModel.setPageTitle(parametersObject.get(PARAM_PAGE_TITLE).getAsString());
        } else {
            ContentForEntityGenerationWorker.checkIfRequired(contentModel, PARAM_PAGE_TITLE);
        }
        if (parametersObject.has(PARAM_SERVICE_ENDPOINT)) {
            contentModel.setServiceEndpoint(parametersObject.get(PARAM_SERVICE_ENDPOINT).getAsString());
        } else {
            ContentForEntityGenerationWorker.checkIfRequired(contentModel, PARAM_SERVICE_ENDPOINT);
        }
    }
}

