/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.registry;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.ext.utils.RequestUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.content.ContentPostImportUpdater;
import org.eclipse.dirigible.runtime.registry.PathUtils;
import org.eclipse.dirigible.runtime.registry.RepositoryServlet;

public class WorkspacePublishServlet
extends RepositoryServlet {
    private static final Logger logger = Logger.getLogger(WorkspacePublishServlet.class);

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.publishResource(request);
        this.postImport(request);
    }

    protected void publishResource(HttpServletRequest request) throws IOException {
        String requestPath = PathUtils.extractPath((HttpServletRequest)request);
        RepositoryPath workspacePath = new RepositoryPath(requestPath);
        RepositoryPath registryPath = new RepositoryPath("");
        registryPath = registryPath.append("/db/dirigible/registry/public/");
        String[] segments = workspacePath.getSegments();
        int i = 1;
        while (i < segments.length) {
            registryPath = registryPath.append(segments[i]);
            ++i;
        }
        String originalPath = String.valueOf(this.getRepositoryPathPrefix(request)) + workspacePath;
        IRepository repository = this.getRepository(request);
        IResource resource = repository.getResource(originalPath);
        if (resource.exists()) {
            repository.createResource(registryPath.toString(), resource.getContent());
        } else {
            logger.error(String.format("Error copying resource from %s to %s", originalPath, registryPath.toString()));
        }
    }

    protected void postImport(HttpServletRequest request) throws ServletException {
        try {
            ContentPostImportUpdater contentPostImportUpdater = new ContentPostImportUpdater(this.getRepository(request));
            contentPostImportUpdater.update(request);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected String getRepositoryPathPrefix(HttpServletRequest req) {
        return "/db/dirigible/users/" + RequestUtils.getUser((HttpServletRequest)req) + "/" + "workspace";
    }
}

