/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.memory;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.ext.db.DBUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class MemoryLogRecordDAO {
    private static final Logger logger = Logger.getLogger(MemoryLogRecordDAO.class);
    private static final String SQL_MAP_INSERT_MEMORY_LOG = "/org/eclipse/dirigible/runtime/memory/sql/insert_memory_log.sql";
    private static final String SQL_MAP_SELECT_COUNT_MEMORY_LOGS = "/org/eclipse/dirigible/runtime/memory/sql/select_count_memory_logs.sql";
    private static final String SQL_MAP_CREATE_TABLE_MEMORY_LOG = "/org/eclipse/dirigible/runtime/memory/sql/create_table_memory_log.sql";
    private static final String SQL_MAP_REMOVE_OLDER_MEMORY_LOGS = "/org/eclipse/dirigible/runtime/memory/sql/remove_older_memory_logs.sql";
    private static final String SQL_MAP_SELECT_ALL_MEMORY_LOGS = "/org/eclipse/dirigible/runtime/memory/sql/select_all_memory_logs.sql";
    private static final String AVAILABLE_PROCESSORS = "availableProcessors";
    private static final String MAX_MEMORY = "maxMemory";
    private static final String TOTAL_MEMORY = "totalMemory";
    private static final String FREE_MEMORY = "freeMemory";
    private static final String MEMLOG_MAX_MEMORY = "MEMLOG_MAX_MEMORY";
    private static final String MEMLOG_TOTAL_MEMORY = "MEMLOG_TOTAL_MEMORY";
    private static final String MEMLOG_FREE_MEMORY = "MEMLOG_FREE_MEMORY";
    private static final String MEMLOG_TIMESTAMP = "MEMLOG_TIMESTAMP";

    public static String generateMemoryInfo() {
        Gson gson = new Gson();
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put(FREE_MEMORY, Runtime.getRuntime().freeMemory());
        map.put(TOTAL_MEMORY, Runtime.getRuntime().totalMemory());
        map.put(MAX_MEMORY, Runtime.getRuntime().maxMemory());
        map.put(AVAILABLE_PROCESSORS, Long.valueOf(Runtime.getRuntime().availableProcessors()));
        String content = gson.toJson(map);
        return content;
    }

    public static void insert() throws SQLException, IOException {
        try {
            MemoryLogRecordDAO.checkDB();
            DataSource dataSource = DataSourceFacade.getInstance().getDataSource(null);
            Connection connection = null;
            try {
                connection = dataSource.getConnection();
                DBUtils dbUtils = new DBUtils(dataSource);
                String sql = dbUtils.readScript(connection, SQL_MAP_INSERT_MEMORY_LOG, MemoryLogRecordDAO.class);
                PreparedStatement pstmt = connection.prepareStatement(sql);
                int i = 0;
                pstmt.setLong(++i, Runtime.getRuntime().freeMemory());
                pstmt.setLong(++i, Runtime.getRuntime().totalMemory());
                pstmt.setLong(++i, Runtime.getRuntime().maxMemory());
                pstmt.executeUpdate();
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (NamingException e) {
            throw new SQLException(e);
        }
    }

    private static void checkDB() throws NamingException, SQLException, IOException {
        DataSource dataSource = DataSourceFacade.getInstance().getDataSource(null);
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            Statement stmt = connection.createStatement();
            DBUtils dbUtils = new DBUtils(dataSource);
            String sqlCount = dbUtils.readScript(connection, SQL_MAP_SELECT_COUNT_MEMORY_LOGS, MemoryLogRecordDAO.class);
            String sqlCreate = dbUtils.readScript(connection, SQL_MAP_CREATE_TABLE_MEMORY_LOG, MemoryLogRecordDAO.class);
            try {
                stmt.executeQuery(sqlCount);
            }
            catch (Exception e) {
                logger.warn("DGB_MEMORY_LOG does not exist?" + e.getMessage());
                stmt.executeUpdate(sqlCreate);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public static void cleanupOlderRecords() throws SQLException, IOException {
        try {
            MemoryLogRecordDAO.checkDB();
            DataSource dataSource = DataSourceFacade.getInstance().getDataSource(null);
            Connection connection = null;
            try {
                connection = dataSource.getConnection();
                DBUtils dbUtils = new DBUtils(dataSource);
                String sql = dbUtils.readScript(connection, SQL_MAP_REMOVE_OLDER_MEMORY_LOGS, MemoryLogRecordDAO.class);
                PreparedStatement pstmt = connection.prepareStatement(sql);
                GregorianCalendar last = new GregorianCalendar();
                last.add(5, -1);
                pstmt.setTimestamp(1, new Timestamp(last.getTime().getTime()));
                pstmt.executeUpdate();
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (NamingException e) {
            throw new SQLException(e);
        }
    }

    public static String getMemoryLogRecords() throws SQLException, IOException {
        String string;
        block7: {
            MemoryLogRecordDAO.checkDB();
            DataSource dataSource = DataSourceFacade.getInstance().getDataSource(null);
            Connection connection = null;
            try {
                String result;
                connection = dataSource.getConnection();
                DBUtils dbUtils = new DBUtils(dataSource);
                String sql = dbUtils.readScript(connection, SQL_MAP_SELECT_ALL_MEMORY_LOGS, MemoryLogRecordDAO.class);
                PreparedStatement pstmt = connection.prepareStatement(sql);
                ArrayList memoryLogRecords = new ArrayList();
                ArrayList memlogFree = new ArrayList();
                ArrayList memlogTotal = new ArrayList();
                ArrayList memlogMax = new ArrayList();
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    Timestamp date = rs.getTimestamp(MEMLOG_TIMESTAMP);
                    ArrayList<Comparable<Date>> pair = new ArrayList<Comparable<Date>>();
                    pair.add(date);
                    pair.add(new Long(rs.getLong(MEMLOG_FREE_MEMORY) / 0x100000L));
                    memlogFree.add(pair);
                    pair = new ArrayList();
                    pair.add(date);
                    pair.add(new Long(rs.getLong(MEMLOG_TOTAL_MEMORY) / 0x100000L));
                    memlogTotal.add(pair);
                    pair = new ArrayList();
                    pair.add(date);
                    pair.add(new Long(rs.getLong(MEMLOG_MAX_MEMORY) / 0x100000L));
                    memlogMax.add(pair);
                }
                memoryLogRecords.add(memlogFree);
                memoryLogRecords.add(memlogTotal);
                memoryLogRecords.add(memlogMax);
                Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd hh:mm:ss").create();
                string = result = gson.toJson((Object)memoryLogRecords.toArray());
                if (connection == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                    throw throwable;
                }
                catch (NamingException e) {
                    throw new SQLException(e);
                }
            }
            connection.close();
        }
        return string;
    }
}

