/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.processing;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.ScriptRepository;

public class ScriptProcessor {
    public static ScriptResponse getScriptResponseForURL(String url, Integer contextId) {
        ScriptRepository repo = ScriptRepository.getInstance();
        String scriptId = repo.getScriptIdByURL(url);
        String source = repo.getSourceFor(scriptId);
        ScriptResponse response = new ScriptResponse(url, scriptId, contextId);
        try {
            response.setStartLine(ScriptProcessor.getStartLine(source));
            response.setEndLine(ScriptProcessor.getEndLine(source));
            response.setStartColumn(ScriptProcessor.getStartColumn(source));
            response.setEndColumn(ScriptProcessor.getEndColumn(source));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    private static Integer getStartColumn(String source) throws IOException {
        Integer startLine = ScriptProcessor.getStartLine(source);
        String[] lines = source.split("\n");
        String firstLine = lines.length == 0 ? source : lines[startLine];
        int column = 0;
        while (!Character.isLetter(firstLine.charAt(column))) {
            ++column;
        }
        return column;
    }

    private static Integer getStartLine(String source) {
        String[] lines = source.split("\n");
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (!line.isEmpty()) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private static Integer getEndColumn(String source) throws IOException {
        String line;
        int currentMaxColumns = 0;
        BufferedReader reader = new BufferedReader(new StringReader(source));
        while ((line = reader.readLine()) != null) {
            if (line.length() <= currentMaxColumns) continue;
            currentMaxColumns = line.length();
        }
        reader.close();
        return currentMaxColumns;
    }

    private static Integer getEndLine(String source) throws IOException {
        return source.split("\n").length;
    }

    public static class ScriptResponse {
        private final String method = "Debugger.scriptParsed";
        private final Map<String, Object> params = new HashMap<String, Object>();

        public ScriptResponse(String url, String scriptId, Integer contextId) {
            this.params.put("deprecatedCommentWasUsed", false);
            this.params.put("hasSourceURL", true);
            this.params.put("url", url);
            this.params.put("hash", String.valueOf(url.hashCode()));
            this.params.put("isContentScript", false);
            this.params.put("isInternalScript", true);
            this.params.put("isLiveEdit", false);
            this.params.put("sourceMapURL", "");
            this.params.put("scriptId", scriptId);
            this.params.put("executionContextId", contextId);
        }

        public void setStartLine(Integer startLine) {
            this.params.put("startLine", startLine);
        }

        public void setEndLine(Integer endLine) {
            this.params.put("endLine", endLine);
        }

        public void setStartColumn(Integer startColumn) {
            this.params.put("startColumn", startColumn);
        }

        public void setEndColumn(Integer endColumn) {
            this.params.put("endColumn", endColumn);
        }
    }
}

