/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.handlers;

import org.eclipse.dirigible.runtime.chrome.debugger.handlers.DebuggerStepHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.EmptyResultHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.EvaluateOnCallFrameHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.GetPropertiesHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.GetResourceContentHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.GetResourceTreeHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.GetScriptSourceHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.MessageHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.RemoveBreakpointMessageHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.SetBreakpointMessageHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.SetScriptSourceHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.utils.RequestUtils;

public class MessageHandlerFactory {
    public static MessageHandler getHandler(String message) {
        if (RequestUtils.isSetBreakpointMessage(message)) {
            return new SetBreakpointMessageHandler();
        }
        if (RequestUtils.isRemoveBreakpointMessage(message)) {
            return new RemoveBreakpointMessageHandler();
        }
        if (RequestUtils.isDebuggerStepMessage(message)) {
            return new DebuggerStepHandler();
        }
        if (RequestUtils.isGetResourceContent(message)) {
            return new GetResourceContentHandler();
        }
        if (RequestUtils.isGetResourceTree(message)) {
            return new GetResourceTreeHandler();
        }
        if (RequestUtils.isGetScritpSource(message)) {
            return new GetScriptSourceHandler();
        }
        if (RequestUtils.isSetScriptSource(message)) {
            return new SetScriptSourceHandler();
        }
        if (RequestUtils.isGetProperties(message)) {
            return new GetPropertiesHandler();
        }
        if (RequestUtils.isEvaluateOnCallFrame(message)) {
            return new EvaluateOnCallFrameHandler();
        }
        return new EmptyResultHandler();
    }
}

