/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.scripts.publish;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.publish.AbstractPublisher;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.repository.api.ICollection;

public class TestCasesPublisher
extends AbstractPublisher
implements IPublisher {
    public void publish(IProject project, HttpServletRequest request) throws PublishException {
        try {
            ICollection targetContainer = this.getTargetProjectContainer(this.getRegistryLocation(), request);
            IFolder sourceFolder = this.getSourceFolder(project, "TestCases");
            this.copyAllFromTo((IContainer)sourceFolder, targetContainer, request);
        }
        catch (Exception ex) {
            throw new PublishException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void activate(IProject project, HttpServletRequest request) throws PublishException {
        try {
            ICollection targetContainer = this.getTargetProjectContainer(CommonIDEParameters.getTestingContentSandbox((HttpServletRequest)request), request);
            IFolder sourceFolder = this.getSourceFolder(project, "TestCases");
            this.copyAllFromTo((IContainer)sourceFolder, targetContainer, request);
        }
        catch (Exception ex) {
            throw new PublishException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected String getSandboxLocation(HttpServletRequest request) {
        return CommonIDEParameters.getTestingContentSandbox((HttpServletRequest)request);
    }

    public String getFolderType() {
        return "TestCases";
    }

    public boolean recognizedFile(IFile file) {
        return this.checkFolderType(file) && "js".equals(file.getFileExtension());
    }

    public String getPublishedContainerMapping(IFile file) {
        return "/test";
    }

    public String getActivatedContainerMapping(IFile file) {
        return "/test-sandbox";
    }

    public boolean isAutoActivationAllowed() {
        return true;
    }

    protected String getRegistryLocation() {
        return "/db/dirigible/registry/public/TestCases";
    }

    public void template(IProject project, HttpServletRequest request) throws PublishException {
    }
}

