/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.js.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.ext.db.AbstractDataUpdater;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.js.test.Messages;
import org.eclipse.dirigible.runtime.mock.LocalHttpServletRequest;
import org.eclipse.dirigible.runtime.mock.LocalHttpServletResponse;
import org.eclipse.dirigible.runtime.scripting.utils.ExecutionService;

public class TestExecutionUpdater
extends AbstractDataUpdater {
    private static final String TEST_EXECUTION_S_COMPLETED = Messages.TestExecutionUpdater_TEST_EXECUTION_S_COMPLETED;
    private static final String TEST_EXECUTION_RESULT_FOR_S_S = Messages.TestExecutionUpdater_TEST_EXECUTION_RESULT_FOR_S_S;
    private static final String TEST_EXECUTION_STARTED_FOR_S = Messages.TestExecutionUpdater_TEST_EXECUTION_STARTED_FOR_S;
    private static final String TESTS_EXECUTION_STARTED_FOR_D = Messages.TestExecutionUpdater_TESTS_EXECUTION_STARTED_FOR_D;
    private static final String TESTS_EXECUTION_COMPLETED = Messages.TestExecutionUpdater_TESTS_EXECUTION_COMPLETED;
    private static final String URL_HTTP_LOCAL = "http://local/";
    public static final String EXTENSION_TEST = "_test.js";
    public static final String REGISTRY_TEST_DEFAULT = "/db/dirigible/registry/public/TestCases";
    private static final Logger logger = Logger.getLogger(TestExecutionUpdater.class);
    private IRepository repository;
    private DataSource dataSource;
    private String location;

    public TestExecutionUpdater(IRepository repository, DataSource dataSource, String location) {
        this.repository = repository;
        this.dataSource = dataSource;
        this.location = location;
    }

    public void executeUpdate(List<String> knownFiles, HttpServletRequest request, List<String> errors) throws Exception {
        String param = System.getProperty("runTestsOnInit");
        if (param != null) {
            if (!Boolean.parseBoolean(param)) {
                return;
            }
        } else {
            return;
        }
        if (knownFiles.size() == 0) {
            return;
        }
        logger.info(String.format(TESTS_EXECUTION_STARTED_FOR_D, knownFiles.size()));
        long globalTimeStart = System.currentTimeMillis();
        for (String testDefinition : knownFiles) {
            try {
                if (!testDefinition.endsWith(EXTENSION_TEST)) continue;
                String resourcePath = testDefinition;
                if (resourcePath.indexOf(this.location) >= 0) {
                    resourcePath = resourcePath.substring(this.location.length() + 1);
                }
                long localTimeStart = System.currentTimeMillis();
                logger.info(String.format(TEST_EXECUTION_STARTED_FOR_S, resourcePath));
                this.executeTestUpdate(resourcePath);
                logger.info(String.format(TEST_EXECUTION_S_COMPLETED, resourcePath, System.currentTimeMillis() - localTimeStart));
            }
            catch (Throwable t) {
                logger.error(t.getMessage(), t);
                errors.add(t.getMessage());
            }
        }
        logger.info(String.format(TESTS_EXECUTION_COMPLETED, System.currentTimeMillis() - globalTimeStart));
    }

    private void executeTestUpdate(String resourcePath) throws IOException {
        LocalHttpServletRequest request = new LocalHttpServletRequest(new URL(URL_HTTP_LOCAL + resourcePath));
        request.getSession().setAttribute("repository-instance", (Object)this.repository);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LocalHttpServletResponse response = new LocalHttpServletResponse(out);
        ExecutionService executionService = new ExecutionService();
        Object result = executionService.execute((HttpServletRequest)request, (HttpServletResponse)response, resourcePath, null, "test");
        logger.info(new String(out.toByteArray()));
        if (result instanceof Boolean) {
            logger.info(String.format(TEST_EXECUTION_RESULT_FOR_S_S, resourcePath, result));
        }
    }

    public void enumerateKnownFiles(ICollection collection, List<String> dsDefinitions) throws IOException {
        if (collection.exists()) {
            List resources = collection.getResources();
            for (IResource resource : resources) {
                if (resource == null || resource.getName() == null || !resource.getName().endsWith(EXTENSION_TEST)) continue;
                String fullPath = resource.getPath();
                dsDefinitions.add(fullPath);
            }
            List collections = collection.getCollections();
            for (ICollection subCollection : collections) {
                this.enumerateKnownFiles(subCollection, dsDefinitions);
            }
        }
    }

    public void applyUpdates() throws IOException, Exception {
        ArrayList<String> knownFiles = new ArrayList<String>();
        ICollection srcContainer = this.repository.getCollection(this.location);
        if (srcContainer.exists()) {
            this.enumerateKnownFiles(srcContainer, knownFiles);
            this.executeUpdate(knownFiles, null);
        }
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public String getLocation() {
        return this.location;
    }

    public void executeUpdate(List<String> knownFiles, List<String> errors) throws Exception {
        this.executeUpdate(knownFiles, null, errors);
    }
}

