/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.handlers;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.websocket.Session;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.BreakpointRequest;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.BreakpointResponse;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.EmptyResponse;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.MessageResponse;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.MessageHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.models.Breakpoint;
import org.eclipse.dirigible.runtime.chrome.debugger.models.Location;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.BreakpointRepository;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.DebuggingService;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.MessageDispatcher;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.ScriptRepository;

public class SetBreakpointMessageHandler
implements MessageHandler {
    private static final Gson GSON = new Gson();
    private static final BreakpointRepository REPOSITORY = BreakpointRepository.getInstance();

    @Override
    public void handle(String message, Session session) {
        MessageResponse response = this.isSetByUrl(message) ? this.handleByUrl(message, session) : (this.isSetActive(message) ? this.handleActivateAll(message, session) : this.defaultHandle(message, session));
        MessageDispatcher.sendSyncMessage(GSON.toJson((Object)response), session);
    }

    private MessageResponse handleByUrl(String message, Session session) {
        BreakpointRequest request = (BreakpointRequest)GSON.fromJson(message, BreakpointRequest.class);
        Integer messageId = request.getId();
        Integer lineNumber = request.getLineNumber().intValue();
        Integer columnNumber = request.getColumnNumber().intValue();
        String url = request.getUrl();
        Location location = this.getLocationForRequest(request, lineNumber, columnNumber, url);
        String breakpointId = this.getBreakpointId(lineNumber, columnNumber, url);
        REPOSITORY.add(session.getUserPrincipal().getName(), new Breakpoint(breakpointId, location));
        return this.getResponseMessage(messageId, lineNumber, columnNumber, url);
    }

    private MessageResponse handleActivateAll(String message, Session session) {
        BreakpointRequest request = (BreakpointRequest)GSON.fromJson(message, BreakpointRequest.class);
        Integer messageId = request.getId();
        Boolean active = request.getActive();
        String userId = session.getUserPrincipal().getName();
        if (active.booleanValue()) {
            DebuggingService.activateAllBreakpoints(userId);
        } else {
            DebuggingService.deactivateAllBreakpoints(userId);
        }
        return new EmptyResponse(messageId);
    }

    private MessageResponse defaultHandle(String message, Session session) {
        BreakpointRequest request = (BreakpointRequest)GSON.fromJson(message, BreakpointRequest.class);
        Integer messageId = request.getId();
        String url = request.getUrl();
        Integer lineNumber = request.getLineNumber().intValue();
        Integer columnNumber = request.getColumnNumber().intValue();
        String condition = request.getCondition();
        Location location = this.getLocationForRequest(request, lineNumber, columnNumber, url);
        String breakpointId = this.getBreakpointId(lineNumber, columnNumber, url);
        REPOSITORY.add(session.getUserPrincipal().getName(), new Breakpoint(breakpointId, location));
        return this.getResponseMessage(messageId, lineNumber, columnNumber, condition);
    }

    private MessageResponse getResponseMessage(Integer messageId, Integer lineNumber, Integer columnNumber, String url) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("breakpointId", this.getBreakpointId(lineNumber, columnNumber, url));
        ArrayList<Map<String, Object>> locations = new ArrayList<Map<String, Object>>();
        Map<String, Object> location = this.getLocationMap(lineNumber, columnNumber, url);
        locations.add(location);
        result.put("locations", locations);
        return new BreakpointResponse(messageId, result);
    }

    private Map<String, Object> getLocationMap(Integer lineNumber, Integer columnNumber, String url) {
        HashMap<String, Object> location = new HashMap<String, Object>();
        location.put("columnNumber", columnNumber);
        location.put("lineNumber", lineNumber);
        ScriptRepository repo = ScriptRepository.getInstance();
        location.put("scriptId", repo.getScriptIdByURL(url));
        return location;
    }

    private Location getLocationForRequest(BreakpointRequest request, Integer lineNumber, Integer columnNumber, String url) {
        Location location = request.getLocation();
        if (location == null) {
            location = new Location();
            location.setColumnNumber((double)columnNumber);
            location.setLineNumber((double)lineNumber);
            ScriptRepository scriptRepo = ScriptRepository.getInstance();
            String scriptId = scriptRepo.getScriptIdByURL(url);
            location.setScriptId(scriptId);
        }
        return location;
    }

    private String getBreakpointId(Integer lineNumber, Integer columnNumber, String url) {
        return String.format("%s:%d:%d", url, lineNumber, columnNumber);
    }

    private boolean isSetByUrl(String message) {
        return message.contains("Debugger.setBreakpointByUrl");
    }

    private boolean isSetActive(String message) {
        return message.contains("Debugger.setBreakpointsActive");
    }
}

