/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.db;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.api.RepositoryPath;
import org.eclipse.dirigible.repository.db.DBBaseException;
import org.eclipse.dirigible.repository.db.DBEntity;
import org.eclipse.dirigible.repository.db.DBRepository;
import org.eclipse.dirigible.repository.db.DBResource;
import org.eclipse.dirigible.repository.db.Messages;
import org.eclipse.dirigible.repository.db.dao.DBFile;
import org.eclipse.dirigible.repository.db.dao.DBFolder;
import org.eclipse.dirigible.repository.db.dao.DBObject;

public class DBCollection
extends DBEntity
implements ICollection {
    private static final String THERE_IS_NO_COLLECTION_AT_PATH_0 = Messages.getString("DBCollection.THERE_IS_NO_COLLECTION_AT_PATH_0");
    private static final String COULD_NOT_CREATE_CHILD_DOCUMENT = Messages.getString("DBCollection.COULD_NOT_CREATE_CHILD_DOCUMENT");
    private static final String COULD_NOT_GET_CHILD_RESOURCE_NAMES = Messages.getString("DBCollection.COULD_NOT_GET_CHILD_RESOURCE_NAMES");
    private static final String COULD_NOT_CREATE_CHILD_COLLECTION = Messages.getString("DBCollection.COULD_NOT_CREATE_CHILD_COLLECTION");
    private static final String COULD_NOT_GET_CHILD_COLLECTION_NAMES = Messages.getString("DBCollection.COULD_NOT_GET_CHILD_COLLECTION_NAMES");
    private static final String NOT_IMPLEMENTED = Messages.getString("DBCollection.NOT_IMPLEMENTED");
    private static final String COULD_NOT_DELETE_COLLECTION = Messages.getString("DBCollection.COULD_NOT_DELETE_COLLECTION");
    private static final String COULD_NOT_RENAME_COLLECTION = Messages.getString("DBCollection.COULD_NOT_RENAME_COLLECTION");
    private static final String CANNOT_CREATE_ROOT_COLLECTION = Messages.getString("DBCollection.CANNOT_CREATE_ROOT_COLLECTION");

    public DBCollection(DBRepository repository, RepositoryPath path) {
        super(repository, path);
    }

    public void create() throws IOException {
        ICollection parent = this.getParent();
        if (parent == null) {
            throw new DBBaseException(CANNOT_CREATE_ROOT_COLLECTION);
        }
        parent.createCollection(this.getName());
    }

    public void delete() throws IOException {
        DBFolder folder = this.getFolderSafe();
        try {
            folder.deleteTree();
        }
        catch (DBBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_DELETE_COLLECTION) + this.getName(), (Throwable)((Object)ex));
        }
    }

    public void renameTo(String name) throws IOException {
        DBFolder folder = this.getFolderSafe();
        try {
            folder.renameFolder(RepositoryPath.normalizePath((String)this.getParent().getPath(), (String)name));
        }
        catch (DBBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_RENAME_COLLECTION) + this.getName(), (Throwable)((Object)ex));
        }
    }

    public void moveTo(String path) throws IOException {
        DBFolder folder = this.getFolderSafe();
        try {
            folder.renameFolder(path);
        }
        catch (DBBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_RENAME_COLLECTION) + this.getName(), (Throwable)((Object)ex));
        }
    }

    public void copyTo(String path) throws IOException {
        throw new IOException(NOT_IMPLEMENTED);
    }

    public boolean exists() throws IOException {
        if ("/".equals(this.getRepositoryPath().toString())) {
            return true;
        }
        return this.getFolder() != null;
    }

    public boolean isEmpty() throws IOException {
        return this.getResources().isEmpty() && this.getCollections().isEmpty();
    }

    public List<ICollection> getCollections() throws IOException {
        List<String> collectionNames = this.getCollectionsNames();
        ArrayList<ICollection> result = new ArrayList<ICollection>(collectionNames.size());
        for (String collectionName : collectionNames) {
            result.add(this.getCollection(collectionName));
        }
        return result;
    }

    public List<String> getCollectionsNames() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        DBFolder folder = this.getFolderSafe();
        try {
            for (DBObject child : folder.getChildren()) {
                if (!(child instanceof DBFolder)) continue;
                result.add(child.getName());
            }
        }
        catch (DBBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_GET_CHILD_COLLECTION_NAMES) + this.getName(), (Throwable)((Object)ex));
        }
        return result;
    }

    public ICollection createCollection(String name) throws IOException {
        this.createAncestorsAndSelfIfMissing();
        DBFolder folder = this.getFolderSafe();
        try {
            folder.createFolder(name);
        }
        catch (DBBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_CREATE_CHILD_COLLECTION) + name, (Throwable)((Object)ex));
        }
        return this.getCollection(name);
    }

    public ICollection getCollection(String name) {
        RepositoryPath path = this.getRepositoryPath().append(name);
        return new DBCollection(this.getRepository(), path);
    }

    public void removeCollection(String name) throws IOException {
        ICollection collection = this.getCollection(name);
        collection.delete();
    }

    public void removeCollection(ICollection childCollection) throws IOException {
        this.removeCollection(childCollection.getName());
    }

    public List<IResource> getResources() throws IOException {
        List<String> resourceNames = this.getResourcesNames();
        ArrayList<IResource> result = new ArrayList<IResource>(resourceNames.size());
        for (String resourceName : resourceNames) {
            result.add(this.getResource(resourceName));
        }
        return result;
    }

    public List<String> getResourcesNames() throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        DBFolder folder = this.getFolderSafe();
        try {
            for (DBObject child : folder.getChildren()) {
                if (!(child instanceof DBFile)) continue;
                result.add(child.getName());
            }
        }
        catch (DBBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_GET_CHILD_RESOURCE_NAMES) + this.getName(), (Throwable)((Object)ex));
        }
        return result;
    }

    public IResource getResource(String name) throws IOException {
        RepositoryPath path = this.getRepositoryPath().append(name);
        return new DBResource(this.getRepository(), path);
    }

    public IResource createResource(String name, byte[] content, boolean isBinary, String contentType) throws IOException {
        this.createAncestorsAndSelfIfMissing();
        DBFolder folder = this.getFolderSafe();
        try {
            folder.createFile(name, content, isBinary, contentType);
        }
        catch (DBBaseException ex) {
            throw new IOException(String.valueOf(COULD_NOT_CREATE_CHILD_DOCUMENT) + name, (Throwable)((Object)ex));
        }
        return this.getResource(name);
    }

    public void removeResource(String name) throws IOException {
        IResource resource = this.getResource(name);
        resource.delete();
    }

    public void removeResource(IResource resource) throws IOException {
        this.removeResource(resource.getName());
    }

    public List<IEntity> getChildren() throws IOException {
        ArrayList<IEntity> result = new ArrayList<IEntity>();
        result.addAll(this.getCollections());
        result.addAll(this.getResources());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DBCollection)) {
            return false;
        }
        DBCollection other = (DBCollection)obj;
        return this.getPath().equals(other.getPath());
    }

    @Override
    public int hashCode() {
        return this.getPath().hashCode();
    }

    protected DBFolder getFolder() throws IOException {
        DBObject object = this.getDBObject();
        if (object == null) {
            return null;
        }
        if (!(object instanceof DBFolder)) {
            return null;
        }
        return (DBFolder)object;
    }

    protected DBFolder getFolderSafe() throws IOException {
        DBFolder folder = this.getFolder();
        if (folder == null) {
            throw new IOException(MessageFormat.format(THERE_IS_NO_COLLECTION_AT_PATH_0, this.getPath()));
        }
        return folder;
    }
}

