/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.websocket;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import org.apache.catalina.util.Conversions;
import org.apache.catalina.websocket.Utf8Decoder;
import org.apache.coyote.http11.upgrade.UpgradeProcessor;
import org.apache.tomcat.util.res.StringManager;

public class WsFrame {
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.websocket");
    private final boolean fin;
    private final int rsv;
    private final byte opCode;
    private final byte[] mask = new byte[4];
    private long payloadLength;
    private final ByteBuffer payload;

    private WsFrame(byte first, UpgradeProcessor<?> processor) throws IOException {
        byte[] extended;
        int b = first & 0xFF;
        this.fin = (b & 0x80) > 0;
        this.rsv = (b & 0x70) >>> 4;
        this.opCode = (byte)(b & 0xF);
        b = this.blockingRead(processor);
        if ((b & 0x80) == 0) {
            throw new IOException(sm.getString("frame.notMasked"));
        }
        this.payloadLength = b & 0x7F;
        if (this.payloadLength == 126L) {
            extended = new byte[2];
            this.blockingRead(processor, extended);
            this.payloadLength = Conversions.byteArrayToLong(extended);
        } else if (this.payloadLength == 127L) {
            extended = new byte[8];
            this.blockingRead(processor, extended);
            this.payloadLength = Conversions.byteArrayToLong(extended);
        }
        if (this.isControl()) {
            if (this.payloadLength > 125L) {
                throw new IOException();
            }
            if (!this.fin) {
                throw new IOException();
            }
        }
        this.blockingRead(processor, this.mask);
        if (this.isControl()) {
            this.payload = ByteBuffer.allocate((int)this.payloadLength);
            this.blockingRead(processor, this.payload);
            if (this.opCode == 8 && this.payloadLength > 2L) {
                CharBuffer cb = CharBuffer.allocate((int)this.payloadLength);
                Utf8Decoder decoder = new Utf8Decoder();
                this.payload.position(2);
                CoderResult cr = decoder.decode(this.payload, cb, true);
                this.payload.position(0);
                if (cr.isError()) {
                    throw new IOException(sm.getString("frame.invalidUtf8"));
                }
            }
        } else {
            this.payload = null;
        }
    }

    public boolean getFin() {
        return this.fin;
    }

    public int getRsv() {
        return this.rsv;
    }

    public byte getOpCode() {
        return this.opCode;
    }

    public boolean isControl() {
        return (this.opCode & 8) > 0;
    }

    public byte[] getMask() {
        return this.mask;
    }

    public long getPayLoadLength() {
        return this.payloadLength;
    }

    public ByteBuffer getPayLoad() {
        return this.payload;
    }

    private int blockingRead(UpgradeProcessor<?> processor) throws IOException {
        int result = processor.read();
        if (result == -1) {
            throw new IOException(sm.getString("frame.eos"));
        }
        return result;
    }

    private void blockingRead(UpgradeProcessor<?> processor, byte[] bytes) throws IOException {
        int last = 0;
        for (int read = 0; read < bytes.length; read += last) {
            last = processor.read(true, bytes, read, bytes.length - read);
            if (last != -1) continue;
            throw new IOException(sm.getString("frame.eos"));
        }
    }

    private void blockingRead(UpgradeProcessor<?> processor, ByteBuffer bb) throws IOException {
        int last = 0;
        while (bb.hasRemaining()) {
            last = processor.read();
            if (last == -1) {
                throw new IOException(sm.getString("frame.eos"));
            }
            bb.put((byte)(last ^ this.mask[bb.position() % 4]));
        }
        bb.flip();
    }

    public static WsFrame nextFrame(UpgradeProcessor<?> processor, boolean block) throws IOException {
        byte[] first = new byte[1];
        int read = processor.read(block, first, 0, 1);
        if (read == 1) {
            return new WsFrame(first[0], processor);
        }
        if (read == 0) {
            return null;
        }
        if (read == -1) {
            throw new EOFException(sm.getString("frame.readEos"));
        }
        throw new IOException(sm.getString("frame.readFailed", read));
    }
}

