/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.java.dynamic.compilation;

import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

public class InMemoryDiagnosticListener
implements DiagnosticListener<JavaFileObject> {
    private static final String NEW_LINE = "\n";
    private static final String COLUMN = "Column: ";
    private static final String LINE = "Line: ";
    private StringBuilder errors = new StringBuilder();
    private StringBuilder warnings = new StringBuilder();

    public String getErrors() {
        return this.errors.toString();
    }

    public String getWarnings() {
        return this.warnings.toString();
    }

    @Override
    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        switch (diagnostic.getKind()) {
            case ERROR: {
                this.recordError(diagnostic);
            }
        }
        this.recordWarning(diagnostic);
    }

    private void recordError(Diagnostic<? extends JavaFileObject> diagnostic) {
        this.errors.append(this.getMessage(diagnostic));
    }

    private void recordWarning(Diagnostic<? extends JavaFileObject> diagnostic) {
        this.warnings.append(this.getMessage(diagnostic));
    }

    private String getMessage(Diagnostic<? extends JavaFileObject> diagnostic) {
        StringBuilder message = new StringBuilder();
        message.append(NEW_LINE + (Object)((Object)diagnostic.getKind()) + NEW_LINE);
        JavaFileObject javaFileObject = diagnostic.getSource();
        if (javaFileObject != null) {
            message.append(String.valueOf(javaFileObject.getName()) + NEW_LINE);
        }
        message.append(String.valueOf(diagnostic.getMessage(null)) + NEW_LINE);
        message.append(LINE + diagnostic.getLineNumber() + NEW_LINE);
        message.append(COLUMN + diagnostic.getColumnNumber() + NEW_LINE);
        return message.toString();
    }
}

