/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.cm.ConfigurationAdminImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetMap {
    private final Map<ServiceReference<?>, List<List<String>>> targetToQualifiedPids = new HashMap();
    private final Map<String, Collection<ServiceReference<?>>> qualifiedPidToTargets = new HashMap();

    public List<List<String>> add(ServiceReference<?> ref) {
        Version v;
        List<String> specifiedPids = TargetMap.getPids(ref.getProperty("service.pid"));
        if (specifiedPids.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        Bundle b = ref.getBundle();
        String bsn = b.getSymbolicName();
        if (bsn == null) {
            bsn = "";
        }
        String version = (v = b.getVersion()) == null ? "" : v.toString();
        String location = ConfigurationAdminImpl.getLocation(b);
        ArrayList result = new ArrayList(specifiedPids.size());
        for (String specifiedPid : specifiedPids) {
            this.getTargetsInternal(specifiedPid).add(ref);
            StringBuilder sb = new StringBuilder(specifiedPid);
            sb.append('|').append(bsn);
            String pidBsn = sb.toString();
            this.getTargetsInternal(pidBsn).add(ref);
            sb.append('|').append(version);
            String pidBsnVersion = sb.toString();
            this.getTargetsInternal(pidBsnVersion).add(ref);
            sb.append('|').append(location);
            String pidBsnVersionLocation = sb.toString();
            this.getTargetsInternal(pidBsnVersionLocation).add(ref);
            ArrayList<String> qualifiedPIDs = new ArrayList<String>(4);
            qualifiedPIDs.add(pidBsnVersionLocation);
            qualifiedPIDs.add(pidBsnVersion);
            qualifiedPIDs.add(pidBsn);
            qualifiedPIDs.add(specifiedPid);
            result.add(qualifiedPIDs);
        }
        List<List<String>> unmodifiable = Collections.unmodifiableList(result);
        this.targetToQualifiedPids.put(ref, unmodifiable);
        return unmodifiable;
    }

    public static List<String> getPids(Object pid) {
        List<String> specifiedPids = Collections.EMPTY_LIST;
        if (pid == null) {
            return specifiedPids;
        }
        if (pid instanceof String) {
            specifiedPids = Collections.singletonList((String)pid);
        } else if (pid instanceof Collection) {
            Collection pidList = (Collection)pid;
            specifiedPids = new ArrayList<String>(pidList);
        } else if (pid.getClass().isArray()) {
            specifiedPids = new ArrayList<String>(Arrays.asList((String[])pid));
        }
        return specifiedPids;
    }

    public void remove(ServiceReference<?> ref) {
        List<List<String>> qualifiedPidLists = this.targetToQualifiedPids.remove(ref);
        if (qualifiedPidLists != null) {
            for (List<String> qualifiedPids : qualifiedPidLists) {
                for (String qualifiedPid : qualifiedPids) {
                    Collection<ServiceReference<?>> targets = this.qualifiedPidToTargets.get(qualifiedPid);
                    if (targets == null) continue;
                    targets.remove(ref);
                }
            }
        }
    }

    private Collection<ServiceReference<?>> getTargetsInternal(String pid) {
        Collection<ServiceReference<?>> targets = this.qualifiedPidToTargets.get(pid);
        if (targets == null) {
            targets = new ArrayList(1);
            this.qualifiedPidToTargets.put(pid, targets);
        }
        return targets;
    }

    List<ServiceReference<?>> getTargets(String qualifiedPid) {
        Collection<ServiceReference<?>> targets = this.qualifiedPidToTargets.get(qualifiedPid);
        return targets == null ? Collections.EMPTY_LIST : new ArrayList(targets);
    }

    List<List<String>> getQualifiedPids(ServiceReference<?> ref) {
        List<List<String>> pids = this.targetToQualifiedPids.get(ref);
        return pids == null ? Collections.EMPTY_LIST : pids;
    }
}

