DROP TABLE DGB_FILES;
DROP TABLE DGB_DOCUMENTS;
DROP TABLE DGB_BINARIES;
DROP TABLE DGB_SCHEMA_VERSIONS;


CREATE TABLE DGB_FILES ( -- the files and folders registry 
	FILE_PATH $KEY_VARCHAR$ NOT NULL PRIMARY KEY,
	FILE_NAME VARCHAR(255) NOT NULL,
	FILE_TYPE INTEGER NOT NULL, -- 0 folder, 1 document, 2 binary
	FILE_CONTENT_TYPE VARCHAR(64),
	FILE_CREATED_BY VARCHAR(32),
	FILE_CREATED_AT $TIMESTAMP$,
	FILE_MODIFIED_BY VARCHAR(32),
	FILE_MODIFIED_AT $TIMESTAMP$
);

CREATE TABLE DGB_DOCUMENTS ( -- the content of text files separated by chunks 
	DOC_FILE_PATH $KEY_VARCHAR$ NOT NULL,
	DOC_CONTENT $BIG_VARCHAR$,
	DOC_ORDER INTEGER NOT NULL,
	PRIMARY KEY (DOC_FILE_PATH, DOC_ORDER)
);

CREATE TABLE DGB_BINARIES ( -- the content of binary files
	BIN_FILE_PATH $KEY_VARCHAR$ NOT NULL,
	BIN_CONTENT $BLOB$,
	PRIMARY KEY (BIN_FILE_PATH)
);

CREATE TABLE DGB_SCHEMA_VERSIONS ( -- the version of the current repository schema
	SCHV_VERSION INTEGER NOT NULL,
	SCHV_DESCRIPTION $KEY_VARCHAR$,
	PRIMARY KEY (SCHV_VERSION)
);


INSERT INTO DGB_FILES (
	FILE_NAME, FILE_PATH, FILE_TYPE, FILE_CONTENT_TYPE, FILE_CREATED_BY, FILE_CREATED_AT, FILE_MODIFIED_BY, FILE_MODIFIED_AT)
	VALUES ('root', '/', 0,'', 'SYSTEM', $CURRENT_TIMESTAMP$, 'SYSTEM', $CURRENT_TIMESTAMP$);
	
DELETE FROM DGB_SCHEMA_VERSIONS;
INSERT INTO DGB_SCHEMA_VERSIONS (
	SCHV_VERSION, SCHV_DESCRIPTION)
	VALUES (1, 'Initial Creation');	

