/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.export;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.eclipse.dirigible.ide.datasource.DataSourceFacade;
import org.eclipse.dirigible.ide.db.export.DataDownloadDialog;
import org.eclipse.dirigible.ide.db.export.Messages;
import org.eclipse.dirigible.ide.db.export.TablesTemplateTablePageLabelProvider;
import org.eclipse.dirigible.repository.ext.db.transfer.TableName;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DataExportDialog
extends TitleAreaDialog {
    private static final long serialVersionUID = 1L;
    private static final String VIEW = "VIEW";
    private static final String TABLE = "TABLE";
    private static final String CLOSE = "Close";
    private static final String EXPORT = "Export";
    private static final String EXPORT_DATA = "Export Data";
    private static final String TABLE_TYPE = "TABLE_TYPE";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String EXPORT_AS_DSV_FILE = "Export as DSV File";
    private static final String SELECT_AVAILABLE_TABLE_FORM_THE_LIST = "Select Available Table From The List";
    private static final String AVAILABLE_TABLES_AND_VIEWS = Messages.DataExportDialog_AVAILABLE_TABLES_AND_VIEWS;
    private static final String ERROR_ON_LOADING_TABLES_FROM_DATABASE_FOR_GENERATION = Messages.DataExportServiceHandler_ERROR_WHILE_EXPORTING_DSV;
    private Button btnExport;
    private String selectedTableName;
    private static final Logger logger = Logger.getLogger(DataExportDialog.class);

    public DataExportDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle(EXPORT_DATA);
        this.setMessage(SELECT_AVAILABLE_TABLE_FORM_THE_LIST, 1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        final TableViewer typeViewer = DataExportDialog.createTableList(container);
        typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int selectionIndex = typeViewer.getTable().getSelectionIndex();
                TableName[] tables = (TableName[])typeViewer.getInput();
                if (selectionIndex >= 0) {
                    DataExportDialog.this.setSelectedTableName(tables[selectionIndex].getName());
                    DataExportDialog.this.btnExport.setEnabled(true);
                } else {
                    DataExportDialog.this.btnExport.setEnabled(false);
                }
            }
        });
        this.createExportButton(container);
        return area;
    }

    public static TableViewer createTableList(Composite container) {
        Label label = new Label(container, 0);
        label.setText(AVAILABLE_TABLES_AND_VIEWS);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        TableViewer typeViewer = new TableViewer(container, 2564);
        typeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        typeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        typeViewer.setLabelProvider((IBaseLabelProvider)new TablesTemplateTablePageLabelProvider());
        typeViewer.setSorter(new ViewerSorter());
        typeViewer.setInput((Object)DataExportDialog.getAvailableTables());
        return typeViewer;
    }

    private static TableName[] getAvailableTables() {
        ArrayList<TableName> availableTableNames = new ArrayList<TableName>();
        try {
            Connection connection = null;
            try {
                connection = DataSourceFacade.getInstance().getDataSource().getConnection();
                DatabaseMetaData meta = connection.getMetaData();
                ResultSet tableNames = meta.getTables(null, null, "%", null);
                while (tableNames.next()) {
                    String sTableName = tableNames.getString(TABLE_NAME);
                    String sTableType = tableNames.getString(TABLE_TYPE);
                    if (!TABLE.equals(sTableType) && !VIEW.equals(sTableType)) continue;
                    TableName tableName = new TableName(sTableName, sTableType);
                    availableTableNames.add(tableName);
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception e) {
            logger.error(ERROR_ON_LOADING_TABLES_FROM_DATABASE_FOR_GENERATION, (Throwable)e);
        }
        return availableTableNames.toArray(new TableName[0]);
    }

    private void createExportButton(Composite container) {
        Label lbtExport = new Label(container, 0);
        lbtExport.setText(EXPORT_AS_DSV_FILE);
        GridData dataSuffix = new GridData();
        dataSuffix.grabExcessHorizontalSpace = false;
        dataSuffix.horizontalAlignment = 1;
        this.btnExport = new Button(container, 8);
        this.btnExport.setLayoutData((Object)dataSuffix);
        this.btnExport.setText(EXPORT);
        this.btnExport.setEnabled(false);
        this.btnExport.addSelectionListener(new SelectionListener(){
            private static final long serialVersionUID = 1139810430273810538L;

            public void widgetSelected(SelectionEvent e) {
                DataDownloadDialog dataDownloadDialog = new DataDownloadDialog(e.display.getActiveShell());
                dataDownloadDialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected boolean isResizable() {
        return true;
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    private void saveInput() {
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, CLOSE, true);
    }

    public String getSelectedTableName() {
        return this.selectedTableName;
    }

    public void setSelectedTableName(String tableName) {
        this.selectedTableName = tableName;
    }
}

