/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.bridge;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.ide.bridge.DirigibleBridge;
import org.eclipse.dirigible.ide.bridge.IInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyParametersInjector
implements IInjector {
    private static final Logger logger = LoggerFactory.getLogger(ProxyParametersInjector.class);
    public static final String HTTP_PROXY_HOST = "http.proxyHost";
    public static final String HTTP_PROXY_PORT = "http.proxyPort";
    public static final String HTTPS_PROXY_HOST = "https.proxyHost";
    public static final String HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String HTTP_NON_PROXY_HOSTS = "http.nonProxyHosts";

    @Override
    public void injectOnRequest(ServletConfig servletConfig, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String parameterHTTP_PROXY_HOST = DirigibleBridge.ENV_PROPERTIES.getProperty(HTTP_PROXY_HOST);
        if (parameterHTTP_PROXY_HOST != null) {
            req.getSession().setAttribute(HTTP_PROXY_HOST, (Object)parameterHTTP_PROXY_HOST);
            logger.debug("HTTP_PROXY_HOST:" + parameterHTTP_PROXY_HOST);
        } else {
            logger.debug("HTTP_PROXY_HOST not set");
        }
        String parameterHTTP_PROXY_PORT = DirigibleBridge.ENV_PROPERTIES.getProperty(HTTP_PROXY_PORT);
        if (parameterHTTP_PROXY_PORT != null) {
            req.getSession().setAttribute(HTTP_PROXY_PORT, (Object)parameterHTTP_PROXY_PORT);
            logger.debug("HTTP_PROXY_PORT:" + parameterHTTP_PROXY_PORT);
        } else {
            logger.debug("HTTP_PROXY_PORT not set");
        }
        String parameterHTTPS_PROXY_HOST = DirigibleBridge.ENV_PROPERTIES.getProperty(HTTPS_PROXY_HOST);
        if (parameterHTTPS_PROXY_HOST != null) {
            req.getSession().setAttribute(HTTPS_PROXY_HOST, (Object)parameterHTTPS_PROXY_HOST);
            logger.debug("HTTPS_PROXY_HOST:" + parameterHTTPS_PROXY_HOST);
        } else {
            logger.debug("HTTPS_PROXY_HOST not set");
        }
        String parameterHTTPS_PROXY_PORT = DirigibleBridge.ENV_PROPERTIES.getProperty(HTTPS_PROXY_PORT);
        if (parameterHTTPS_PROXY_PORT != null) {
            req.getSession().setAttribute(HTTPS_PROXY_PORT, (Object)parameterHTTPS_PROXY_PORT);
            logger.debug("HTTPS_PROXY_PORT:" + parameterHTTPS_PROXY_PORT);
        } else {
            logger.debug("HTTPS_PROXY_PORT not set");
        }
        String parameterHTTP_NON_PROXY_HOSTS = DirigibleBridge.ENV_PROPERTIES.getProperty(HTTP_NON_PROXY_HOSTS);
        if (parameterHTTP_NON_PROXY_HOSTS != null) {
            req.getSession().setAttribute(HTTP_NON_PROXY_HOSTS, (Object)parameterHTTP_NON_PROXY_HOSTS);
            logger.debug("HTTP_NON_PROXY_HOSTS:" + parameterHTTP_NON_PROXY_HOSTS);
        } else {
            logger.debug("HTTP_NON_PROXY_HOSTS not set");
        }
    }

    @Override
    public void injectOnStart(ServletConfig servletConfig) throws ServletException, IOException {
    }
}

