/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.fullselect;

import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.ValuesRow;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Display;

public class ValueTableElement {
    ValuesRow valuesRow;
    SQLDomainModel domainModel;
    QueryValueExpression expression;
    List exprList;

    public ValueTableElement(SQLDomainModel model, ValuesRow valRow, QueryValueExpression expr) {
        this.domainModel = model;
        this.valuesRow = valRow;
        this.expression = expr;
    }

    public void removeExpression() {
        if (this.expression != null) {
            EList rowExprList = this.getValuesRow().getExprList();
            rowExprList.remove(this.expression);
        }
    }

    QueryValueExpression getExpression() {
        return this.expression;
    }

    public ValuesRow getValuesRow() {
        return this.valuesRow;
    }

    public String getColumnText(int columnIndex) {
        String colText = "";
        if (columnIndex == 0 && this.expression != null) {
            colText = this.expression.getSQL();
        }
        return colText;
    }

    public void modify(Object key, Object propValue) {
        if (key == SQLBuilderConstants.P_STATEMENT_VALUE) {
            if (propValue instanceof String && (((String)propValue).equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || ((String)propValue).equals(SQLBuilderConstants.P_EDIT_EXPRESSION) || ((String)propValue).equals(SQLBuilderConstants.P_REPLACE_EXPRESSION))) {
                QueryValueExpression expr = this.showExpressionBuilder(key, false, (String)propValue);
                if (expr != null) {
                    this.addExpression(expr);
                }
            } else if (propValue instanceof QueryValueExpression) {
                this.addExpression((QueryValueExpression)propValue);
            }
        }
    }

    void addExpression(QueryValueExpression newExpr) {
        EList rowExprList;
        if (this.valuesRow != null && (rowExprList = this.valuesRow.getExprList()) != null) {
            int position = rowExprList.indexOf(this.expression);
            if (position != -1) {
                rowExprList.add(position, newExpr);
            }
            rowExprList.add(newExpr);
        }
    }

    public QueryValueExpression showExpressionBuilder(Object key, boolean isColumn, String action) {
        ExpressionBuilderWizard wizard = new ExpressionBuilderWizard(this.domainModel, (SQLQueryObject)this.domainModel.getSQLStatement());
        if (key == SQLBuilderConstants.P_STATEMENT_VALUE) {
            if (action.equals(SQLBuilderConstants.P_BUILD_EXPRESSION) || action.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                wizard.setInputExpression(null);
            } else if (action.equals(SQLBuilderConstants.P_EDIT_EXPRESSION)) {
                if (this.expression != null) {
                    wizard.setInputExpression(this.expression);
                } else {
                    wizard.setInputExpression(null);
                }
            }
        }
        wizard.setIsColumn(isColumn);
        ExpressionBuilderDialog dialog = new ExpressionBuilderDialog(Display.getDefault().getActiveShell(), wizard);
        dialog.create();
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            return wizard.getSQLExpression();
        }
        return null;
    }
}

